/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** turbulencewidget.h
*/
#ifndef __TurbulenceWidget_H__
#define __TurbulenceWidget_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>

#include "../widgets/vectorwidget.h"
#include "../../3d/textures/turbulence.h"
#include <misc.h>
#include "texturewidgetbase.h"

class TurbulenceWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	Turbulence *tr,trb;

	VectorWidget *turb;
	SpinBox *octaves,*omega,*lambda;
	QSize	qs;	
	QLabel *oc,*om,*la;

public:

	TurbulenceWidget(QWidget *p,Turbulence *);
	~TurbulenceWidget();

	void getValue();

	void	paintEvent(QPaintEvent*);
        virtual QSize sizeHint() const;
};


#endif
