/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentdialog.cpp
*/

#include "warpwidget.moc"
#include "warpwidget.h"

#include <kapp.h>

warpWidget::warpWidget(QWidget *parent,warp *p) :
	TextureWidgetBase(parent,"warpWidget")
{
	wa=p;	
	
	tbasew=new TextureBaseWidget(this,wa );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}



warpWidget::~warpWidget()
{
	if (tbasew) delete tbasew;
}

void warpWidget::getValue()
{
	tbasew->getTextureBase();
}

QSize warpWidget::sizeHint() const
{
	return qs;
}

void warpWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0;


	tbasew->setGeometry(10,10,w,h);
	y+=15+h;

	qs.setWidth(w+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

warpDialog::warpDialog(QWidget *parent,warp *p) :
	QDialog(parent,"warpDialog",true)
{
	setCaption(i18n("warp"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new warpWidget(this,p);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

warpDialog::~warpDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void warpDialog::cancelPressed()
{
	QDialog::done(0);
}

void warpDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void warpDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	h+=h1+5;

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);
	if (qp) QDialog::paintEvent(qp);
}
