/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** tabwidget.h
*/
#ifndef __TabWidget_H__
#define __TabWidget_H__

#include <qwidget.h>
#include <qlabel.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <list.h>

#include <qlineedit.h>
#include <kfiledialog.h>
#include <qcombobox.h>
#include <drag.h>
#include <qsize.h>
#include <qwidgetstack.h>
#include <qtabbar.h>

class	 TabWidget : public QWidget
{
Q_OBJECT
protected:
	QTabBar *tab;
	QComboBox *combo;
	QLabel *label;
	QWidgetStack	*wstack;
	int mode,sel,innerHeight,innerWidth,layoutTab;
	QSize qs;

	list<QWidget*>	widgetlist;
	list<int>	ww;
	list<int>	wh;

public:
	TabWidget(QWidget *parent,const char*n="",int m=0,QWidget *s=NULL);

	~TabWidget();

	void	addWidget(QWidget *,int,char *);
	void	addWidget(QWidget *,int,const char *,int,int);
	void 	resizeWidget(int,int,int);

	int 	getLayoutTab();
	void 	setLayoutTab(int);

	void setSize(int,int);

	int	getSelected();
	virtual QSize	sizeHint() const;

public slots:
	void	paintEvent(QPaintEvent *);
	void	select(int);
	void setSize(QWidget *,int,int);
signals:
	void itemChanged( );
private slots:
	void selected(int);
};


#endif

