/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** xdata.h
*/
#ifndef __XDATA_H__
#define __XDATA_H__

#include <list.h>

class xdatacol;
class media;

class xdata
{
public:
	enum XD_TYPE
	{
		INVALID = -1,
		BOOL,
		CHAR,
		INT,
		DOUBLE,
		STRING,
	};

protected:
	char		*dataname;
	XD_TYPE		type;
	union
	{
		bool		vbool;
		char		vchar;
		int		vint;
		double		vdouble;
		const char	*vstring;
//		xdatacol	*vxdatacol;
	}
	data;

public:
	xdata(const char *name);
	~xdata();

	const char	*name();

	int		setData(bool value);
	int		setData(char value);
	int		setData(int value);
	int		setData(double value);
	int		setData(const char *value);

	int		getData(bool &value);
	int		getData(char &value);
	int		getData(int &value);
	int		getData(double &value);
	int		getData(const char *&value);
	
	int		isBool();
	int		isChar();
	int		isInt();
	int		isDouble();
	int		isString();
	
	int		save(media *,int ver);
	int		load(media *,int len,int ver);
};

class xdatacol
{
protected:
	char			*colname;
	list<xdata*>		datalist;

public:
	xdatacol(const char *name);
	~xdatacol();

	const char	*name();
	
	int		setData(const char *datename,bool value);
	int		setData(const char *datename,char value);
	int		setData(const char *datename,int value);
	int		setData(const char *datename,double value);
	int		setData(const char *datename,const char *value);

	int		getData(const char *datename,bool &value);
	int		getData(const char *datename,char &value);
	int		getData(const char *datename,int &value);
	int		getData(const char *datename,double &value);
	int		getData(const char *datename,const char *&value);
	
	int		removeData(const char *dataname);
	int		hasData(const char *dataname);

	int		isBool(const char *dataname);
	int		isChar(const char *dataname);
	int		isInt(const char *dataname);
	int		isDouble(const char *dataname);
	int		isString(const char *dataname);
	
	int		save(media *,int ver);
	int		load(media *,int len,int ver);
	
private:
	int		find(const char*);
};

class extradata
{
protected:
	list<xdatacol*>	collist;

public:
	extradata();
	~extradata();
	
	int		setData(const char *colname,const char *datename,bool value);
	int		setData(const char *colname,const char *datename,char value);
	int		setData(const char *colname,const char *datename,int value);
	int		setData(const char *colname,const char *datename,double value);
	int		setData(const char *colname,const char *datename,const char *value);

	int		getData(const char *colname,const char *datename,bool &value);
	int		getData(const char *colname,const char *datename,char &value);
	int		getData(const char *colname,const char *datename,int &value);
	int		getData(const char *colname,const char *datename,double &value);
	int		getData(const char *colname,const char *datename,const char *&value);
	
	int		removeData(const char *colname,const char *dataname);
	int		hasData(const char *colname,const char *dataname);
	int		hasDataCollection(const char *colname);

	int		isBool(const char *colname,const char *dataname);
	int		isChar(const char *colname,const char *dataname);
	int		isInt(const char *colname,const char *dataname);
	int		isDouble(const char *colname,const char *dataname);
	int		isString(const char *colname,const char *dataname);
	
	int		save(media *,int ver);
	int		load(media *,int len,int ver);
	
private:
	int		find(const char*);
};




#endif



