/* Originally written for kexample (C) 1998 Matthias Ettrich
 * Modified for KBlinsel
 */
#include "kblinsel.h"

#include <qkeycode.h>
#include <kiconloader.h>
#include <kseparator.h>

const int TOOLBAR_LOAD = 101;
const int TOOLBAR_SAVE = 102;
const int TOOLBAR_GEN  = 103;
const int TOOLBAR_PRINT = 104;
const int TOOLBAR_CONF = 105;
const int TOOLBAR_PATTERN =106;

KBlinsel::KBlinsel()
{
	view = new KBlinselWidget(this);
	
	// tell the KTMainWindow that this is indeed the main widget
	setView(view);

	// create a DropZone over the entire window and connect it
	// to the slotDropEvent
	connect(new KDNDDropZone(this , DndURL), 
	        SIGNAL(dropAction(KDNDDropZone *)), 
	        SLOT(slotDropEvent(KDNDDropZone *)));
	
	//---------------------------------------------------
	// build a menubar

	// a menubar consists of popup menus. So we need a 
	// popup menu first
        QPopupMenu* p = new QPopupMenu;
	p->insertItem(i18n("&Open..."), view, SLOT(loadImg()), CTRL+Key_L);
	p->insertItem(i18n("&Save as..."), view, SLOT(saveImg()), CTRL+Key_S);
	p->insertSeparator();
	p->insertItem(i18n("&Print..."), view, SLOT(printImg()), CTRL+Key_P);
	p->insertItem(i18n("Setup..."), view, SLOT(configure()));
	p->insertSeparator();
	p->insertItem(i18n("&Quit"), kapp, SLOT(quit()), CTRL+Key_Q);

	QPopupMenu* effects = new QPopupMenu;
	effects->insertItem(i18n("&Generate stereogram"), view, SLOT(genStereo()), CTRL+Key_G);

	// put the popupmenu as File-menu into the menu bar
	menuBar()->insertItem(i18n("&File"), p);
	menuBar()->insertItem(i18n("&Stereogram"), effects);
	menuBar()->insertSeparator();

	// we let KDE generate a nifty help menu
	p = kapp->getHelpMenu(true, 
			i18n("KBlinsel --- Generates Stereograms\n\n"
					"(c) 1999 Deiminger Tobias/Stephan Heigl \n"
					"Converts b&w \"3D\" pictures to stereograms"));
	menuBar()->insertItem(i18n("&Help"), p);

	toolBar()->insertButton(Icon("fileopen.xpm"),TOOLBAR_LOAD, true, i18n("Open..."));
	toolBar()->insertButton(Icon("filefloppy.xpm"),TOOLBAR_SAVE,true, i18n("Save as..."));
	toolBar()->insertButton(Icon("fileprint.xpm"),TOOLBAR_PRINT, true, i18n("Print..."));
	toolBar()->insertWidget( 54, 5, new KSeparator( QFrame::VLine, toolBar() ), -1); // Its a line separator :-)
	toolBar()->insertButton(*(new QPixmap(KApplication::kde_datadir()+"/kblinsel/pics/start.xpm")),TOOLBAR_GEN, true, i18n("Generate stereogram"));
        toolBar()->insertButton(*(new QPixmap(KApplication::kde_datadir()+"/kblinsel/pics/pattern.xpm")),TOOLBAR_PATTERN,true, i18n("Use Pattern y/n"));
	toolBar()->setToggle(TOOLBAR_PATTERN,true);
        toolBar()->insertWidget( 54, 5, new KSeparator( QFrame::VLine, toolBar() ), -1);
	toolBar()->insertButton(Icon("configure.xpm"),TOOLBAR_CONF,true,i18n("Configure..."));
	toolBar()->insertButton(Icon("exit.xpm"),TOOLBAR_EXIT, true,i18n("Exit"));
	toolBar()->alignItemRight(TOOLBAR_EXIT,true);

	connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));
	connect(toolBar(), SIGNAL(toggled(int)), SLOT(slotToolbarToggled(int)));
	statusbar = new KStatusBar(this);
	progress = new KProgress(0,100,0,KProgress::Horizontal,statusbar);
	//progress->setBarStyle(KProgress::Blocked);
	statusbar->insertItem("Render status:",0);
	statusbar->insertWidget(progress,200,1);
	setStatusBar(statusbar);
	enableStatusBar();

	connect(view,SIGNAL(pleasedraw()),SLOT(updateRects()));
	connect(kapp,SIGNAL(shutDown()),SLOT(theend()));
	
}

KBlinsel::~KBlinsel()
{
}

void KBlinsel::slotToolbarClicked(int item)
{
	switch (item)
	{
		case TOOLBAR_EXIT:
			kapp->quit();
			break;
		case TOOLBAR_LOAD:
			view->loadImg();
			break;
		case TOOLBAR_SAVE:
			view->saveImg();
			break;
		case TOOLBAR_PRINT:
			view->printImg();
			break;
		case TOOLBAR_GEN:
			progress->setValue(0);
			connect(&(view->algo),SIGNAL(renderStatus(int)),SLOT(showProgress(int)));
			view->genStereo();
			break;
		case TOOLBAR_CONF:
			view->configure();
			break;
	}
}

void KBlinsel::slotToolbarToggled(int item)
{
	switch (item)
	{
		case TOOLBAR_PATTERN:
			if(toolBar()->isButtonOn(TOOLBAR_PATTERN)==true) view->togglePattern(true);
			if(toolBar()->isButtonOn(TOOLBAR_PATTERN)==false) view->togglePattern(false);
			break;
	}
}

void KBlinsel::showProgress(int prg)
{
 progress->setValue((float)prg/(float)view->pm.height()*100);
 if((int)((float)prg/(float)view->pm.height()*100)>=99){ progress->setValue(0);}
}


void KBlinsel::slotDropEvent(KDNDDropZone *zone)
{
  QString u = zone->getURLList().first();
  u.remove(0,5);
  view->loadImg(&u);
}

void KBlinsel::theend()
{
 kapp->quit();
}
