
#define MEM 1
#define SWAP 2

#include <qmsgbox.h>
#include <qtimer.h> 

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream.h>

#include "kfdird.h"

#include "version.h"

//#include "kpov.h"
#include "kpov.moc"

/****
 *** Static
 **/

static char bildgr[BILDGROPTMAX][13] = {"-w320 -h200 ","-w640 -h480 ","-w800 -h600 ","-w1024 -h768","-w1152 -h864"};
static char bildgropt[BILDGROPTMAX+1][9] = {"320x200","640x480","800x600","1024x768","1152x864","custom"};
static int bildlines[BILDGROPTMAX]={200,480,600,768,864};
static char grformat[GRFORMATMAX][4] = {"+FC","+FN","+FP","+FT"};
static char grformatopt[GRFORMATMAX][19] = { "Compressed Targa","PNG","PPM","Uncompressed Targa"};
static char grformatsuf[GRFORMATMAX][5]={".tga",".png",".ppm",".tga"};

KPoV::KPoV()
{
  /****
   *** Menu
   **/

  QAccel *a = new QAccel( this );
  a->connectItem( a->insertItem( Key_F1 ), this, SLOT(help()) );

  QPopupMenu *filemenu = new QPopupMenu;
  filemenu->insertItem( klocale->translate( "Quit"), this, SLOT(quit()),CTRL+Key_Q );

  QPopupMenu *optionsmenu = new QPopupMenu;
  optionsmenu->insertItem(klocale->translate("Load Config"),this,SLOT(configfileload()));
  optionsmenu->insertItem(klocale->translate("Save Config"),this,SLOT(configfilesave()));

  /*
  QPopupMenu *helpmenu = new QPopupMenu;
  helpmenu->insertItem(klocale->translate("Help"), this,SLOT(help()));
  helpmenu->insertSeparator();
  helpmenu->insertItem(klocale->translate("About KDE..."), this,SLOT(aboutkde()));
  helpmenu->insertItem(klocale->translate("About Qt..."), this,SLOT(aboutqt()));
  helpmenu->insertItem(klocale->translate("About..."), this,SLOT(about));
  */

  QPopupMenu *helpmenu = kapp->getHelpMenu( true, "KPoV v0.1.5\n (c) 1997 Thomas Edelmann\n\nthomas.edelmann@stud.uni-erlangen.de" );


  menu = new KMenuBar( this );
  menu->insertItem( klocale->translate( "&File"), filemenu );
  menu->insertItem( klocale->translate( "&Options"),optionsmenu);
  menu->insertSeparator();
  menu->insertItem( klocale->translate( "&Help" ), helpmenu );
  setMenu( menu );

  tablistinclude = new KTabListBox(this,"tab_1");
  tablistinclude->setGeometry(XGRID_7,YGRID_4,350,110);
  //  tablistinclude->setColumn(0,"Include Dir's",399);
  tablistinclude->clearTableFlags();
  tablistinclude->setTableFlags (Tbl_smoothVScrolling | Tbl_autoVScrollBar);
  connect(tablistinclude,SIGNAL(highlighted(int,int)),this,SLOT(setdelinc(int,int)));

   /****
    *** StatusBar
    **/

   statuspov = new KStatusBar(this);
   statuspov->insertItem("Test Status Bar Fillup",1);
   statuspov->insertItem("Raytracing",2);
   statuspov->insertItem("Fehler KView",3);
   statuspov->changeItem("",1);
   statuspov->changeItem("",2);
   statuspov->changeItem("",3);
   statuspov->show();
   setStatusBar(statuspov);

   /****
    *** Labels
    **/

   labelaufloesung = new QLabel(this);
   labelaufloesung->setGeometry(XGRID_5, YGRID_9,80,25);
   labelaufloesung->setText("Auflsung:");

   labelformat = new QLabel(this);
   labelformat->setGeometry(XGRID_5, YGRID_10,80,25);
   labelformat->setText("Bildformat:");

   labelantial = new QLabel(this);
   labelantial->setGeometry(XGRID_5, YGRID_11,80,25);
   labelantial->setText("Antialiasing:");

   /****
    *** Combobox
    **/

   comboaufloesung = new QComboBox( FALSE, this, "ComboBox_1" );
   comboaufloesung->setGeometry (XGRID_7, YGRID_9, 100, 25 );
   comboaufloesung->setAutoResize( FALSE );
   for (i=0;i<=BILDGROPTMAX;i++)
     {comboaufloesung->insertItem(bildgropt[i]);}
   connect(comboaufloesung,SIGNAL(activated(int)),this,SLOT(aufloesung(int)));
   comboaufloesung->setCurrentItem(0);

   comboformat = new QComboBox( FALSE, this, "ComboBox_2" );
   comboformat->setGeometry (XGRID_7, YGRID_10, 150, 25 );
   comboformat->setAutoResize( FALSE );
   for (i=0;i<=GRFORMATMAX;i++)
     {comboformat->insertItem(grformatopt[i]);}
   connect(comboformat,SIGNAL(activated(int)),this,SLOT(bildformat(int)));
   comboformat->setCurrentItem(0);

   comboantial = new QComboBox( FALSE, this, "ComboBox_3" );
   comboantial->setGeometry( XGRID_7, YGRID_11, 100, 25 );
   comboantial->setAutoResize( FALSE );
   comboantial->insertItem("off");
   comboantial->insertItem("0.30");
   comboantial->insertItem("0.35");
   comboantial->insertItem("0.40");

   /****
    *** Buttons
    **/

   buttonmakecommand = new QPushButton( this, "PushButton_1" );
   buttonmakecommand->setGeometry( XGRID_5, YGRID_15, BREITE_1, HOEHE );
   buttonmakecommand->setText( "Make Command" );
   buttonmakecommand->setAutoRepeat( FALSE );
   buttonmakecommand->setAutoResize( FALSE );
   connect(buttonmakecommand,SIGNAL(clicked()),this,SLOT(makecommand()));

   buttonstartkview = new QPushButton( this, "PushButton_2" );
   buttonstartkview->setGeometry( XGRID_9, YGRID_15, BREITE_1, HOEHE );
   buttonstartkview->setText( "Start KView" );
   buttonstartkview->setAutoRepeat( FALSE );
   buttonstartkview->setAutoResize( FALSE );
   connect(buttonstartkview,SIGNAL(clicked()),this,SLOT(startKView()));

   buttonstartpov = new QPushButton( this, "PushButton_3" );
   buttonstartpov->setGeometry( XGRID_7, YGRID_15, BREITE_1, HOEHE );
   buttonstartpov->setText( "Start PoV" );
   buttonstartpov->setAutoRepeat( FALSE );
   buttonstartpov->setAutoResize( FALSE );
   connect(buttonstartpov,SIGNAL(clicked()),this,SLOT(startPOV()));

   buttonfile = new QPushButton( this, "PushButton_7" );
   buttonfile->setGeometry( XGRID_5, YGRID_2, 80, HOEHE);
   buttonfile->setText("PoV File");
   buttonfile->setAutoRepeat( FALSE );
   buttonfile->setAutoResize( FALSE );
   connect(buttonfile,SIGNAL(clicked()),this,SLOT(openfile()));

   buttonsave = new QPushButton( this, "PushButton_8" );
   buttonsave->setGeometry( XGRID_5, YGRID_3, 80, HOEHE);
   buttonsave->setText("Save As");
   buttonsave->setAutoRepeat( FALSE );
   buttonsave->setAutoResize( FALSE );
   connect(buttonsave,SIGNAL(clicked()),this,SLOT(savefile()));

   buttonincludedir = new QPushButton( this, "PushButton_9" );
   buttonincludedir->setGeometry( XGRID_5, YGRID_4, 80, HOEHE);
   buttonincludedir->setText("Add Include");
   buttonincludedir->setAutoRepeat( FALSE );
   buttonincludedir->setAutoResize( FALSE );
   connect(buttonincludedir,SIGNAL(clicked()),this,SLOT(openincludedir()));

   buttondelinclude = new QPushButton( this, "PushButton_9" );
   buttondelinclude->setGeometry( XGRID_5, YGRID_5, 80, HOEHE);
   buttondelinclude->setText("Del Include");
   buttondelinclude->setAutoRepeat( FALSE );
   buttondelinclude->setAutoResize( FALSE );
   connect(buttondelinclude,SIGNAL(clicked()),this,SLOT(delinclude()));

   buttonstartkedit = new QPushButton( this, "PushButton_2" );
   buttonstartkedit->setGeometry( XGRID_11, YGRID_15, BREITE_1, HOEHE );
   buttonstartkedit->setText( "Start KEdit" );
   buttonstartkedit->setAutoRepeat( FALSE );
   buttonstartkedit->setAutoResize( FALSE );
   connect(buttonstartkedit,SIGNAL(clicked()),this,SLOT(startKEdit()));

   /****
    *** Textfelder
    **/

   textinfile = new KLined(this,"KLined_1");
   textinfile->setGeometry(XGRID_7, YGRID_2,350,25);
   textinfile->setText("nicht festgelegt");

   textoutfile = new KLined(this,"KLined_2");
   textoutfile->setGeometry(XGRID_7, YGRID_3,350,25);
   textoutfile->setText("nicht festgelegt");

   textcommand = new KLined(this,"KLined_4");
   textcommand->setGeometry(XGRID_2, YGRID_13,600,25);
   textcommand->setText("");

   textcustomx = new KLined(this,"KLined_5");
   textcustomx->setGeometry(XGRID_10, YGRID_9,50,25);
   textcustomx->setText("");
   textcustomx->setEnabled(FALSE);

   textcustomy = new KLined(this,"KLined_6");
   textcustomy->setGeometry(XGRID_12, YGRID_9,50,25);
   textcustomy->setText("");
   textcustomy->setEnabled(FALSE);

   /****
    *** RadioButton
    **/

   QGroupBox* gbox1;
   gbox1 = new QGroupBox( this, "GroupBox_1" );
   gbox1->setGeometry( XGRID_2-10, YGRID_2-10, 100, 140 );
   gbox1->setMinimumSize( 0, 0 );
   gbox1->setMaximumSize( 32767, 32767 );
   gbox1->setFrameStyle( 33 );
   gbox1->setTitle( "" );
   gbox1->setAlignment( 1 );


   cboxPOV = new QCheckBox( this, "RadioButton_1" );
   cboxPOV->setGeometry( XGRID_2, YGRID_2, 170, 30 );
   cboxPOV->setText( "Start PoV" );
   cboxPOV->setAutoResize( TRUE );
   cboxPOV->setChecked(TRUE);

   cboxVerbose = new QCheckBox( this, "RadioButton_2" );
   cboxVerbose->setGeometry( XGRID_2, YGRID_3, 170, 30 );
   cboxVerbose->setText( "Verbose" );
   cboxVerbose->setAutoResize( TRUE );
   cboxVerbose->setChecked(TRUE);

   cboxPause = new QCheckBox( this, "RadioButton_3" );
   cboxPause->setGeometry( XGRID_2, YGRID_4, 170, 30 );
   cboxPause->setText( "Pause" );
   cboxPause->setAutoResize( TRUE );
   cboxPause->setChecked(TRUE);

   cboxDisplay = new QCheckBox( this, "RadioButton_4" );
   cboxDisplay->setGeometry( XGRID_2, YGRID_5, 170, 30 );
   cboxDisplay->setText( "Display" );
   cboxDisplay->setAutoResize( TRUE );
   cboxDisplay->setChecked(TRUE);

   /****
    *** Progress
    **/

   progress = new KProgress( this, "Progress_1" );
   progress->setGeometry( XGRID_2, YGRID_14, 600, 25);
   progress->setFont(QFont("Helvetica",12,QFont::Normal));
   progress->setBarColor(QApplication::winStyleHighlightColor());

   /****
    *** Options
    **/

   startoptions1 = bildgr[0];  
   startoptions2 = grformat[0];  
   linien = bildlines[0];
   
   ismarkedinclude = false;
}

KPoV::~KPoV() 
{ 
  delete statuspov;

}


void KPoV::help()
{
  kapp->invokeHTMLHelp("kpov/kpov.html","");
}

void KPoV::aufloesung(int id)
{
  if (id==5)
    {
      textcustomx->setEnabled(TRUE);
      textcustomy->setEnabled(TRUE);
    }
  else
    {
      textcustomx->setEnabled(FALSE);
      textcustomy->setEnabled(FALSE);
    }
  startoptions1 = bildgr[id];  
  linien = bildlines[id];
}

void KPoV::bildformat(int id)
{
  QFileInfo filepathname; 
  QString path,name;
  QString newname;

  startoptions2 = grformat[id];  
  filepathname = textoutfile->text();
  path = filepathname.dirPath();
  name = filepathname.baseName();
  newname += "/";
  newname += path;
  newname += name;
  newname += grformatsuf[id];
  textoutfile->setText(newname);
}

void KPoV::configfilesave()
{
  char nummer = '1';
  QString include;

  config = kapp->getConfig();
  config->setGroup("GeneralData");
  config->writeEntry("Infile",textinfile->text());
  config->writeEntry("Outfile",textoutfile->text());
  config->writeEntry("Startpov",cboxPOV->isChecked());
  config->writeEntry("Verbose",cboxVerbose->isChecked());
  config->writeEntry("Pause",cboxPause->isChecked());
  config->writeEntry("Display",cboxDisplay->isChecked());
  config->writeEntry("Version",KPOV_VERSION);
  config->writeEntry("Include#",tablistinclude->count());
  for(uint i=0;i<tablistinclude->count();i++)
    {
      include = "Include";
      include += nummer;
      nummer++;
      config->writeEntry(include,tablistinclude->text(i));
    }

}

void KPoV::configfileload()
{
  char nummer='1';
  QString include;

  config = kapp->getConfig();
  config->setGroup("GeneralData");
  textinfile->setText(config->readEntry("Infile","/"));
  textoutfile->setText(config->readEntry("Outfile","/"));
  cboxPOV->setChecked(config->readNumEntry("Startpov",0));
  cboxVerbose->setChecked(config->readNumEntry("Verbose",0)); 
  cboxPause->setChecked(config->readNumEntry("Pause",0));
  cboxDisplay->setChecked(config->readNumEntry("Display",0));
  for(int i=0;i<config->readNumEntry("Include#",0);i++)
    {
      include = "Include";
      include += nummer;
      nummer++;
      tablistinclude->appendItem(config->readEntry(include,"/"));
    }
}

void KPoV::makecommand()
{
  QString text;
  counter=0;

  text += "-i";
  text += textinfile->text();
  text += " -o";
  text += textoutfile->text();

  for (uint i=0;i<tablistinclude->count();i++)
    { 
      text += " +L";
      text += tablistinclude->text(i);
    }


  text += " ";
  text += startoptions1;
  text += startoptions2;
  if (strcmp(comboantial->currentText(),"off"))
    {
      text += " +A";
      text += comboantial->currentText();
    }
  if (cboxVerbose->isChecked()==TRUE)
    {
      text += " +V";
    }
  if (cboxPause->isChecked()==TRUE)
    {
      text += " +P";
    }
  if (cboxDisplay->isChecked()==TRUE)
    {
      text += " +D";
    }

    textcommand->setText(text);

}

void KPoV::startPOV()
{
  if (cboxPOV->isChecked()==TRUE)
    {
      statuspov->changeItem("Raytracing",2);
      statuspov->changeItem("",3);
      progress->setRange(0,linien-1);
      progress->setValue(0);
      proc = new KProcess;
      proc->setExecutable("x-povray");

      *proc << textcommand->text();
      bool result = proc->start(KProcess::NotifyOnExit , KProcess::All);
      
      if (!result) {statuspov->changeItem("Fehler POV",3);}

      connect(proc, SIGNAL(processExited(KProcess *)),this, SLOT(done(KProcess*)));

      connect(proc, SIGNAL(receivedStderr(KProcess *,char*,int)),this,
	      SLOT(readStdout(KProcess*,char*,int)));
    }
}

void KPoV::done(KProcess*){

  statuspov->changeItem("",2);
  statuspov->changeItem("",1);

 if(proc){
    if(proc->isRunning())
      proc->kill();
  }

  delete proc;
  proc = 0L;
}

void KPoV::readStdout(KProcess *, char *buffer, int buflen){

  char mybuffer[1001];
  int amount;
  bool  increment = false;

  if(buflen > 1000)
    amount = 1000;
  else
    amount = buflen;

  memcpy(mybuffer,buffer,amount);
  mybuffer[amount] = '\0';

  formatstring = mybuffer;

  if(formatstring.contains("Rendering line"))
    {
      increment=true;
      int pos = formatstring.find("of");
      QString newstring1;
      QString newstring2;
      QString newstring3;
    
      newstring1=formatstring.mid(pos+2,6);
      newstring2=formatstring.mid(pos-6,6);
      newstring3 += newstring2;
      newstring3 += " von ";
      newstring3 += newstring1;
      statuspov->changeItem(newstring3,1);
    }

  if(increment)
    {
      counter++;
      progress->setValue(counter);     
    }
  
}

void KPoV::startKView()
{
  statuspov->changeItem("",3);
  proc = new KProcess;
  proc->setExecutable("kview");
  
  *proc << textoutfile->text();
  bool result = proc->start(KProcess::DontCare , KProcess::NoCommunication);

  if (!result){statuspov->changeItem("Fehler KView",3);}
}

void KPoV::startKEdit()
{
  statuspov->changeItem("",3);
  proc = new KProcess;
  proc->setExecutable("kedit");
  
  *proc << textinfile->text();
  bool result = proc->start(KProcess::DontCare , KProcess::NoCommunication);

  if (!result){statuspov->changeItem("Fehler KEdit",3);}
}

void KPoV::quit()
{
kapp->quit(); 
}

void KPoV::openfile()
{
  QString strFile;
  
  strFile = QFileDialog::getOpenFileName( NULL, "*.pov", this );
  textinfile->setText(strFile);
}

void KPoV::savefile()
{
  QString strFile;
  
  strFile = QFileDialog::getSaveFileName( NULL, "*.tga", this );
  textoutfile->setText(strFile);
}

void KPoV::openincludedir()
{
  dirtree = new KfDirDialog("/",this,"Tree_1",TRUE);
  dirtree->show();
  QString strFile = dirtree->selectedDir(  );
  tablistinclude->appendItem(strFile);
}

void KPoV::setdelinc(int id,int id2)
{
  id2 = 0; // sorry ;-)
  markedinclude = id;
  ismarkedinclude = true;
}

void KPoV::delinclude()
{
  if (ismarkedinclude)
    {
      tablistinclude->removeItem(markedinclude);
      ismarkedinclude = false;
    }
}

void KPoV::about()
{
  KMsgBox::message(0, "About KPoV\n", "KPoV " 
		      KPOV_VERSION
		      "\nThomas Edelmann\nPoV Frontend\n\n" 
		      "Thomas.Edelmann@stud.uni-erlangen.de, Nov 1997");
}

void KPoV::aboutqt()
{
  QMessageBox::aboutQt(this);
}

int main( int argc, char **argv )
{
    KApplication a( argc, argv,"kpov" );
    KPoV kpov;
    a.setMainWidget( &kpov );
    kpov.resize(700,500);
    kpov.show();
    return a.exec();
}
