// -*- C++ -*-
//--------------------------------------------------------------------
// KRay Version 0.1
//
// File: screen.h
//
// Classes: Screen
//
// Purpose: This is the widget which holds the picture
//--------------------------------------------------------------------
#ifndef __screen_h
#define __screen_h

#include <qwidget.h>
#include <kprocess.h>

class Screen : public QWidget
{
  Q_OBJECT
public:
  Screen( uint xsize, uint ysize, 
	  int arg1, int arg2, int arg3, int arg4, int arg5,
	  QWidget* parent = NULL, const char* name = NULL );
  virtual ~Screen();
public slots:
  void pictureFinished(KProcess*);
  void paintPixel(KProcess*, char* pixel, int strlength);
  void drawPixel(int, int, int, int, int);
  void paintEvent( QPaintEvent* paintEvent);

private:
  QPixmap* pixmap;
  QColor* color;
  KProcess* proc;
  QString* picString;
};
#endif // screen_included
