/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "kscan.h"
#include <qvalidator.h>
#include <qlayout.h>

#include "preferences.h"

Preferences::Preferences(KConfig *kc,bool *acquire_at_start,
			     int *maxdpi):
	QDialog(NULL,NULL,TRUE),kconf(kc)
{
	char s[100];
	sprintf(s,"%d",*maxdpi);
	p_ac = acquire_at_start;
	p_dpi = maxdpi;
	ac_b = new QCheckBox("Acquire the preview at startup",this,"acqps");
	ac_b->setChecked(*acquire_at_start);
	ac_b->setMinimumSize(ac_b->sizeHint());
	QLabel *lb = new QLabel("Maximal DPI for your scanner",this,"maxdpi");
	lb->setMinimumSize(lb->sizeHint());
	dpi_e = new QLineEdit(this,"dpi_e");
	QIntValidator *v = new QIntValidator(1,100000,this,"dval");
	dpi_e->setValidator(v);
	dpi_e->setMaxLength(6);
	dpi_e->setText(s);
	dpi_e->setMinimumSize(dpi_e->sizeHint());
	dpi_e->setMinimumWidth(60);
	QPushButton *ok = new QPushButton("OK",this,"ok");
	QPushButton *cancel = new QPushButton("Cancel",this,"cancel");
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	ok->setMinimumHeight(30);
	cancel->setMinimumHeight(30);
	//setFixedWidth(KApplication::desktop()->width()/3);
	QVBoxLayout l(this);
	QHBoxLayout m;
	QHBoxLayout l2;
	l.addSpacing(10);
	l.addWidget(ac_b);
	l.addSpacing(10);
	l.addLayout(&m);
	l.addSpacing(10);
	l.addLayout(&l2);
	m.addWidget(lb);
	m.addWidget(dpi_e);
	l2.addStretch(1);
	l2.addWidget(ok,2);
	l2.addStretch(1);
	l2.addWidget(cancel,2);
	l2.addStretch(1);
	l.addStretch(1);
	l.activate();
	adjustSize();
	//printf("done...\n");
}

void Preferences::done(int r)
{
	if(r) {
		int dpi = atoi(dpi_e->text());
		if(dpi<1||dpi>100000) {
			QMessageBox::critical(NULL,"Error",
					      "Bad DPI value");
			QDialog::done(FALSE);
		}
		*p_dpi = dpi;
		kconf->writeEntry(OP_MAXDPI,dpi);
		*p_ac = ac_b->isChecked();
		kconf->writeEntry(OP_ACQUIRE,*p_ac);
	}
	QDialog::done(r);
}

#include "preferences.moc"
