#!/usr/bin/perl

sub resetState {
  $name = "";
  @propNames= ();
  @propTypes= ();
  @sourceTypes= ();
  @setters= ();
  @getters= ();
}

sub emit {
  print "Component($name) {\n";

  foreach $prop (@propNames) {
    print $prop."\n";
  }

  print "}\n";
}

# Main
resetState();

while(<>) {
  if (/^component\s+\"(\w+)\"/i) {
    $name= $1;
  }
  elsif (/^end_component\b/i) {
    emit();
    resetState();
  }
  elsif (/^property\s+\"(\w+)\"/i) {
    push(@propNames, $1);
  }
  elsif (/^end_property\b/i) {

  }
  elsif (/^type\s+\"(\w+)\"/i) {
    push(@propTypes, $1);
  }
  elsif (/^sourcetype\s+\"(\w+)\"/i) {
    push(@sourceTypes, $1);
  }
  elsif (/^getter\s+\"(.*?)\"/i) {
    push(@getters, $1);
  }
  elsif (/^setter\s+\"(.*?)\"/i) {
    push(@setters, $1);
  }
  elsif (/^#/) {

  }
  elsif (/^\s*$/) {
  }
  else {
    warn "Syntax error $.\n";
  }
}
