/***************************************************************************
                          boolvalue.h  -  description                              
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BOOLVALUE_H
#define BOOLVALUE_H

#include <value.h>

/**
	* Represents bool values.
	*
  * @author Richard Moore
  */
class BoolValue : public Value  {
public: 
	BoolValue();
	~BoolValue();

	virtual ValueEditor *createEditor(QWidget *);

	bool boolValue();
	void setValue(bool);

	/**
		* Convert the value to a string.
		*/
	virtual const char *toString();

	/**
		* Set the value from a string.
		*/
	virtual void fromString(const char *);
protected:
	bool val;
	QString valueStr;
};

#endif

