/***************************************************************************
                          boolvalueeditor.h  -  description                              
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BOOLVALUEEDITOR_H
#define BOOLVALUEEDITOR_H

#include <qwidget.h>
#include "valueeditor.h"
#include "boolvalue.h"

class QCheckBox;

/**
	* Edit bool values using a checkbox.
	*
  * @author Richard Moore
  */
class BoolValueEditor : public ValueEditor  {
   Q_OBJECT
public: 
	BoolValueEditor(QWidget *parent, const char *name, BoolValue *);
	~BoolValueEditor();
	
signals:
	void cancelled();
	void accepted();
	void accepted(Value *);
	void resized();

protected:
	virtual void saveValue();

protected slots:
	void checkToggled(bool);

private:
	QCheckBox *checkBox;
};

#endif


