/***************************************************************************
                          colourvalueeditor.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Apr 8 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <kcolordlg.h>
#include "colourvalueeditor.h"

// The width of the '...' button
static const int DLG_BUTTON_WIDTH= 20;

ColourValueEditor::ColourValueEditor(QWidget *parent, const char *name, ColourValue *v )
	: ValueEditor(parent,name)
{
	warning("Creating ColourValueEditor");
	setValue(v);

	lineEdit= new QLineEdit(this);
	CHECK_PTR(lineEdit);

	dlgButton= new QPushButton(this);
	CHECK_PTR(dlgButton);
	dlgButton->setText("...");
	connect( dlgButton, SIGNAL(clicked()), this, SLOT(showDialog()) );

	// Using the sizeHint seems to make the button far to big, so we hard code the value (urghh!)
	//	dlgButton->setFixedWidth(dlgButton->sizeHint().width());
	dlgButton->setFixedWidth(DLG_BUTTON_WIDTH);

	QHBoxLayout *layout= new QHBoxLayout(this);
	layout->addWidget(lineEdit);
	layout->addWidget(dlgButton);
	layout->activate();

	lineEdit->setText(value()->toString());
	lineEdit->setFocus();
}

ColourValueEditor::~ColourValueEditor()
{
}

void ColourValueEditor::saveValue()
{
	QString t= lineEdit->text();
	value()->fromString(t);
}

// SLOT
void ColourValueEditor::showDialog()
{
	warning("Displaying colour dialog");

	ColourValue *cv= (ColourValue *) value();

	QColor c;
	c= cv->color();
	int result = KColorDialog::getColor( c );
	if (result) {
	  cv->setColor(c);
		lineEdit->setText(cv->toString());
		emit accepted(cv);
	}
}


