/***************************************************************************
                          component.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Mar 16 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kapp.h>
#include <kiconloader.h>
#include <qwidget.h>
#include "component.h"
#include "instance.h"

#define MINIICON(x) kapp->getIconLoader()->loadMiniIcon(x)

Component::Component(const char *name, const char *description, Package *provider)
	: QObject(),
		name_(name),
		description_(description)
{
	this->provider= provider;
}

Component::~Component()
{
}

QPixmap Component::pixmap()
{
	QString folder("folder.xpm");

	return MINIICON(folder);
}

const char *Component::description()
{
	return description_.data();
}

const char *Component::name()
{
	return name_.data();
}

Package *Component::package()
{
	return provider;
}

void Component::setPackage(Package *provider)
{
	this->provider= provider;
}

Component *Component::super(uint n)
{
	return supers.at(n);
}

void Component::addSuper(Component *c)
{
	ASSERT(c);

	supers.append(c);
}

uint Component::superCount()
{
	return supers.count();
}

Instance *Component::createInstance(Instance *parent)
{
	return 0;
}

QWidget *Component::createView(Instance *props, QWidget *parent)
{
	ASSERT(parent);
	ASSERT(props);
	
	warning("Default Component::createView() called");
	
	QWidget *view= new QWidget(parent);
	CHECK_PTR(view);

	for (uint i= 0; i < props->childCount(); i++) {
		warning("++ Creating child %d", i);
		
		// Handle the top child
		Instance *child= props->getChild(i);
	
		// Recurse into the child's createView() method
		QWidget *childView= child->createView(view);
		
		if (!childView) {
			warning("Failed to create child %d", i);
		}
	}	
		
	updateView(props, view);
		
	return view;
}

void Component::updateView(Instance *props, QWidget *view)
{
	ASSERT(view);
	ASSERT(props);

	for (uint i= 0; i < props->childCount(); i++) {
		warning("++ Creating child %d", i);
		
		// Handle the top child
		Instance *child= props->getChild(i);
	
		// Recurse into the child's createView() method
		QWidget *childView= child->updateView(view);
		
		if (!childView) {
			warning("Component::updateView() received null childView");
		}
	}	
}









