/***************************************************************************
                          package.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Mar 20 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "component.h"
#include "global.h"
#include "package.h"

static const char *DEFAULT_HELP_URL= "http://www.kde.org/";

Package::Package(const char *name, const char *desc, const char *helpURL)
	: name_(name),
		desc_(desc),
		helpURL_(DEFAULT_HELP_URL),
		components()
{
	if (helpURL) {
		helpURL_= helpURL;
	}
}

Package::~Package()
{
}

const char *Package::name()
{
	return name_.data();
}

const char *Package::description()
{
	return desc_.data();
}

const char *Package::helpURL()
{
	return helpURL_.data();
}

QPixmap Package::pixmap()
{
	QString folder("folder.xpm");

	return MINIICON(folder);
}

void Package::addComponent(Component *c)
{
	ASSERT(c);

	components.append(c);
	c->setPackage(this);
}

uint Package::componentCount()
{
	return components.count();
}

Component *Package::component(uint n)
{
	ASSERT(n >= 0);

	return components.at(n);
}


