/***************************************************************************
                          propertydialog.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Mar 21 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "propertydialog.h"
#include "instance.h"

PropertyDialog::PropertyDialog(QWidget *parent, const char *name )
	: QTabDialog(parent,name)
{
	current= 0;

	// Create the generic page
	genericView= new PropertyListView(this);
	CHECK_PTR(genericView);

	addTab(genericView, "&Generic");

	// We don't want any buttons
	setApplyButton(0);
	setOkButton(0);
}

PropertyDialog::~PropertyDialog()
{
}

void PropertyDialog::setInstance(Instance *i)
{
	current= i;
	genericView->setInstance(i);
}


PropertyListView *PropertyDialog::listView()
{
	return genericView;
}

