/***************************************************************************
                          propertytree.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Mar 16 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qrect.h>
#include <qheader.h>
#include <qpoint.h>
#include <kapp.h>

#include "propertytree.h"
#include "instance.h"
#include "component.h"

static const int BORDER_WIDTH= 4;

PropertyListView::PropertyListView(QWidget *parent, const char *name)
	: QListView(parent, name),
		editedProperty()
{
	addColumn("Name");
	addColumn("Value");
	editing= false;
	editor= 0;
	current= 0;
	editedValue= 0;

	connect( this,	SIGNAL( doubleClicked(QListViewItem *) ),
									SLOT( editPropertyItem(QListViewItem *) ) );
	connect( this,	SIGNAL( returnPressed(QListViewItem *) ),
									SLOT( editPropertyItem(QListViewItem *) ) );
//	connect( this,	SIGNAL( selectionChanged(QListViewItem *) ),
//									SLOT( editPropertyItem(QListViewItem *) ) );

	connect( this,	SIGNAL(rightButtonPressed(QListViewItem *, const QPoint &, int) ),
									SLOT(showPopup(QListViewItem *, const QPoint &) ) );

	setFocusPolicy(QWidget::StrongFocus);
	header()->setMovingEnabled(false);
}

PropertyListView::~PropertyListView()
{
	if (editor)
		delete editor;
}

void PropertyListView::setInstance(Instance *inst)
{
	if (editing) {
		editor->accept();
		editing= false;
		delete editor;
		editor= 0;
	}

	current= inst;
	refresh();
}

void PropertyListView::refresh()
{
	QListViewItem *item;

	clear();

	if (current) {
		for (uint i= 0; i < current->propertyCount(); i++) {
			const char *name= current->propertyName(i);
			item= new QListViewItem(this);

			warning("Adding %s", name);
			item->setText(0, name);

			Value *v= current->get(name);

			if (v->hasPixmapView()) {
				warning("Creating pix view (i is %d)", i);
				QPixmap *p= v->toPixmap(columnWidth(1) - BORDER_WIDTH, 10);
				warning("pixmap is %p", p);
				item->setPixmap(1, *p);
			}
			else {
				warning("Creating text view");
				item->setText(1, v->toString());
			}
		}
	}
}

// SLOT
void PropertyListView::editPropertyItem(QListViewItem *item)
{
	if (editing) {
		editor->accept();
	}
	else if ((item != 0) && current){
		editing= true;
		warning("Edit item!!!");
		editedProperty= item->text(0);
		editedValue= current->get(editedProperty);
		editor= editedValue->createEditor(this);

		connect( editor, SIGNAL(cancelled()), SLOT(cancelEdit()) );
		connect( editor, SIGNAL(accepted(Value *)), SLOT(acceptEdit(Value *)) );

		// Ensure the item is visible
		item->listView()->ensureItemVisible(item);

		// Get the rect of the item
		QRect itemRect= item->listView()->itemRect(item);

		// Correct for the height of the header
		QHeader *header= item->listView()->header();
		itemRect.moveBy(0, header->height());

		// Correct for the width of column
		int w0= item->listView()->columnWidth(0);
		int w1= item->listView()->columnWidth(1);
		itemRect.setWidth( w1 );
		itemRect.moveBy(w0, 0);

		// Move the editor into place
		if (itemRect.isValid()) {
			editor->setGeometry(itemRect);
		}
		else {
			warning("Invalid item rect");
		}

		editor->show();
	}
}

// SLOT
void PropertyListView::cancelEdit()
{
	warning("slot cancelEdit()");

	editing= false;
	editedValue= 0; // Don't delete (we don't own it)
	delete editor;
	editor= 0;

	refresh();
	setFocus();
}

// SLOT
void PropertyListView::acceptEdit(Value *v)
{
	warning("slot acceptEdit(Value *%p) -->%s<--", v, v->toString());

	current->set(editedProperty, v);
	editing= false;
	editedValue= 0; // Don't delete (we don't own it)
	delete editor;
	editor= 0;

	emit edited(current);
	
	refresh();
	setFocus();
}

// SLOT
void PropertyListView::showPopup(QListViewItem *item, const QPoint &pos)
{
	if (item) {
		QPopupMenu *rmbMenu= new QPopupMenu();
		CHECK_PTR(rmbMenu);

		QString s;
		
		if (current) {
			s.sprintf(i18n("Help on %s..."), current->component()->name());
		
		 	rmbMenu->insertItem(s, 0);
	 	}
	 	else {
		 	rmbMenu->insertItem(i18n("Help..."), 0);
	 	}
 		rmbMenu->exec(pos);
	
		delete rmbMenu;
	}
}





































