/***************************************************************************
                          propertytree.h  -  description                              
                             -------------------                                         
    begin                : Tue Mar 16 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PROPERTYTREE_H
#define PROPERTYTREE_H

#include <qlistview.h>
#include <qstring.h>

class QPoint;

class Instance;
class ValueEditor;
class Value;

/**
	* A QListView that displays the properties of an Instance organised by
	* the inheritance hierarchy.
	*
  * @author Richard Moore
  */
class PropertyListView : public QListView  {
	Q_OBJECT

public:
	/**
		* Create the property listview.
		*/
	PropertyListView(QWidget *parent, const char *name= 0);
	~PropertyListView();

public slots:

	void refresh();
	void editPropertyItem(QListViewItem *);
	void cancelEdit();
	void acceptEdit(Value *);
	void showPopup(QListViewItem *, const QPoint &);

	/**
		* Set the instance that will have its properties displayed.
		*/
	void setInstance(Instance *inst);

signals:
	void rightButtonPressed( QListViewItem *, const QPoint&, int );
	void rightButtonClicked( QListViewItem *, const QPoint&, int );
	void edited(Instance *);
	
private:
	class Instance *current;
	bool editing;
	ValueEditor *editor;
	Value *editedValue;
	QString editedProperty;
};

#endif
























