/***************************************************************************
                          stringvalueeditor.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Mar 27 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qlayout.h>
#include "stringvalueeditor.h"

StringValueEditor::StringValueEditor(QWidget *parent, const char *name, StringValue *v )
	: ValueEditor(parent,name)
{
warning("Creating StringValueEditor");
	setValue(v);

	lineEdit= new QLineEdit(this);
	CHECK_PTR(lineEdit);

	QHBoxLayout *layout= new QHBoxLayout(this);
	layout->addWidget(lineEdit);
	layout->activate();

	lineEdit->setText(value()->toString());
	lineEdit->setFocus();
}

StringValueEditor::~StringValueEditor()
{
}

void StringValueEditor::saveValue()
{
	QString t= lineEdit->text();
	value()->fromString(t);
}











