/***************************************************************************
                          valueeditor.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Mar 20 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include <qapp.h>
#include <qkeycode.h>
#include "valueeditor.h"

ValueEditor::ValueEditor(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	QAccel *a = new QAccel(this);
	a->connectItem( a->insertItem(Key_Escape),
									this,
									SLOT(cancel()) );
	a->connectItem( a->insertItem(Key_Enter),
									this,
									SLOT(accept()) );
	val= 0;
}

ValueEditor::~ValueEditor()
{
}

void ValueEditor::saveValue()
{
	warning("default saveValue() called");
}

// SLOT
void ValueEditor::accept()
{
	warning("Accepting");
	saveValue();

	emit accepted();
	emit accepted(value());
}

// SLOT
void ValueEditor::cancel()
{
	warning("Cancelling");
	emit cancelled();
}

void ValueEditor::resizeEvent(QResizeEvent *)
{
	emit resized();
}

void ValueEditor::setValue(Value *v)
{
	ASSERT(v);
	val= v;
}

Value *ValueEditor::value()
{
	return val;
}






















