/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "vkbox.h"
#include "vkbox.moc"

CPBox::CPBox ( QString label_text, int iconCode,
	QString myCaption,
	QString firstButton, QString secondButton, QString thirdButton,
	QString fourthButton, const char *name )
		: QDialog ( 0, name, TRUE, 0 )
{
int myWidth;

	answer = 0;

	fiB = firstButton;
	seB = secondButton;
	thB = thirdButton;
	foB = fourthButton;

	b1 = new QPushButton ( fiB, this );
	b2 = new QPushButton ( seB, this );
	b3 = new QPushButton ( thB, this );
	b4 = new QPushButton ( foB, this );

	label = new QLabel ( "", this );

	// Width, buttons geometry and buttons text:
	myWidth = getMyWidth( label_text );

	setMyHeight( label_text, myWidth ); // Height and text

	if ( myCaption != "" ) setCaption ( myCaption );
		//else caption is name of executable file

	connect ( b1, SIGNAL(clicked()), SLOT(fibP()) );
	connect ( b2, SIGNAL(clicked()), SLOT(sebP()) );
	connect ( b3, SIGNAL(clicked()), SLOT(thbP()) );
	connect ( b4, SIGNAL(clicked()), SLOT(fobP()) );

	b1->setFocus();

	show();
}

int CPBox::getMyWidth( QString text )
{
const int optWidth = 400;
int minWidth = 200;
int useWidth = minWidth;

int buttonWidth = 0;
QSize sizeTip( 1, 1 );

	//get the minimum for width ( The buttons must be placed in it ):

	sizeTip = b1->sizeHint();
	if ( buttonWidth < sizeTip.width() ) buttonWidth = sizeTip.width();

	sizeTip = b2->sizeHint();
	if ( buttonWidth < sizeTip.width() ) buttonWidth = sizeTip.width();

	sizeTip = b3->sizeHint();
	if ( buttonWidth < sizeTip.width() ) buttonWidth = sizeTip.width();

	sizeTip = b4->sizeHint();
	if ( buttonWidth < sizeTip.width() ) buttonWidth = sizeTip.width();

	//All buttons have a size of ( ButtonWidth, 30 )
	b1->resize( buttonWidth, 30 );
	b2->resize( buttonWidth, 30 );
	b3->resize( buttonWidth, 30 );
	b4->resize( buttonWidth, 30 );

	// The minimum for dialogs width is n*buttonWidth + (5*w_distance):
	minWidth = buttonWidth + ( 2 * w_distance );
	if ( seB != "" ) minWidth = minWidth + buttonWidth + w_distance;
	if ( thB != "" ) minWidth = minWidth + buttonWidth + w_distance;
	if ( foB != "" ) minWidth = minWidth + buttonWidth + w_distance;

	// Now, get the width which is really to use!

	label->setText(text);
	sizeTip = label->sizeHint();

	if ( sizeTip.width()+50 > minWidth )
		useWidth = sizeTip.width()+50;
		//not smaller then minWidth and as large as text+2*25

	if ( (useWidth > optWidth) && (optWidth >= minWidth ) )
		useWidth = optWidth;
		//if optWidth is not smaller than the minimum, then
		//the width should not become larger than optWidth

	if ( useWidth < minWidth ) useWidth = minWidth;

	return(useWidth);
}



void CPBox::setMyHeight( QString text, int myWidth )
{
const int minHeight = 40;

QString subString[99];
int useHeight = minHeight;
QSize sizeTip(1,1);
int i, ii = 1, iii = 0;
int checksize = 0;
int brs;

QString tmpString(99);

	//initialize subString: (not needed?)
	for ( i = 0; i < 99; i++ )
		subString[i] = "";

	//Split the text in several sub-arrays, each for one line:

	subString[0].resize(2); //' '+\0
	subString[0][0] = ' '; //' ' at new lines

	for ( i = 0; i < (int)text.length(); i++ )
	{

		// ii counts the chars, iii the lines
		ii++;
		subString[iii].resize(ii+2); //ii+\0

		if ( text[i] != 10 )
		{
			subString[iii][ii-1] = text[i];
		}
		else
		{
			subString[iii][ii-1] = 0;
			iii++; //next sub-array
			ii = 1;
			subString[iii].resize(ii+2); //ii+\0
			subString[iii][ii-1] = ' '; //' ' at new lines
		}
	}

	subString[iii][ii+1] = 0; //terminate the last sub string

	label->setText(text);


	while ( (sizeTip=label->sizeHint()).width() > myWidth - 20 )
	{
		//looking for the longest line and make it shorter!:
		checksize = 0;
		for ( i = 0; i < 99; i++ )
		{
			if ( (int)subString[i].length() > checksize )
			{
				checksize = subString[i].length();
				ii = i;
			}

		}

		//make it shorter:
		// 1) how long is the last word of the line?:
		for ( i = subString[ii].length(); i >= 0; i-- )
		{


			if ( subString[ii][i-1] == ' ' )
			{
				//copy this into tmpString and break:

				iii = 0;
				for( i = i; i <=
					(int)subString[ii].length(); i++ )
				{
					tmpString[iii] = subString[ii][i-1];
					iii++;
				}
				tmpString[iii] = 0;
				break;
			}

			if ( i == 2 ) //only ONE word in line!
			{
				//take only the last char:
				tmpString[0] = subString[ii][
					subString[ii].length() - 1 ];

				tmpString[1] = 0;

				break;
			}

		}


		// 2) Add tmpString to the next line, and truncate this line
		subString[ii].truncate( (int)subString[ii].length() -
			(int)tmpString.length() );

		subString[ii+1] = QString(
			tmpString + subString[ii+1] );


		//Try out with the new text:
		text = "";
		for ( i = 0; i < 99; i++ )
		{
			text.append( subString[i] );
			text.append( "\n" );

		}
		//erase "\n" at the end:
		for ( i = (int)text.length(); text[i-1] == 10; i-- );
		text.truncate(i);

		label->setText( text );

	} //while


	sizeTip = label->sizeHint();
	useHeight = sizeTip.height();

	if ( useHeight < minHeight ) useHeight = minHeight;

	label->resize( myWidth-20, useHeight );

	//Height of the dialog is useHeight + h_distance(above)+
	//+h_distance(below) +30(buttons) + h_distance(below buttons):

	setFixedSize( myWidth, useHeight+h_distance
		+h_distance+30+h_distance );


	//set positions:
	label->move( 10, h_distance );

	//if there is only one button:
	if ( (fiB != "") && (seB == "") )
	{
		b1->move( myWidth/2 - b1->width()/2,
			h_distance + useHeight + h_distance );

		//hide all the others:
		b2->hide();
		b3->hide();
		b4->hide();
	}

	//if there are two buttons:
	if ( (seB != "") && (thB == "") )
	{
/*		b1->move( myWidth/3 - b1->width()/2,
			h_distance + useHeight + h_distance );

		b2->move( 2*myWidth/3 - b1->width()/2,
			h_distance + useHeight + h_distance );*/

		brs = ( myWidth-( (3*w_distance)+(2*b1->width()) ) )/ 3;
		brs = brs + w_distance;

		b1->move( brs, h_distance + useHeight + h_distance );

		b2->move( 2*brs + b1->width(),
			h_distance + useHeight + h_distance );

		//hide button3 and button4
		b3->hide();
		b4->hide();
	}

	//if there are three buttons:
	if ( (thB != "") && (foB == "") )
	{
		brs = ( myWidth-( (4*w_distance)+(3*b1->width()) ) )/ 4;
		brs = brs + w_distance;

		b1->move( brs, h_distance + useHeight + h_distance );

		b2->move( 2*brs + b1->width(),
			h_distance + useHeight + h_distance );

		b3->move( 3*brs + b1->width() + b2->width(),
			h_distance + useHeight + h_distance );

		b4->hide();
	}

	//if there are four buttons:
	if ( foB != "" )
	{
		brs = ( myWidth-( (5*w_distance)+(4*b1->width()) ) )/ 5;
		brs = brs + w_distance;

		b1->move( brs, h_distance + useHeight + h_distance );

		b2->move( 2*brs + b1->width(),
			h_distance + useHeight + h_distance );

		b3->move( 3*brs + b1->width() + b2->width(),
			h_distance + useHeight + h_distance );

		b4->move( 4*brs + b1->width() + b2->width() + b3->width(),
			h_distance + useHeight + h_distance );


	}

} //void setMyHeight(...)


void CPBox::fibP()
{
	answer = 1;
	connect( this, SIGNAL(buttonPressed(int)), SLOT(done(int)) );
	emit(buttonPressed(answer));
}


void CPBox::sebP()
{
	answer = 2;
	connect( this, SIGNAL(buttonPressed(int)), SLOT(done(int)) );
	emit(buttonPressed(answer));
}


void CPBox::thbP()
{
	answer = 3;
	connect( this, SIGNAL(buttonPressed(int)), SLOT(done(int)) );
	emit(buttonPressed(answer));
}


void CPBox::fobP()
{
	answer = 4;
	connect( this, SIGNAL(buttonPressed(int)), SLOT(done(int)) );
	emit(buttonPressed(answer));
}


vkBox::vkBox( QString txt, int type=0, QString title="" )
{
int ht = -1;

	ans = -1;

	switch( type )
	{
		case 0: //OK
			ht = KMsgBox::message( 0L, title, txt );
			ans = 1;

			break;

		case 1: //OKCancel; sorry, only OK, so far
			ht = KMsgBox::message( 0L, title, txt );
			ans = 1;

			break;


		case 2: //YesNo
			if( KMsgBox::yesNo( 0L, title, txt ) == 1 )
				ans = 1;
			else
				ans = 2;
			break;

		case 3: //YesNoCancel; sorry, only YesNo, returns allways "Yes" so far
			ht = KMsgBox::yesNo( 0L, title, txt );
			ans = 1;

			break;

		case 4: //Exclamation OK
			ht = KMsgBox::message( 0L, title, txt );
			ans = 1;

			break;

		default:
			//Warn (...)
			ht = KMsgBox::message( 0L, title, txt );
			ans = 1;
	}
}

int vkBox::answer()
{
	debug( "RETURNING MsgBox RESULT %d", ans );
	return ans;
}