/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the Visual 'K' project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "vksubwidgets.h"
#include "vksubwidgets.moc"

/*******************************************************************************
* class vkPushButton:
********************************************************************************/

vkPushButton::vkPushButton( QWidget *parent, const char *name = 0L )
	: QPushButton( parent, name )
{
}


/*******************************************************************************
* class vkLabel:
********************************************************************************/

vkLabel::vkLabel( QWidget *parent, const char *name = 0L )
	: QLabel( parent, name )
{
}


void vkLabel::mouseReleaseEvent( QMouseEvent *e )
{
int x, y;

	x = e->x(); y = e->y();

	if ( e->button() == LeftButton
		&& x >= 0 && y >= 0 && x <= width() && y <= height() )
		emit clicked(); //Left-button-click in range
}

/*******************************************************************************
* class vkPixLabel:
********************************************************************************/

vkPixLabel::vkPixLabel( QWidget *parent, const char *name = 0L )
	: QLabel( parent, name )
{
	pixy = "(none)";
}

void vkPixLabel::loadPic( QString pn )
{
KIconLoader il;

	if( pn.lower() == "(none)" )
	{
		setText(""); //No pixmap
		pixy = "(none)";
		return;
	}

	// 1st posibility: VK FILE variable:
	// (not implemented, yet) (...) ==> return;

	// 2nd possibility: Installed file (without path):
	if( pn.contains( "/" ) )
	{
		KMsgBox::message( 0L, "Error", "Can't find pixmap." );
		return;
	}

	setPixmap( il.loadIcon(pn) );
	pixy = pn;

}

void vkPixLabel::mouseReleaseEvent( QMouseEvent *e )
{
int x, y;

	x = e->x(); y = e->y();

	if ( e->button() == LeftButton
		&& x >= 0 && y >= 0 && x <= width() && y <= height() )
		emit clicked(); //Left-button-click in range
}

/*******************************************************************************
* class vkLineEdit:
********************************************************************************/

vkLineEdit::vkLineEdit( QWidget *parent, const char *name = 0L )
	: QLineEdit( parent )
{
	connect( this, SIGNAL(textChanged(const char*)), SIGNAL(changed()) );
}

/*******************************************************************************
* class vkLineEdit:
********************************************************************************/

vkListBox::vkListBox( QWidget *parent, const char *name = 0L )
	: QListBox( parent, name )
{
	connect( this, SIGNAL( highlighted(int) ), SIGNAL( changed() ) );
}

/*******************************************************************************
* class vkCheckBox:
********************************************************************************/

vkCheckBox::vkCheckBox( QWidget *parent, const char *name = 0L )
	: QCheckBox( parent, name )
{
}

/*******************************************************************************
* class vkOptionButton:
********************************************************************************/

vkOptionButton::vkOptionButton( QWidget *parent, const char *name = 0L )
	: QRadioButton( parent, name )
{
	connect( this, SIGNAL( clicked() ), SLOT( click() ) );
}

void vkOptionButton::click() //SLOT
{
	emit uncheckOpts();
	setChecked( true );
}

/*******************************************************************************
* class vkSlider:
********************************************************************************/

vkSlider::vkSlider( QWidget *parent, const char *name = 0L )
	: QSlider( parent, name )
{
	setOrientation( QSlider::Horizontal );

	connect( this, SIGNAL( valueChanged(int) ), SIGNAL( changed() ) );
}

/*******************************************************************************
* class vkProcCtrl:
********************************************************************************/

vkProcCtrl::vkProcCtrl( QWidget *parent, const char *name = 0L )
	: QLabel( parent, name )
{
	cmd = ""; args = "";
	kp = new KProcess();
	kp->setExecutable("");
	hasStarted = false;

	connect( kp, SIGNAL( receivedStdout(KProcess *, char *, int) ),
		SLOT( gotOut(KProcess *, char *, int) ) );

	connect( kp, SIGNAL( processExited(KProcess *) ),
		SLOT( kpexit(KProcess *) ) );

}

bool vkProcCtrl::isRunning()
{
	return( kp->isRunning() );
}

int vkProcCtrl::ret()
{
	if(!hasStarted)
		return -32;

	if( kp->isRunning() )
		return -33;

	if( !kp->normalExit() )
		return -34;

	return( kp->exitStatus() );
}

void vkProcCtrl::setCommand( QString newCmd )
{
	cmd = newCmd;
}

void vkProcCtrl::setArgs( QString newArgs )
{
	args = newArgs;
}

void vkProcCtrl::setRunning( bool run )
{
	if( run )
	{
		//start, if not running
		hasStarted = true;

		if( !isRunning() )
		{
			kp->clearArguments();
			kp->setExecutable( cmd );
			if (args != "") setAllArgs();
			kp->start( KProcess::NotifyOnExit, KProcess::All );
		}

	}
	else if( isRunning() ) //stop if running
		kp->kill();

}

void vkProcCtrl::ts( QString newCaption )
{
	setText( newCaption );
	emit changed();
}

void vkProcCtrl::setAllArgs()
{
QString substr(0);
int i = -1;
bool strMode = false;
bool eMode = false;

	do
	{
		i++;

		if( args[i] == '"' && !eMode )
			strMode = !strMode;

		if( args[i] == '\n' ) args[i] = ' ';
		if( args[i] == ' ' && !strMode )
		{
			if( substr.length() > 0 )
				*kp << substr;



			substr.resize(0);
		}
		else
		{
			substr.resize(substr.length()+2);
			substr[substr.length()+1] = 0L;
			substr[substr.length()] = args[i];
		}

		eMode = false;

		if( args[i] == '\\' ) eMode = true;

	} while( args[i] != 0L );

	if( substr.length() > 0 )
		*kp << substr;

}

void vkProcCtrl::gotOut( KProcess *proc, char *buffer, int buflen ) //slot
{
	QString bstr( buffer, buflen );

	ts( QString (text()) +bstr );
}

void vkProcCtrl::kpexit( KProcess * ) //slot
{
	emit exited();
}