/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef VKTOP_H
#define VKTOP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <ktopwidget.h>
#include <qstring.h>

#include "vkwidget.h"
#include "vkerr.h"

class vkTopWindow : public KTopLevelWidget
{
	Q_OBJECT

public:
	vkTopWindow( const char *name = 0 );
	virtual ~vkTopWindow();

	enum windowType{ topBody, newWindow };

	void registerChild( vkWidget *, const char *,
		 windowType );

	void forgetChild ( const char * );

public slots:
	void postOffice( int, QString, QString, int, QString );
	void parProp( QString, QString );

signals:
	void initChild( int, QString, int );

	void childCall( int, QString, QString, int, QString );

private:
	QWidget *childs[100];
	QString childNames[100];
	int child_ids[100];

	int view_id;

	vkErr *RUNTIME_ERROR;

};


#endif //VKTOP_H
