/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the Visual 'K' project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef VKWIDGET_H
#define VKWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qsize.h>

#include "vkbox.h"
#include "vkvar.h"
#include "vkchildlist.h"
#include "vksubwidgets.h"


/*****************************************************************************
	class vkWidget:
This class is the base class of Visual 'K'; it is used for windows
(or "sub windows") and manages and connects _all_ other widgets.
******************************************************************************/

class vkWidget : public QWidget
{
	Q_OBJECT

public:
	// constructors:

	vkWidget( QWidget *parent, const char *name=0 );
		//Window; if the QWidget is not vkTopWindow,
		//the Window is isolated

	vkWidget( vkWidget *parent, const char *name=0 );
		//Sub widget

	v sendPostCard( QString, QString, int, QString );

	void registerChild( vkPushButton *, const char * );
	void registerChild( vkLabel *, const char * );
	void registerChild( vkPixLabel *, const char * );
	void registerChild( vkLineEdit *, const char * );
	void registerChild( vkListBox *, const char * );
	void registerChild( vkCheckBox *, const char * );
	void registerChild( vkOptionButton *, const char * );
	void registerChild( vkSlider *, const char * );
	void registerChild( vkProcCtrl *, const char * );

	void registerChild( vkWidget *, const char * );

	void forgetChild ( const char * );

public slots:
	void initMe( int, QString, int ); //for call by parent
	void postOffice( int, QString, QString, int, QString );

signals:
	void initChild( int, QString, int );

	void parentCall( int, QString, QString, int, QString );
	void parProp( QString, QString );

	void childCall( int, QString, QString, int, QString );

	void loadMe(); //When registration is complete

protected:
	virtual void regComplete() = 0;

	virtual void start() = 0;
	virtual void click() = 0;

private:
	virtual void mouseReleaseEvent( QMouseEvent * );

	void doInstructions( QString, int, QString, int );

	void checkBool( QString * );
	void checkInt( QString *, bool=false );
	void checkColor( QString * );

	QString myName;
	int myID;
	bool isWindow;

	QWidget *myParent;

	QWidget *childs[100];
	QString childNames[100];
	int child_ids[100];

	childList depChilds;

	v transferList; //Result (answer) of a postCard return
	int transferState;

private slots:
	void uncheckOpt();

};


#endif //VKWIDGET_H
