/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "errorx.h"

void errorx( int err )
{
	printf( "vkConfigmaker: in file %s: ", f_name );

	switch(err)
	{
		case 1: printf( "\"Window\" or \"SubWindow\" expected" );
			break;

		case 2: printf( "Name expected" );
			break;

		case 3: printf( "'(' expected" );
			break;

		case 4: printf( "\"Properties\" expected" );
			break;

		case 5: printf( "'=' expected" );
			break;

		case 6: printf( "Value or semicolon expected" );
			break;

		case 7: printf( "\"Regional\" expected" );
			break;

		case 8: printf( "\"RegConst\" expected" );
			break;


		case 9: printf( "\"Functions\" expected" );
			break;

		case 10: printf( "':' expected" );
			break;

		case 11: printf( "Integer value expected" );
			break;

		case 12: printf( "\"SubWidgets\" expected" );
			break;

		case 13: printf( "Widget type expected" );
			break;

		case 14: printf( "')' expected" );
			break;

		case 15: printf( "\"Project\" expected" );
			break;

		case 16: printf( "\"Globals\" expected" );
			break;

		case 17: printf( "One of the subsections \"Variables\", " );
			 printf( "\"Consts\" or \"Functions\" expected" );
			break;

		case 18: printf( "\"Widgets\" expected" );
			break;

		case 19: printf( "EOF expected" );
			break;

		default:
			printf( "Fatal internal error: Got unknown error ID.\n" );
			abort();
	}

	printf( " (parse error in line %d).\n", activeLine );
	exit( MIN_ERROR + err -1 );
}
