/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "classbuilder.h"

#ifndef FILE_DECLARED
	#define FILE_DECLARED
	FILE *fheader, *fcppcode;
#endif

#define COPYRIGHT "************************************************************************\n\
* This is a VisKProg program for KDE.                                  *\n\
* Since this code is autogenerated (and bad structured), you should edit *\n\
* the VisKProg source code instead.                                    *\n\
* Anyway, you may use, distribute and modify both, this c++ code and the *\n\
* original VisKProg code under the terms of the GNU General Public     *\n\
* licence (GPL) in version 2, or (at your opionion) any newer version.   *\n\
* Please note, that there is absolutely no warrenty for the program.     *\n\
* See file \"COPYING\" in the top level directory of this programs         *\n\
* distribution for details.                                              *\n\
* The copyright holder is the author of this program, who signed in      *\n\
* file \"AUTHOR\"                                                          *\n\
*************************************************************************"

#define INCLUDES "#include <kapp.h>\n"

int parseUntilNext( char *in, int i, int isH )
{
unsigned mlen = strlen(in);

	while( i < mlen )
	{


		if( (i+3) < strlen(in) )
		{

			if( strncmp( in +(i*sizeof(char)), "$$_", 3 ) == 0 )
				return i; //Target reached!

		}


		if ( isH )
			fputc( in[i], fheader );
		else
			fputc( in[i], fcppcode );

		i++;

	}

	if ( isH )
		fputc( '\n', fheader );
	else
		fputc( '\n', fcppcode );

	return -1;
}


int getTarget( char *in, int i, char *out )
{
int ii = 0;

	i += 3;

	while ( in[i] != '_' )
	{

		if ( i == strlen(in) )
		{
			printf( "Invalid target (syntax error).\n" );
			exit(2);
		}

		out[ii] = in[i];

		i++; ii++;

		if ( ii == EXPR_LEN )
		{
			printf( "Invalid target (too long).\n" );
			exit(2);
		}


	}

	out[ii] = 0L;

	i++;

	if( in[i] != '$' )
	{
		printf( "Invalid target (syntax error).\n" );
		exit(2);
	}

	i ++;

	return i;


}


void writeCode( char *wrc, int isHeader )
{
int i;

	for( i = 0; wrc[i] != 0L; i++ )
		if( isHeader )
			fputc( wrc[i], fheader );
		else
			fputc( wrc[i], fcppcode );
}


int openOut( struct inFile *oInf )
{
char hn[EXPR_LEN] = "", cn[EXPR_LEN] = "";

	strcat( hn, oInf->name );
	strcat( hn, ".h" );

	strcat( cn, oInf->name );
	strcat( cn, ".cpp" );


	fheader = fopen( hn, "w" );

	if ( fheader == 0L )
	{
		printf ( "Can't write *.h file: Maybe permission denied.\n" );
		return false;
	}


	fcppcode = fopen( cn, "w" );

	if ( fheader == 0L )
	{
		printf ( "Can't write *.cpp file: Maybe permission denied.\n" );
		return false;
	}

	return true;
}



int parseHeader( struct inFile *inf, char *pcde )
{
int i = 0, ii, iii;
char target[EXPR_LEN];
char checkExpr[EXPR_LEN], checkExpr2[EXPR_LEN];


	while( pcde[i] != 0L )
	{
		i = parseUntilNext( pcde, i, true );

		if ( i == -1 ) break; //EOF

		i = getTarget( pcde, i, target );

		if( strcmp( target, "COPYRIGHT" ) == 0 )
		{
			fputc( '/', fheader );
			writeCode( COPYRIGHT, true );
			fputc( '/', fheader );
			fputc( '\n', fheader );
			fputc( '\n', fheader );
		}
		else if( strcmp( target, "CLASSNAME" ) == 0 )
		{
			getInFName( inf, checkExpr );

			writeCode( checkExpr, true );
		}
		else if( strcmp( target, "INCLUDES" ) == 0 )
		{
			writeCode( INCLUDES, true );

			writeCode( "\n", true );

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				getInSubT( inf, ii, checkExpr2 );

				if( strcmp( checkExpr2, "SubWindow" ) == 0 )
				{
					writeCode( "#include \"", true );
					writeCode( inf->name, true );
					writeCode( "_", true );
					writeCode( checkExpr, true );
					writeCode( ".h\"\n", true );
				}

				ii++;
			}

		}
		else if( strcmp( target, "VARCONST" ) == 0 )
		{
			ii = 0;

			for( getInVarN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInVarN( inf, ii, checkExpr ) )
			{
				writeCode( "\tv ", true );
				writeCode( checkExpr, true );
				writeCode( "; //Variable\n", true );
				ii++;
			}


			ii = 0;

			for( getInConstN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInConstN( inf, ii, checkExpr ) )
			{
				writeCode( "\tv ", true );
				writeCode( checkExpr, true );
				writeCode( "; //Constant\n", true );

				ii++;
			}


		}
		else if( strcmp( target, "USER" ) == 0 )
		{
			ii = 0;

			for( getInFuncN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInFuncN( inf, ii, checkExpr ) )
			{
				writeCode( "\tv ", true );
				writeCode( checkExpr, true );
				writeCode( "(", true );

				if( getInFuncA( inf, ii ) > 0 )
					writeCode( " v", true );

				for( iii = 1; iii < getInFuncA( inf, ii ); iii++ )
					writeCode( ", v", true );

				writeCode( " );\n", true );

				ii++;
			}

		}
		else if( strcmp( target, "EVENTS" ) == 0 )
		{
			ii = 0;

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				getInSubT( inf, ii, checkExpr2 );

				if( strcmp( checkExpr2, "SubWindow" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_start( );\n", true );

					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_click( );\n", true );
				}
				else if( strcmp( checkExpr2, "Button" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_click( );\n", true );
				}
				else if( strcmp( checkExpr2, "Label" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_click( );\n", true );
				}
				else if( strcmp( checkExpr2, "PixLabel" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_click( );\n", true );
				}
				else if( strcmp( checkExpr2, "LineEdit" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_changed( );\n", true );

					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_return( );\n", true );
				}
				else if( strcmp( checkExpr2, "ListBox" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_changed( );\n", true );
				}
				else if( strcmp( checkExpr2, "CheckBox" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_click( );\n", true );
				}
				else if( strcmp( checkExpr2, "OptionButton" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_click( );\n", true );
				}
				else if( strcmp( checkExpr2, "Slider" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_changed( );\n", true );
				}
				else if( strcmp( checkExpr2, "ProcCtrl" ) == 0 )
				{
					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_changed( );\n", true );

					writeCode( "\tvoid ", true );
					writeCode( checkExpr, true );
					writeCode( "_exit( );\n", true );
				}
				else
				{
					printf ( "Unknown sub widget type \"%s\".\n", checkExpr2 );
				}

				ii++;
			}

		}
		else if( strcmp( target, "SUBDECLARE" ) == 0 )
		{
			ii = 0;

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				getInSubT( inf, ii, checkExpr2 );

				if( strcmp( checkExpr2, "SubWindow" ) == 0 )
				{
					writeCode( "\t", true );
					writeCode( inf->name, true );
					writeCode( "_", true );
					writeCode( checkExpr, true );
					writeCode( " *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "Button" ) == 0 )
				{
					writeCode( "\tvkPushButton *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "Label" ) == 0 )
				{
					writeCode( "\tvkLabel *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "PixLabel" ) == 0 )
				{
					writeCode( "\tvkPixLabel *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "LineEdit" ) == 0 )
				{
					writeCode( "\tvkLineEdit *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "ListBox" ) == 0 )
				{
					writeCode( "\tvkListBox *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "CheckBox" ) == 0 )
				{
					writeCode( "\tvkCheckBox *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "OptionButton" ) == 0 )
				{
					writeCode( "\tvkOptionButton *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "Slider" ) == 0 )
				{
					writeCode( "\tvkSlider *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else if( strcmp( checkExpr2, "ProcCtrl" ) == 0 )
				{
					writeCode( "\tvkProcCtrl *", true );
					writeCode( checkExpr, true );
					writeCode( ";\n", true );
				}
				else
				{
					printf ( "Unknown sub widget type \"%s\".\n", checkExpr2 );
				}

				ii++;
				
			} //for

		}
		else
		{
			printf ( "Unknown target \"%s\" in header template.\n",
				target );
			exit(2);
		}
		
	} //while

	return true;
}


void insertFile( char *baseName, char *suffix, int optional, char *alt )
{
FILE *fp;
char fn[EXPR_LEN] = "";
char ch;
int i;

	strcat( fn, baseName );
	strcat( fn, "." );
	strcat( fn, suffix );

	fp = fopen( fn, "r" );

	if ( fp == 0L && !optional )
	{
		printf( "Can't open necessary file \"%s\".\n", fn );
		exit(2);
	}
	else if( fp == 0L )
	{
		printf( "Warning: Optional file \"%s\" not avaible.\n", fn );

		if ( alt != 0L )
			for( i = 0; alt[i] != 0L; i++ )
				fputc( alt[i], fcppcode );
		return;
	}

	while( (ch = fgetc(fp)) != EOF )
		fputc( ch, fcppcode );

	fclose(fp);

}


void writeVarInit( struct inFile *inf )
{
int i;
char expr[EXPR_LEN], expr2[EXPR_LEN];

	writeCode( "\t//Variables:\n", false );

	i = 0;

	for( getInVarN( inf, 0, expr ); expr[0] != 0L; getInVarN( inf, i, expr ) )
	{
		getInVarV( inf, i, expr2 );

		writeCode( "\t", false );
		writeCode( expr, false );
		writeCode( ".s( \"", false );
		writeCode( expr2, false );
		writeCode( "\" );\n", false );

		i++;
	}

	writeCode( "\n\t//Constants:\n", false );

	i = 0;

	for( getInConstN( inf, 0, expr ); expr[0] != 0L; getInConstN( inf, i, expr ) )
	{

		getInConstV( inf, i, expr2 );

		writeCode( "\t", false );
		writeCode( expr, false );
		writeCode( ".s( \"", false );
		writeCode( expr2, false );
		writeCode( "\" );\n\t", false );

		writeCode( expr, false );
		writeCode( ".makeConst();\n\n", false );

		i++;
	}
}


void writeRegChilds( struct inFile *inf )
{
int i;
char expr[EXPR_LEN], expr2[EXPR_LEN];

	i = 0;

	for( getInSubN( inf, 0, expr ); expr[0] != 0L;
		getInSubN( inf, i, expr ) )
	{
		getInSubT( inf, i, expr2 );

		writeCode( "\t", false );
		writeCode( expr, false );
		writeCode( " = new ", false );

		if ( strcmp( expr2, "SubWindow" ) == 0 )
		{
			writeCode( inf->name, false );
			writeCode( "_", false );
			writeCode( expr, false );
			writeCode( "(this);\n", false );
		}
		else if ( strcmp( expr2, "Button" ) == 0 )
			writeCode( "vkPushButton(this);\n", false );
		else if ( strcmp( expr2, "Label" ) == 0 )
			writeCode( "vkLabel(this);\n", false );
		else if ( strcmp( expr2, "PixLabel" ) == 0 )
			writeCode( "vkPixLabel(this);\n", false );
		else if ( strcmp( expr2, "LineEdit" ) == 0 )
			writeCode( "vkLineEdit(this);\n", false );
		else if ( strcmp( expr2, "ListBox" ) == 0 )
			writeCode( "vkListBox(this);\n", false );
		else if ( strcmp( expr2, "CheckBox" ) == 0 )
			writeCode( "vkCheckBox(this);\n", false );
		else if ( strcmp( expr2, "OptionButton" ) == 0 )
			writeCode( "vkOptionButton(this);\n", false );
		else if ( strcmp( expr2, "Slider" ) == 0 )
			writeCode( "vkSlider(this);\n", false );
		else if ( strcmp( expr2, "ProcCtrl" ) == 0 )
			writeCode( "vkProcCtrl(this);\n", false );
		else
		{
			printf( "Unknown widget type \"%s\".\n", expr2 );
			exit(2);
		}

		writeCode( "\tregisterChild( ", false );
		writeCode( expr, false );
		writeCode( ", \"", false );
		writeCode( expr, false );
		writeCode( "\" );\n\n", false );

		i++;
	}
	
}


void makeAltFunc( char *name, struct inFile *inf, char *ret )
{
char checkExpr[EXPR_LEN];

	ret[0] = 0L;
	strcat( ret, "void " );
	getInFName( inf, checkExpr );
	strcat( ret, checkExpr );
	strcat( ret, "::" );
	strcat( ret, name );
	strcat( ret, "() {}\n" );

}


int parseCpp( struct inFile *inf, char *pcde, int ww )
{
int i = 0, ii, iii;
char target[EXPR_LEN];
char checkExpr[EXPR_LEN], checkExpr2[EXPR_LEN], lExpr[2*EXPR_LEN], altExpr[3*EXPR_LEN];


	while( pcde[i] != 0L )
	{
		i = parseUntilNext( pcde, i, false );

		if ( i == -1 ) break; //EOF

		i = getTarget( pcde, i, target );

		if( strcmp( target, "COPYRIGHT" ) == 0 )
		{
			fputc( '/', fcppcode );
			writeCode( COPYRIGHT, false );
			fputc( '/', fcppcode );
			fputc( '\n', fcppcode );
			fputc( '\n', fcppcode );
		}
		else if( strcmp( target, "CLASSNAME" ) == 0 )
		{
			getInFName( inf, checkExpr );

			writeCode( checkExpr, false );
		}
		else if( strcmp( target, "WIDGETCONSTRUCT" ) == 0 )
		{
			if ( ww == 0 )
			{
				//Init vars:
				writeVarInit(inf);

				//Register childs:
				writeRegChilds(inf);

			}
			else
			{
				writeCode( "\tfatal( \"Can't construct widget from window (Internal error).\" );\n",
					false );
			}

		}
		else if( strcmp( target, "WINDOWCONSTRUCT" ) == 0 )
		{
			if ( ww > 0 )
			{
				//Init vars:
				writeVarInit(inf);

				//Register childs:
				writeRegChilds(inf);

			}
			else
			{
				writeCode( "\tfatal( \"Can't construct window from usual widget (Internal error).\" );\n",
					false );
			}
		}
		else if( strcmp( target, "USERCODE" ) == 0 )
		{
			ii = 0;

			for( getInFuncN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInFuncN( inf, ii, checkExpr ) )
			{
				if ( ii == MAX_ENTRS-1 )
				{
					printf( "Too many user defined functions.\n" );
				}

				insertFile( checkExpr, "cpp-code", false, 0L );

				ii++;

			}

		}
		else if( strcmp( target, "RESIZE" ) == 0 )
		{
			writeCode( "int wf, hf;\n\n", false );
			writeCode( "\twf = (100*width()) / ", false );

			ii = 0;

			for( getInPropN( inf, 0, checkExpr ); strcmp(checkExpr, "width") != 0;
				getInPropN( inf, ii, checkExpr ) )
			{
				if( checkExpr[0] == 0L )
				{
					printf( "Missing width property.\n" );
					exit(2);
				}

				ii++;
			}

			getInPropV( inf, ii, checkExpr );
			writeCode( checkExpr, false );

			writeCode( "; hf = (100*height()) / ", false );

			ii = 0;

			for( getInPropN( inf, 0, checkExpr ); strcmp(checkExpr, "height") != 0;
				getInPropN( inf, ii, checkExpr ) )
			{
				if( checkExpr[0] == 0L )
				{
					printf( "Missing height property.\n" );
					exit(2);
				}

				ii++;
			}

			getInPropV( inf, ii, checkExpr );
			writeCode( checkExpr, false );

			writeCode( ";\n\n\t", false );

			ii = 0;

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				writeCode( checkExpr, false );
				writeCode( "->setGeometry( ", false );

				iii = 0;

				for( getInSubPropN( inf, ii, 0, checkExpr2 ); strcmp(checkExpr2, "x") != 0;
					getInSubPropN( inf, ii, iii, checkExpr2 ) )
				{
					if( checkExpr2[0] == 0L )
					{
						printf( "Missing \"x\" property in sub widget \"%s\".\n", checkExpr );
						exit(2);
					}

					iii++;
				}

				getInSubPropV( inf, ii, iii, checkExpr2 );
				writeCode( checkExpr2, false );

				writeCode( " * wf/100, ", false );


				iii = 0;

				for( getInSubPropN( inf, ii, 0, checkExpr2 ); strcmp(checkExpr2, "y") != 0;
					getInSubPropN( inf, ii, iii, checkExpr2 ) )
				{
					if( checkExpr2[0] == 0L )
					{
						printf( "Missing \"y\" property in sub widget \"%s\".\n", checkExpr );
						exit(2);
					}

					iii++;
				}

				getInSubPropV( inf, ii, iii, checkExpr2 );
				writeCode( checkExpr2, false );

				writeCode( " * hf/100, ", false );


				iii = 0;

				for( getInSubPropN( inf, ii, 0, checkExpr2 ); strcmp(checkExpr2, "width") != 0;
					getInSubPropN( inf, ii, iii, checkExpr2 ) )
				{
					if( checkExpr2[0] == 0L )
					{
						printf( "Missing \"width\" property in sub widget \"%s\".\n", checkExpr );
						exit(2);
					}

					iii++;
				}

				getInSubPropV( inf, ii, iii, checkExpr2 );
				writeCode( checkExpr2, false );

				writeCode( " * wf/100, ", false );

				iii = 0;

				for( getInSubPropN( inf, ii, 0, checkExpr2 ); strcmp(checkExpr2, "height") != 0;
					getInSubPropN( inf, ii, iii, checkExpr2 ) )
				{
					if( checkExpr2[0] == 0L )
					{
						printf( "Missing \"height\" property in sub height \"%s\".\n", checkExpr );
						exit(2);
					}

					iii++;
				}

				getInSubPropV( inf, ii, iii, checkExpr2 );
				writeCode( checkExpr2, false );

				writeCode( " * hf/100 );\n\t", false );

				ii++;
			}


		}
		else if( strcmp( target, "SUBINIT" ) == 0 )
		{
			ii = 0;

			for( getInPropN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInPropN( inf, ii, checkExpr ) )
			{
				writeCode( "\tsendPostCard( \".\", \"", false );
				writeCode( checkExpr, false );
				writeCode( "\", 0, \"", false );

				getInPropV( inf, ii, checkExpr2 );
				writeCode( checkExpr2, false );

				writeCode( "\" );\n", false );


				ii++;
			}

			ii = 0;

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				iii = 0;

				for( getInSubPropN( inf, ii, 0, checkExpr2 ); checkExpr2[0] != 0L;
					getInSubPropN( inf, ii, iii, checkExpr2 ) )
				{

					writeCode( "\tsendPostCard( \".", false );
					writeCode( checkExpr, false );
					writeCode( "\", \"", false );
					writeCode( checkExpr2, false );

					getInSubPropV( inf, ii, iii, checkExpr2 );

					writeCode( "\", 0, \"", false );
					writeCode( checkExpr2, false );
					writeCode( "\" );\n", false );

					iii++;
				}

				ii++;
			}

		}
		else if( strcmp( target, "SUBCONNECT" ) == 0 )
		{
			ii = 0;

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				getInSubT( inf, ii, checkExpr2 );

				if( strcmp( checkExpr2, "SubWindow" ) == 0 )
				{
					//vkWidgets manage themselves!
				}
				else if( strcmp( checkExpr2, "Button" ) == 0 )
				{
					//Click event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(clicked()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_click()) );\n", false );
				}
				else if( strcmp( checkExpr2, "Label" ) == 0 )
				{
					//Click event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(clicked()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_click()) );\n", false );
				}
				else if( strcmp( checkExpr2, "PixLabel" ) == 0 )
				{
					//Click event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(clicked()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_click()) );\n", false );
				}
				else if( strcmp( checkExpr2, "LineEdit" ) == 0 )
				{
					//Changed event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(changed()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_changed()) );\n", false );

					//Return event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(returnPressed()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_return()) );\n", false );
				}
				else if( strcmp( checkExpr2, "ListBox" ) == 0 )
				{
					//Changed event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(changed()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_changed()) );\n", false );
				}
				else if( strcmp( checkExpr2, "CheckBox" ) == 0 )
				{
					//Click event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(clicked()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_click()) );\n", false );
				}
				else if( strcmp( checkExpr2, "OptionButton" ) == 0 )
				{
					//Click event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(clicked()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_click()) );\n", false );
				}
				else if( strcmp( checkExpr2, "Slider" ) == 0 )
				{
					//Changed event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(changed()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_changed()) );\n", false );
				}
				else if( strcmp( checkExpr2, "ProcCtrl" ) == 0 )
				{
					//Changed event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(changed()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_changed()) );\n", false );

					//Exit event:
					writeCode( "\tconnect( ", false );
					writeCode( checkExpr, false );
					writeCode( ", SIGNAL(exited()), SLOT(", false );
					writeCode( checkExpr, false );
					writeCode( "_exit()) );\n", false );
				}
				else
				{
					printf ( "Unknown sub widget type \"%s\".\n", checkExpr2 );
				}

				ii++;
			} //for
		}
		else if( strcmp( target, "EVENTCODE" ) == 0 )
		{
			ii = 0;

			for( getInSubN( inf, 0, checkExpr ); checkExpr[0] != 0L;
				getInSubN( inf, ii, checkExpr ) )
			{
				getInSubT( inf, ii, checkExpr2 );

				if( strcmp( checkExpr2, "SubWindow" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "click" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true,
						altExpr );

					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "start" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true,
						altExpr );

				}
				else if( strcmp( checkExpr2, "Button" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "click" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true,
						altExpr );

				}
				else if( strcmp( checkExpr2, "Label" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "click" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "PixLabel" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "click" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "LineEdit" ) == 0 )
				{

					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "return" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );

					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "changed" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "ListBox" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "changed" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "CheckBox" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "click" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "OptionButton" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "click" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "Slider" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "changed" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else if( strcmp( checkExpr2, "ProcCtrl" ) == 0 )
				{
					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "changed" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );

					lExpr[0] = 0L;
					strcat( lExpr, checkExpr );
					strcat( lExpr, "_" );
					strcat( lExpr, "exit" );

					makeAltFunc( lExpr, inf, altExpr );

					insertFile( lExpr, "cpp-code", true, altExpr );
				}
				else
				{
					printf ( "Unknown sub widget type \"%s\".\n", checkExpr2 );
				}

				ii++;
			} //for

		}
		else if( strcmp( target, "STARTEVENT" ) == 0 )
		{
			strcpy( lExpr, "start" );

			makeAltFunc( lExpr, inf, altExpr );

			insertFile( "start", "cpp-code", true, altExpr );
		}
		else if( strcmp( target, "CLICKEVENT" ) == 0 )
		{
			strcpy( lExpr, "click" );

			makeAltFunc( lExpr, inf, altExpr );

			insertFile( "click", "cpp-code", true, altExpr );
		}
		else
		{
			printf ( "Unknown target \"%s\" in *.cpp template.\n",
				target );
			exit(2);
		}
		
	}

	return true;
}


int makeBase( struct inFile *inf, char *headerT, char *codeT, int type )
{

	//(type: 0: Widget (SubWindow); 1: Window; 2: Main window)

	if (!openOut(inf)) return false;


	if (!parseHeader(inf,headerT))
	{
		fclose(fheader); fclose(fcppcode);
		return false;
	}

	if (!parseCpp(inf,codeT,type))
	{
		fclose(fheader); fclose(fcppcode);
		return false;
	}

	fclose(fheader); fclose(fcppcode);

	return true;
}
