%{

/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "vkcheck.tab.h"

extern int yylval;
void add_word( int, char *, char * );
void add_dword( int, char *, char *, char * );
int lookup_word( int, char * );
int strxcmp( char *, char * );

char *rem, *trem;

%}

VARNAME		[a-zA-Z][a-zA-Z0-9_]*
	/* Variable/const name */

FNAME		[a-zA-Z][a-zA-Z0-9]*
	/* Function (or property, etc) name */

OBJNAME		([\.]?([a-zA-Z][a-zA-Z0-9]*\.)*[a-zA-Z][a-zA-Z0-9]*)|\.
	/* Object name */


COMMENT		(([ \n\t]*"//"[^$]*$)|([ \n\t]*"/*"([^\*])*"*/"[ \n\t]*))
	/*Comments*/

SP		([ \n\t]|{COMMENT})+
	/* white-space */

BOOL		"TRUE"|"FALSE"
INT		[0-9]+
FLOAT		[0-9]*\.[0-9]+
STRING		[\"][^\"]*[\"]


%%

[\001]{FNAME}/({SP}[0-9]+[\001]) {

		/*New function name; add to symbol table*/
		yytext = yytext +sizeof(char);
		printf( "NEW FUNCTION %s\n", yytext );
		rem = (char *) malloc( sizeof(char) * (strlen(yytext)+1) );
		strcpy( rem, yytext );
	}

[0-9]+[\001] {
	char *yytcp;

		/*New function arguments number; add to symbol table*/
		yytcp = (char *)malloc( sizeof(char) *(strlen(yytext)+1) );
		strcpy( yytcp, yytext );
		yytcp[ strlen(yytcp)-1 ] = 0L;
		add_word( 1, rem, yytcp );
		free(rem);

		printf( "TERM\n" );
	}

[\002]{VARNAME}/({SP}({BOOL}|{INT}|{FLOAT}|{STRING})[\002]) {

		/*New constant name; add to symbol table*/
		yytext = yytext +sizeof(char);
		printf( "NEW CONSTANT %s\n", yytext );
		rem = (char *) malloc( sizeof(char) * (strlen(yytext)+1) );
		strcpy( rem, yytext );
	}

({BOOL}|{INT}|{FLOAT}|{STRING})[\002] {
	char *yytcp;

		/*New constant value; add to symbol table*/
		yytcp = (char *)malloc( sizeof(char) *(strlen(yytext)+1) );
		strcpy( yytcp, yytext );
		yytcp[ strlen(yytcp)-1 ] = 0L;
		add_word( 2, rem, yytcp );
		free(rem);
		printf( "TERM\n" );
	}

[\003]{FNAME}/({SP}{OBJNAME}[\004]({OBJNAME}?)[\003]) {

		/*New widget type; add to symbol table*/
		yytext = yytext +sizeof(char);
		printf( "NEW WIDGET OF TYPE %s\n", yytext );
		trem = (char *) malloc( sizeof(char) * (strlen(yytext)+1) );
		strcpy( trem, yytext );
	}

{OBJNAME}[\004] {

		/*New widget name (1st); add to symbol table*/
		rem = (char *) malloc( sizeof(char) * (strlen(yytext)+1) );
		strcpy( rem, yytext );
		rem[ strlen(rem)-1 ] = 0L;
		printf( "TERM a\n" );
	}

{OBJNAME}[\003] {
	char *yytcp;

		/*New widget name (2nd); add to symbol table*/
		yytcp = (char *)malloc( sizeof(char) *(strlen(yytext)+1) );
		strcpy( yytcp, yytext );
		yytcp[ strlen(yytcp)-1 ] = 0L;
		add_dword( 3, rem, yytcp, trem );
		free(rem);
		free(trem);
		printf( "TERM b\n" );
	}

[\003]		{  /* You can leave the 2nd name out */

		/* Add to symbol table anyway... */
		add_dword( 3, rem, "", trem );
		free(rem);
		free(trem);
		printf( "TERM b\n" );
	}

[\005]{VARNAME}/({SP}({BOOL}|{INT}|{FLOAT}|{STRING})[\005]) {

		/* New variable name; do nothing while only checking... */
		yytext = yytext +sizeof(char);
		printf( "NEW VARIABLE %s\n", yytext );
		rem = (char *) malloc( sizeof(char) * (strlen(yytext)+1) );
		strcpy( rem, yytext );
	}

({BOOL}|{INT}|{FLOAT}|{STRING})[\005] {
	char *yytcp;

		/* New variable value; do nothing while only checking... */
		yytcp = (char *)malloc( sizeof(char) *(strlen(yytext)+1) );
		strcpy( yytcp, yytext );
		yytcp[ strlen(yytcp)-1 ] = 0L;
		add_word( 5, rem, yytcp );
		free(rem);
		printf( "TERM\n" );
	}


("Function"|"Event"){SP}{VARNAME}	{ yylval = atoi(yytext); return HEAD; }

{BOOL}		{ yylval = atoi(yytext); return CBOOL; }
{INT}		{ yylval = atoi(yytext); return CINT; }
{FLOAT}		{ yylval = atoi(yytext); return CFLOAT; }
{STRING}	{ yylval = atoi(yytext); return CSTRING; }

"If"		{ yylval = atoi(yytext); return IF; }
"Then"		{ yylval = atoi(yytext); return THEN; }
"Else"		{ yylval = atoi(yytext); return ELSE; }
"For"		{ yylval = atoi(yytext); return FOR; }
"To"		{ yylval = atoi(yytext); return TO; }
"While"		{ yylval = atoi(yytext); return WHILE; }
"Do"		{ yylval = atoi(yytext); return DO; }

{FNAME}/@			{ yylval = atoi(yytext); return PROPERTY; }
@{OBJNAME}		{

				yytext = yytext +sizeof(char);

				yylval = atoi(yytext);

				if( !lookup_word(3, yytext) )
				{
					printf( "%s: NO SUCH OBJECT.\n", yytext );
					exit(2);
				}

				return OBJECT;
			}

{FNAME}/({SP}*\()	{
				yylval = atoi(yytext);

				if( strxcmp(yytext, "if") == 0 ) /* if and while
						could also be followed by '(' */
				{
					yylval = atoi(yytext);
					return IF;
				}

				if( strxcmp(yytext, "while") == 0 )
				{
					yylval = atoi(yytext);
					return WHILE;
				}

				if( strxcmp(yytext, "msgbox") != 0
					&& strxcmp(yytext, "exit") != 0
					&& strxcmp(yytext, "getopenfilename") != 0
					&& strxcmp(yytext, "getsavefilename") != 0
					&& strxcmp(yytext, "len") != 0
					&& strxcmp(yytext, "readfile") != 0
					&& strxcmp(yytext, "return") != 0
					&& strxcmp(yytext, "writefile") != 0
					&& !lookup_word(1, yytext) )
				{
					printf( "%s: NO SUCH FUNCTION.\n", yytext );
					exit(3);
				}

				return FUNCTION;
			}

{VARNAME}			{ yylval = atoi(yytext); return VAR; }

(\+)|(-)|(\*)|(\/)|(\^)|(%)|(&)	{ yylval = atoi(yytext); return OPERATOR; }
(==)|(<)|(>)|(<=)|(>=)|(\!=)	{ yylval = atoi(yytext); return OPERATOR; }

{SP}			;
.	return yytext[0];

%%

struct word
{
	char *entry;
	char *entry2;
	char *type_text;
	int type;
	struct word *next;
};

struct word *wlist = 0L;

void add_word( int type, char *new_word, char *new_word2 )
{
struct word *w;

	w = (struct word *) malloc( sizeof(struct word) );

	w->next = wlist;

	w->entry = (char *) malloc( sizeof(char) *(strlen(new_word)+1) );
	strcpy(w->entry, new_word);
	w->entry2 = (char *) malloc( sizeof(char) *(strlen(new_word2)+1) );
	strcpy(w->entry2, new_word2);
	w->type_text = (char *) malloc( sizeof(char) );
	w->type_text[0] = 0L;
	w->type = type;
	wlist = w;

	printf( "ADDED %s %s\n", new_word, new_word2 );
}

void add_dword( int type, char *new_word, char *new_word2, char *new_tinfo )
{
	add_word( type, new_word, new_word2 );
	free(wlist->type_text);
	wlist->type_text = (char *) malloc( (strlen(new_tinfo)+1)*sizeof(char) );
	strcpy( wlist->type_text, new_tinfo );
	printf( "Reg: %s, %s\n", wlist->entry, wlist->entry2 );
	
}

int strxcmp( char *w1, char *w2 )
{
int i;

	for( i = 1; w1[i] != 0L; i++ )
	{
		if( w2[i] == 0L ) return 1;

		if( tolower( w1[i] ) != tolower( w2[i] ) ) return -1;
	}

	if( w2[i] != 0L )
		return 2;
	else
		return 0;

}

int lookup_word( int type, char *lookupword )
{
struct word *w = wlist;

	while(w!=0L)
	{
		if( type == 3 )
		{

			if( (strxcmp(w->entry,lookupword) == 0
				|| strxcmp(w->entry2,lookupword) == 0 )
				&& w->type == 3 )
				return 1; /*Found*/
		}
		else
		{
			if( strxcmp(w->entry,lookupword) == 0
				&& w->type == type )
				return 1; /*Found*/
		}

		 w = w->next;
	}

	return 0; /* No such entry ... */
}