%{

/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <stdio.h>

%}

%token HEAD VAR FUNCTION OBJECT PROPERTY CINT CFLOAT CSTRING CBOOL OPERATOR IF THEN ELSE FOR TO WHILE DO

%%

input: statement ';' { printf( "OK\n" ); exit(0); }
	| HEAD '(' expressionlist ')' { printf( "OK\n" ); exit(0); }
	| HEAD '(' ')' { printf( "OK\n" ); exit(0); }
	;

statement:  returnunit '=' expression
	| function
	| basics
	| basics statement
	;

returnunit: var | '(' varlist ')' ;

basics: IF expression THEN
	| ELSE
	| FOR VAR '=' expression TO minexpression DO
	| WHILE expression DO
	;

varlist: var
	| varlist ',' var
	;

var: VAR | PROPERTY OBJECT;

expression: exprelement
	| expression OPERATOR exprelement
        ;

exprelement: minexpression
	| parexpression
	;

parexpression: '(' expression ')'
	;

minexpression: VAR | function | PROPERTY OBJECT | const ;

function: FUNCTION '(' ')'
	| FUNCTION '(' expressionlist ')'
	;

expressionlist: expression
	| expressionlist ',' expression
	;

const: CINT | CFLOAT | CSTRING | CBOOL ;

%%


extern FILE *yyin;

main()
{
	yyparse();
}

yyerror(char *s)
{
	printf( "SYNTAX ERROR\n" );
	exit(1);
}

