/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "morewidgets.h"
#include "morewidgets.moc"

/******************************************************************************
	class subButton:
*******************************************************************************/

subButton::subButton( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[9], nvs[9];
QString hStr;

	nps[0] = "Name"; nvs[0] = "SubButton";

	nps[1] = "Caption"; nvs[1] = "New Button";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "x"; nvs[4] = hStr.setNum(x);
	nps[5] = "y"; nvs[5] = hStr.setNum(y);

	nps[6] = "Enabled"; nvs[6] = "TRUE";
	nps[7] = "Visible"; nvs[7] = "TRUE";

	nps[8] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );
	pix.fill( QColor( 180, 180, 180 ) );

	ownType = ID_BUTTON;

	setImage(pix);

}


void subButton::drawPix()
{
QPainter p;

	pix.resize( width(), height() );
	pix.fill( QColor( 180, 180, 180 ) );

	p.begin(&pix);

	p.setPen( QColor( 100, 100, 100 ) );
	p.drawRect( 0, 0, width(), height() );

	p.setPen( QColor( 200, 200, 200 ) );

	p.drawLine( 0, 0, width(), 0 );
	p.drawLine( 0, 0, 0, height() );

	p.setPen(black);

	p.drawText( rect(), AlignCenter, myText );

	p.end();

	setImage(pix);
}


void subButton::newProperties( QString props[], QString vals[] )
{
bool ok;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			myText = vals[i];
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "Enabled" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subButton::newProperties(...): Illegal property (Internal error)." );


	} //for

	drawPix();

} //newProperties(...)




/******************************************************************************
	class subLabel:
*******************************************************************************/


subLabel::subLabel( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[9], nvs[9];
QString hStr;

	r = backgroundColor().red();
	g = backgroundColor().green();
	b = backgroundColor().blue();

	nps[0] = "Name"; nvs[0] = "SubLabel";

	nps[1] = "Caption"; nvs[1] = "New text label";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "x"; nvs[4] = hStr.setNum(x);
	nps[5] = "y"; nvs[5] = hStr.setNum(y);

	nps[6] = "Visible"; nvs[6] = "TRUE";

	nps[7] = "BackgroundColor";
	nvs[7] = QString( "(" +hStr.setNum(r) +"," +hStr.setNum(g) +","
		+hStr.setNum(b) +")" );

	nps[8] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	ownType = ID_LABEL;

	setImage(pix);

}


void subLabel::drawPix()
{
QPainter p;

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	p.begin(&pix);

	p.setPen( QColor( 100, 100, 100 ) );
	p.drawRect( 0, 0, width(), height() );

	p.setPen(black);

	p.drawText( rect(), AlignCenter, myText );


	p.end();

	setImage(pix);
}


void subLabel::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int inti1, inti2;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			myText = prfilter::mLines(vals[i]);
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "BackgroundColor" )
		{
			inti1 = 1; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			r = hStr.toInt();

			inti1++; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			g = hStr.toInt();

			inti1++; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			b = hStr.toInt();

		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subLabel::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)



/******************************************************************************
	class subPixLabel:
*******************************************************************************/

subPixLabel::subPixLabel( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[8], nvs[8];
QString hStr;

	nps[0] = "Name"; nvs[0] = "SubPixLabel";

	nps[1] = "Picture"; nvs[1] = "(none)";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "x"; nvs[4] = hStr.setNum(x);
	nps[5] = "y"; nvs[5] = hStr.setNum(y);

	nps[6] = "Visible"; nvs[6] = "TRUE";

	nps[7] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );
	pix.fill( QColor( 255, 255, 255 ) );

	ownType = ID_PIXLABEL;

	setImage(pix);

}


void subPixLabel::drawPix()
{
QPainter p;

	pix.resize( width(), height() );
	pix.fill( QColor( 180, 180, 180 ) );

	p.begin(&pix);

	p.setPen( QColor( 100, 100, 100 ) );
	p.drawRect( 0, 0, width(), height() );

	if( myPic != "(none)" )
		p.drawPixmap( 1, 1, pm );

	p.end();

	setImage(pix);
}


void subPixLabel::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Picture" )
		{
			myPic = vals[i];

			if( myPic != "(none)" )
			{
				if ( !pm.load( QString ("../pics/") +myPic ) )
					warning( "in subPixLabel::drawPix: unexpected file access error: %s",
						(const char *)myPic );
			}
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subLabel::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)


/******************************************************************************
	class subEdit:
*******************************************************************************/


subEdit::subEdit( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[9], nvs[9];
QString hStr;


	nps[0] = "Name"; nvs[0] = "LineEdit";

	nps[1] = "Caption"; nvs[1] = "Text";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "x"; nvs[4] = hStr.setNum(x);
	nps[5] = "y"; nvs[5] = hStr.setNum(y);

	nps[6] = "Enabled"; nvs[6] = "TRUE";
	nps[7] = "Visible"; nvs[7] = "TRUE";

	nps[8] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );

	ownType = ID_EDITW;

	setImage(pix);

}


void subEdit::drawPix()
{
QPainter p;

	pix.resize( width(), height() );

	pix.fill( QColor( 255, 255, 255 ) );

	p.begin(&pix);

	p.setPen( QColor( 80, 80, 80 ) );
	p.drawLine( 0, 0, width(), 0 );
	p.drawLine( 0, 0, 0, height() );

	p.setPen( QColor( 200, 200, 200 ) );
	p.drawLine( 0, height(), width(), height() );
	p.drawLine( width(), 0, width(), height() );

	p.setPen(black);

	p.drawText( rect(), AlignLeft, myText );


	p.end();

	setImage(pix);
}


void subEdit::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			myText = vals[i];
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "Enabled" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subEdit::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)




/******************************************************************************
	class subList:
*******************************************************************************/


subList::subList( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[9], nvs[9];
QString hStr;


	nps[0] = "Name"; nvs[0] = "ListBox";

	nps[1] = "Width"; nvs[1] = hStr.setNum( width() );
	nps[2] = "Height"; nvs[2] = hStr.setNum( height() );

	nps[3] = "x"; nvs[3] = hStr.setNum(x);
	nps[4] = "y"; nvs[4] = hStr.setNum(y);

	nps[5] = "AutoSort"; nvs[5] = "FALSE";

	nps[6] = "Enabled"; nvs[6] = "TRUE";

	nps[7] = "Visible"; nvs[7] = "TRUE";

	nps[8] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );

	ownType = ID_LIST;

	setImage(pix);

}


void subList::drawPix()
{
QPainter p;

	pix.resize( width(), height() );

	pix.fill(white);

	p.begin(&pix);

	p.setPen( QColor( 80, 80, 80 ) );
	p.drawLine( 0, 0, width(), 0 );
	p.drawLine( 0, 0, 0, height() );

	p.setPen( QColor( 200, 200, 200 ) );
	p.drawLine( 0, height(), width(), height() );
	p.drawLine( width(), 0, width(), height() );

	p.setPen(black); p.setBrush(black);
	p.drawRect( 1, 1, width()-2, 15 );

	p.setPen(white);
	p.drawRect( 2, 2, width()-4, 13 );

	p.end();

	setImage(pix);
}


void subList::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "AutoSort" )
		{
		}
		else if( props[i] == "Enabled" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subList::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)



/******************************************************************************
	class subCheckBox:
*******************************************************************************/


subCheckBox::subCheckBox( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[10], nvs[10];
QString hStr;


	nps[0] = "Name"; nvs[0] = "CheckBox";

	nps[1] = "Caption"; nvs[1] = "Check this";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "x"; nvs[4] = hStr.setNum(x);
	nps[5] = "y"; nvs[5] = hStr.setNum(y);

	nps[6] = "Checked"; nvs[6] = "FALSE";

	nps[7] = "Enabled"; nvs[7] = "TRUE";
	nps[8] = "Visible"; nvs[8] = "TRUE";

	nps[9] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );

	ownType = ID_CHECKW;

	setImage(pix);

}


void subCheckBox::drawPix()
{
QPainter p;
QRect r;

	pix.resize( width(), height() );

	pix.fill( backgroundColor() );

	p.begin(&pix);

	//Draw checkBox:
	if( isChecked )
	{
		p.setPen( QColor( 75, 75, 75 ) );
		p.setBrush( QColor( 75, 75, 75 ) );

		p.drawRect( 1, (height()-10)/2, 10, 10 );

		p.setPen( QColor( 240, 240, 240 ) );
		p.setBrush( QColor( 240, 240, 240 ) );

		p.drawRect( 3, (height()-10)/2+2, 8, 8 );
	}
	else
	{
		p.setPen( QColor( 240, 240, 240 ) );
		p.setBrush( QColor( 240, 240, 240 ) );

		p.drawRect( 1, (height()-10)/2, 10, 10 );

		p.setPen( QColor( 75, 75, 75 ) );
		p.setBrush( QColor( 75, 75, 75 ) );

		p.drawRect( 3, (height()-10)/2+2, 8, 8 );

	}

	p.setPen( QColor( 195, 195, 195 ) );
	p.setBrush( QColor( 195, 195, 195 ) );

	p.drawRect( 3, (height()-10)/2+2, 6, 6 );


	p.setPen(black);
	r = rect();
	r.setX(12);

	p.drawText( r, AlignLeft|AlignVCenter, myText );

	p.end();

	setImage(pix);

}


void subCheckBox::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			myText = vals[i];
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "Checked" )
		{
			if( vals[i] == "TRUE" )
				isChecked = true;
			else
				isChecked = false;
		}
		else if( props[i] == "Enabled" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subCheckBox::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)



/******************************************************************************
	class subOptionButton:
*******************************************************************************/


subOptionButton::subOptionButton( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[10], nvs[10];
QString hStr;


	nps[0] = "Name"; nvs[0] = "OptionButton";

	nps[1] = "Caption"; nvs[1] = "Check this";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "x"; nvs[4] = hStr.setNum(x);
	nps[5] = "y"; nvs[5] = hStr.setNum(y);

	nps[6] = "CheckedExclusive"; nvs[6] = "TRUE";

	nps[7] = "Enabled"; nvs[7] = "TRUE";
	nps[8] = "Visible"; nvs[8] = "TRUE";

	nps[9] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );

	ownType = ID_OPTIONW;

	setImage(pix);

}


void subOptionButton::drawPix()
{
QPainter p;
QRect r;

	pix.resize( width(), height() );

	pix.fill( backgroundColor() );

	p.begin(&pix);

	//Draw OptionButton:
	if( isChecked )
	{

		p.setPen( QColor( 75, 75, 75 ) );
		p.setBrush( QColor( 75, 75, 75 ) );

		p.drawLine( 1, (height()-13)/2 +7, 7, (height()-13)/2 );
		p.drawLine( 2, (height()-13)/2 +7, 7, (height()-13)/2 -1 );

		p.drawLine( 14, (height()-13)/2 +6, 7, (height()-13)/2 );
		p.drawLine( 13, (height()-13)/2 +6, 7, (height()-13)/2 -1 );

		p.setPen( QColor( 240, 240, 240 ) );
		p.setBrush( QColor( 240, 240, 240 ) );

		p.drawLine( 1, (height()-13)/2 +8, 8, (height()-13)/2 +14 );
		p.drawLine( 2, (height()-13)/2 +8, 8, (height()-13)/2 +15 );

		p.drawLine( 13, (height()-13)/2 +7, 8, (height()-13)/2 +14 );
		p.drawLine( 14, (height()-13)/2 +7, 8, (height()-13)/2 +15 );

	}
	else
	{
		p.setPen( QColor( 240, 240, 240 ) );
		p.setBrush( QColor( 240, 240, 240 ) );

		p.drawLine( 1, (height()-13)/2 +7, 7, (height()-13)/2 );
		p.drawLine( 2, (height()-13)/2 +7, 7, (height()-13)/2 -1 );

		p.drawLine( 14, (height()-13)/2 +6, 7, (height()-13)/2 );
		p.drawLine( 13, (height()-13)/2 +6, 7, (height()-13)/2 -1 );

		p.setPen( QColor( 75, 75, 75 ) );
		p.setBrush( QColor( 75, 75, 75 ) );

		p.drawLine( 1, (height()-13)/2 +8, 8, (height()-13)/2 +14 );
		p.drawLine( 2, (height()-13)/2 +8, 8, (height()-13)/2 +15 );

		p.drawLine( 13, (height()-13)/2 +7, 8, (height()-13)/2 +14 );
		p.drawLine( 14, (height()-13)/2 +7, 8, (height()-13)/2 +15 );

	}


	p.setPen(black);
	r = rect();
	r.setX(16);

	p.drawText( r, AlignLeft|AlignVCenter, myText );

	p.end();

	setImage(pix);

}


void subOptionButton::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			myText = vals[i];
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "CheckedExclusive" )
		{
			if ( vals[i] == "TRUE" )
			{
				isChecked = true;

				emit eCheck( getParent(), this );
			}
			else
				isChecked = false;

		}
		else if( props[i] == "Enabled" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subOptionButton::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)



/******************************************************************************
	class subSlider:
*******************************************************************************/


subSlider::subSlider( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[10], nvs[10];
QString hStr;


	nps[0] = "Name"; nvs[0] = "Slider";

	nps[1] = "Width"; nvs[1] = hStr.setNum( width() );
	nps[2] = "Height"; nvs[2] = hStr.setNum( height() );

	nps[3] = "x"; nvs[3] = hStr.setNum(x);
	nps[4] = "y"; nvs[4] = hStr.setNum(y);

	nps[5] = "Steps"; nvs[5] = "10"; mySteps = 10;
	nps[6] = "Value"; nvs[6] = "0"; myValue = 0;

	nps[7] = "Enabled"; nvs[7] = "TRUE";
	nps[8] = "Visible"; nvs[8] = "TRUE";

	nps[9] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );

	ownType = ID_SLIDER;

	setImage(pix);

}


void subSlider::drawPix()
{
QPainter p;
int i;

	pix.resize( width(), height() );

	pix.fill( backgroundColor() );

	p.begin(&pix);

	p.setPen(black);
	p.setBrush(black);

	p.drawLine( 1, height()/2, width()-2, height()/2 );

	for( i = 0; i <= mySteps; i++ )
	{
		p.drawLine( i*(width()/mySteps)+1, height()/2,
			i*(width()/mySteps)+1, height()/2+3 );
	}

	p.drawRect( myValue*(width()/mySteps), height()/2-2, 3, 9 );

	p.end();

	setImage(pix);
}


void subSlider::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "Steps" )
		{
			mySteps = vals[i].toInt();
		}
		else if( props[i] == "Value" )
		{
			myValue = vals[i].toInt();
		}
		else if( props[i] == "Enabled" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subSlider::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)


/******************************************************************************
	class subProcCtrl:
*******************************************************************************/


subProcCtrl::subProcCtrl( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[12], nvs[12];
QString hStr;

	r = backgroundColor().red();
	g = backgroundColor().green();
	b = backgroundColor().blue();

	nps[0] = "Name"; nvs[0] = "SubProcCtrl";

	nps[1] = "Caption"; nvs[1] = "(COMMAND) ";

	nps[2] = "Command"; nvs[2] = "";
	nps[3] = "Arguments"; nvs[3] = "";

	nps[4] = "Running"; nvs[4] = "FALSE";
	nps[5] = "ReturnVal"; nvs[5] = "-32";

	nps[6] = "Width"; nvs[6] = hStr.setNum( width() );
	nps[7] = "Height"; nvs[7] = hStr.setNum( height() );

	nps[8] = "x"; nvs[8] = hStr.setNum(x);
	nps[9] = "y"; nvs[9] = hStr.setNum(y);

	nps[10] = "Visible"; nvs[10] = "FALSE";

	nps[11] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	ownType = ID_PROCCTRL;

	setImage(pix);

}


void subProcCtrl::drawPix()
{
QPainter p;

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	p.begin(&pix);

	p.setPen( QColor( 100, 100, 100 ) );
	p.drawRect( 0, 0, width(), height() );

	p.setPen(black);

	p.drawText( rect(), AlignCenter, myText );


	p.end();

	setImage(pix);
}


void subProcCtrl::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int inti1, inti2;
int w = 5, h = 5, xx, yy;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			myText = prfilter::mLines(vals[i]);
		}
		else if( props[i] == "Command" )
		{
		}
		else if( props[i] == "Arguments" )
		{
		}
		else if( props[i] == "Running" )
		{
		}
		else if( props[i] == "ReturnVal" )
		{
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			xx = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( xx, y() );
		}
		else if( props[i] == "y" )
		{
			yy = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			move( x(), yy );
		}
		else if( props[i] == "Visible" )
		{
		}
		else
			fatal ( "In subProcCtrl::newProperties(...): Illegal property \"%s\" (Internal error).",
				(const char *)props[i] );

	} //for

	drawPix();

} //newProperties(...)

