/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef PEDIDIA_H
#define PEDIDIA_H

#include <qdialog.h>
#include <qmultilinedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlistbox.h>
#include <qstrlist.h>
#include <qdir.h>
#include <kfiledialog.h>
#include <kmsgbox.h>

#include "prfilter.h"

/*****************************************************************************
*	class mlDialog:
*	A dialog to change a multi lined string property (offers a description and
*	a QMultiLineEdit to change the property )
******************************************************************************/

class mlDialog : public QDialog
{
	Q_OBJECT

public:
	/* Constructs the dialog from a QString giving the label text and one,
	   giving the default (multi lined) text: */
	mlDialog( QString, QString );

	//Returns the new text (If the dialog was canceled it's the old one):
	inline QString ret() { return txt; }

private:
	virtual void resizeEvent( QResizeEvent * );

	QString txt;
	QMultiLineEdit *ed;
	QLabel *label;
	QPushButton *ok, *cancel;

private slots:
	void acceptDialog();
	void rejectDialog();
	
};

/*****************************************************************************
*	class tfDialog:
*	A dialog to change a BOOL property (offers a description and
*	the possibility to select either TRUE or FALSE)
******************************************************************************/

class tfDialog: public QDialog
{
	Q_OBJECT

public:
	tfDialog( QString, bool );

	inline bool ret() { return val; }

private:
	virtual void resizeEvent( QResizeEvent * );

	QLabel *label;

	QRadioButton *r1, *r2;
	QButtonGroup *grp;

	QPushButton *ok, *cancel;

	bool val;

private slots:
	void changed(int);

};


/*****************************************************************************
*	class picDialog:
*	A dialog to select a pixmap
******************************************************************************/

class picDialog: public QDialog
{
	Q_OBJECT

public:
	picDialog( QString );

	inline QString ret() { return val; }

private:
	virtual void resizeEvent( QResizeEvent * );

	QLabel *label;

	QListBox *list;

	QPushButton *ok, *add;

	QString val;

private slots:
	void change( const char * );
	void addPic();

};

#endif