/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "subwidget.h"
#include "subwidget.moc"

/******************************************************************************
	class subWin:
*******************************************************************************/

subWin::subWin( int x, int y, widgetHolder *parent ) : widgetHolder( parent )
{
QString nps[7], nvs[7];
QString hStr;

	r = backgroundColor().red();
	g = backgroundColor().green();
	b = backgroundColor().blue();

	nps[0] = "Name"; nvs[0] = "SubWindow";

	nps[1] = "Width"; nvs[1] = hStr.setNum( width() );
	nps[2] = "Height"; nvs[2] = hStr.setNum( height() );

	nps[3] = "x"; nvs[3] = hStr.setNum(x);
	nps[4] = "y"; nvs[4] = hStr.setNum(y);

	nps[5] = "BackgroundColor";
	nvs[5] = QString( "(" +hStr.setNum(r) +"," +hStr.setNum(g) +","
		+hStr.setNum(b) +")" );

	nps[6] = "";

	buildProperties( nps, nvs );

	move ( x, y );

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	ownType = ID_WID;
	setImage(pix);

	allowSubs = true;

}


void subWin::drawPix()
{
QPainter p;

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	p.begin(&pix);

	p.setPen( QColor( 100, 100, 100 ) );
	p.drawRect( 0, 0, width(), height() );

	p.end();

	setImage(pix);
}


void subWin::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int inti1, inti2;
int w = 5, h = 5;

	for ( i = 0; props[i] != ""; i++ )
	{
		vals[i] = prfilter::decodeQs(vals[i]);

		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

		}
		else if( props[i] == "x" )
		{
			hStr = vals[i];
			move( hStr.toInt(), y() );
		}
		else if( props[i] == "y" )
		{
			hStr = vals[i];
			move( x(), hStr.toInt() );
		}
		else if( props[i] == "BackgroundColor" )
		{
			inti1 = 1; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			r = hStr.toInt();

			inti1++; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			g = hStr.toInt();

			inti1++; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			b = hStr.toInt();

		}
		else
			fatal ( "In subWin::newProperties(...): Illegal property (Internal error)." );

	} //for

	drawPix();

} //newProperties(...)