/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef KSRCEDIT_H
#define KSRCEDIT_H

#include <ktopwidget.h>
#include <kapp.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <kfiledialog.h>

#include <qpopupmenu.h>
#include <qkeycode.h>
#include <qaccel.h>
#include <qfile.h>

#include "kwview.h"
#include "kwdoc.h"
#include "highlight.h"

#include "ids.h"

class KMenuBar;
class KToolBar;
class KStatusBar;
class QPopupMenu;

class KSrcEdit : public KTopLevelWidget
{
	Q_OBJECT

public:
	KSrcEdit( const char * );
	virtual ~KSrcEdit();
	void open( const char * );

protected:
	void createMenuBar();
	void createToolBar();
	void createStatusBar();

	void about();
	void fileQuit();
	void filePrint();
	void fileNewView();
	void editReloadVkc();

public slots:
	void dispatchCommand( int );

private:
	KMenuBar *mainMenu;
	QPopupMenu *fileMenu;
	QPopupMenu *editMenu;
	QPopupMenu *helpMenu;
	KToolBar *mainToolbar;
	KStatusBar *statusBar;

	HlManager *hlman;
	KWriteDoc *doc;
	KWrite *view;

};

#endif // KSRCEDIT_H
