/***************************************************************************
                          filetabbar.cpp  -  description
                             -------------------
    begin                : Sat Feb 26 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavski
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filetabbar.h"

FileTabBar::FileTabBar(QWidget *parent, const char *name ) : QTabBar(parent,name)
{
  setShape( QTabBar::RoundedBelow );

  QSize s = size();
  setMinimumHeight( s.height() );

  setFocusPolicy( QWidget::ClickFocus );
  tabsList=new QList<QTab>;
}

FileTabBar::~FileTabBar(){
  delete tabsList;
}


int FileTabBar::addTab(const char *text)
{
  QTab *tab = new QTab();
  QString name( text);
  int pos;
  while ( (pos = (int)name.find('/')) != -1 )
    name.remove(0,pos+1);
  tab->label = name;
  return addTab( tab);
}


int FileTabBar::addTab(QTab *newTab)
{
		int id=QTabBar::addTab(newTab);
		tabsList->append(newTab);
		return id;
}

void FileTabBar::removeTab(int id)
{
  QTab *tab;
	int width=0;
	int i;
	for (i=0; i<int(tabsList->count()); i++)
	{
	  tab=tabsList->at(i);
		if (tab && tab->id == id)
		{
		  width=tab->r.width()-4;
			tabList()->removeRef(tab);
			tabsList->removeRef(tab);
			break;
		};
	};
	if (width)
		for (i=0; i<int(tabsList->count()); i++)
		{
			tab=tabsList->at(i);
			if (tab && tab->id > id)
			{
				tab->r.moveBy(-width, 0);
				//width=tab->r.width()-4;
			};
		};
	repaint();
};

void FileTabBar::setTabLabel(int id, const char *text)
{
		QTab *t=tab(id);
		if (t)
				t->label=text;
		else
				return;
    QFontMetrics fm=fontMetrics();
		uint textWidth;
		QRect rect;
		for (uint i=0; i<tabsList->count(); i++)
				{
						t=tabsList->at(i);
						textWidth=fm.width(t->label);
						t->r.setRect(rect.isEmpty() ? 0 : rect.right()-3, 0, textWidth+24, fm.height()+10);
						rect=rect.unite(t->r);
				};
		repaint();
}

