/*
 *
 *
 *
 *
 *
 *
 *
 */

#include <stdio.h> //FER QUITA
#include <kurl.h>
#include <kmsgbox.h>
#include "kmasterdatacd.h"
#include "kmasterdatacd.moc"

KMasterDataCd::KMasterDataCd( QWidget *parent = 0 )
  : QGroupBox( parent, "KMasterDataCd" )
{
  config = kapp->getConfig();
  QSize size;          // we'll need it anyway....
  QBoxLayout *layout0 = new QVBoxLayout( this, 8, 3 );  // is TopLevelLayout
  QBoxLayout *layout1 = new QHBoxLayout( this );
  layout0->addLayout( layout1, 2 );

  /////////////////////////////////////////////////////////////////
  // left side....

  QBoxLayout *layout2 = new QVBoxLayout( this );
  layout1->addLayout( layout2 );
  fileListBox = new KTabListBox( this, "fileListBox", 3);
  fileListBox->setColumn( 0, klocale->translate("File/Folder"), 100);
  fileListBox->setColumn( 1, klocale->translate("Size"), 40);
  fileListBox->setColumn( 2, klocale->translate("File in image"), 75);
  fileListBox->setSeparator('\t');
  layout2->addWidget( fileListBox );
  //DND Support
  KDNDDropZone *dropFiles = new KDNDDropZone ( fileListBox, DndURL );
  connect( dropFiles, SIGNAL( dropAction( KDNDDropZone * )), this, SLOT( filesDropAction( KDNDDropZone * ))); 

  // Rigth button is pressed
  connect( fileListBox, SIGNAL( popupMenu( int, int )), this, SLOT( filePopup( int, int)));


  ////////////////////////////////////////////////////////////////////////////
  //  right side.....

  int rightWidth;               // stores the width of the biggest element....

  QWidget *right = new QWidget( this, "right" );
  right->setFixedWidth( 130 );
  layout1->addWidget( right );
  layout2 = new QVBoxLayout ( right );
  
  // some check boxes....
  QGroupBox *group = new QGroupBox("Settings", right);
  QVBoxLayout *layout3 = new QVBoxLayout( group, 5, 0 );
  layout3->addSpacing( 10 );
  rockRidge = new QCheckBox( klocale->translate("Rock Ridge Ext."), group);
  layout3->addWidget( rockRidge );
  joliet = new QCheckBox( klocale->translate("Joliet Extensions"), group);
  layout3->addWidget( joliet );
  size = rockRidge->sizeHint();
  group->setFixedHeight( size.height()*4 );
  layout2->addWidget( group );
  
  // CDR-Usage stuff.......
  group = new QGroupBox( klocale->translate("Image ISO-Usage"), right );
  layout3 = new QVBoxLayout( group, 5, 0 );
  layout3->addSpacing( 10 );
  imageSize = new QLabel("Size: 0", group);
  imageSizeNum = 0;
  layout3->addWidget( imageSize );
  imageTime = new QLabel("Time: 00:00", group);
  layout2->addWidget( imageTime );
  imageUsage = new KProgress( group );
  size = imageUsage->sizeHint();
  imageUsage->setFixedHeight( size.height() );
  group->setFixedHeight( size.height()*4 );
  layout3->addWidget( imageUsage );  
  layout2->addWidget( group );

  startMakeImage = new QPushButton( klocale->translate("&Make Image"), right );
  connect( this, SIGNAL( clicked() ), this, SLOT( makeImage() ) );
  size = startMakeImage->sizeHint();
  startMakeImage->setFixedSize( size );
  layout2->addSpacing( 10 );
  layout2->addWidget( startMakeImage );  




  //////////////
  // down
  QWidget *down = new QWidget( this, "down" );
  down->setFixedWidth( 300 );
  // Can I reuse layout2???
  layout2 = new QVBoxLayout ( down );
  QButtonGroup *isoStore = new QButtonGroup( klocale->translate("Store image in:"), down );
  layout3 = new QVBoxLayout( isoStore, 8, 0 );
  isoStoreFile = new QRadioButton( klocale->translate( "a in file:" ), isoStore);
  isoStoreFly = new QRadioButton( klocale->translate( "on the fly" ), isoStore);
  layout3->addSpacing( 10 );
  layout3->addWidget( isoStoreFly );
  layout3->addWidget( isoStoreFile );
  QLineEdit *outputFile = new QLineEdit( down , "Output File" );
  outputFile->setText("~/image.iso"); //Replace this with a VAR
  layout3->addWidget( outputFile );

  size = isoStoreFly->sizeHint();
  rightWidth = size.width()+20;
  //isoStore->setFixedHeight( size.height()*4 );
  //isoStore->setFixedHeight(300);
  //isoStore->setFixedWidth(300);
  layout2->addWidget( isoStore );
  layout0->addWidget( down, 1 );


  // adjust widgets
  //TODO: read this from Kconf
  rockRidge->setChecked( true );
  joliet->setChecked( false );  
  isoStoreFile->setChecked( true );
}

void KMasterDataCd::filesDropAction( KDNDDropZone *zone )
{
	QStrList myUrlList = zone->getURLList();
	char* f;
//A Prety feature , drop a url on other host, and get it
// via kfm 
// But now , we only support files:
	for ( f = myUrlList.first(); f; f = myUrlList.next())
	 	{
		KURL *myUrl = new KURL ( f );
		if ( myUrl->isLocalFile() )
		  {
		  // TODO: Is file already on ktablist? 
		  
		  // We insert the file in the ktab
		  fileListBox->insertItem( myUrl->path() );
		  
		  // Is a file?
		  if (strcmp(myUrl->filename(),""))
			  // We put it without the path in the image
		  	  fileListBox->changeItemPart( myUrl->filename(), fileListBox->numRows()-1 , 2 );  
		  else   // or a directory?
		 	{
			  // The same, but cannot use KURL::filename()
			  QString *qstr = new QString ( myUrl->path() );
			  qstr->remove( 0, qstr->findRev( "/", qstr->length()-2, TRUE )+1);
			  fileListBox->changeItemPart( qstr->data(), fileListBox->numRows()-1, 2 ); 
			}
		  // Get the size of the file/folder. We init a KProcess
		  getFileSize ( fileListBox->text( (fileListBox->numRows()-1), 0).data() );
		}
		else printf("I don't support non-files URLs (yet)\n");
	}
}                 

void KMasterDataCd::getFileSize( const char *myFile )
{
	KProcess *proc = new KProcess();
	proc->clearArguments();
	*proc << "/usr/bin/du" << "-s" << myFile;  //This must be a #define (and a config.h)
	connect(proc, SIGNAL(processExited(KProcess*)), this, SLOT(getSizeExit(KProcess*)));
	connect(proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(getSizeOutput(KProcess*, char*, int)));
	connect(proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(getSizeErr(KProcess*, char*, int)));
	proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);

}

void KMasterDataCd::getSizeOutput(KProcess*, char *output, int outputSize)
{
	if (outputSize > 0) {
		int rowToChange = 0;
		QString *str = new QString ( output );
		
		//Guess the filename we're du-ing
		str->remove(0, str->find("\t",1, TRUE)+1);
		str->remove(str->find("\n",1,TRUE), 7000);

		// Guess what row need to be updated
		for ( int i = 0; i <= fileListBox->numRows()-1; i++)
                {
			// Get the pos of file name in ktab
			QString *comp = new QString ( fileListBox->text(i,0).data() );
			if ( comp->findRev("/", -1, TRUE) == comp->length()-1 )
 			// is a directory, remove / to compare
				comp->remove( comp->length()-1, 1 );
			if ( *comp == *str ) rowToChange = i;
		}

		// Get the size of filename from du output
		str = new QString ( output );
		str->remove( str->find("\t", 1, TRUE), 1000 ); 

		//Put it into Ktab. TODO: nice presentation of Kbs, Ms,etc..
	    	fileListBox->changeItemPart( str->data(), rowToChange , 1 );
		updateIsoSize( rowToChange, true );
	}
}
void KMasterDataCd::getSizeErr(KProcess*, char *output, int outputSize)
{
	// This errors often are "cannot read file..."
	// ignore it? warn?
	
	// ignored!
	//printf("Opps, I recived an error from du:%s\n",output);
}

void KMasterDataCd::getSizeExit(KProcess*)
{
}

void KMasterDataCd::updateIsoSize( int rowChanged, bool add )
{
	// TODO: We've calculated the size with du
	// But this size != (exactly) size in the image
	// Improve it
	long size = 0;
	bool ok = FALSE;
	QString text;
	text = fileListBox->text(rowChanged, 1).copy();
	size = text.toLong(&ok);
	if (add)
 		imageSizeNum += size;
	else
		imageSizeNum -= size; 
	size = imageSizeNum/1024;
	char text2[32];
	sprintf(text2, "Size: %ldM" , size);
	imageSize->setText( text2 );
	/* TODO: Now I use 650 CD's, but It'll be good to
	 * read from KConf
	 */
	if (size>650)
		 KMsgBox::message( 0, klocale->translate("Warning"), klocale->translate("Image size is greater than CDR capacity, you'll have to remove some files before Make image"), KMsgBox::EXCLAMATION, klocale->translate("Close") );

		
}
		
void KMasterDataCd::filePopup( int row, int col )
{
	fileListBox->setCurrentItem( row, -1 );
	QPopupMenu *popup = new QPopupMenu ( 0 , "Menu" );
	popup->insertItem( klocale->translate("&Delete"), this, SLOT(removeFile() ));
	popup->insertItem( klocale->translate("&Change destination"), this, SLOT(changeFileDes() ));
	QCursor *cursor = new QCursor();
	popup->setGeometry(cursor->pos().x(), cursor->pos().y(), 20, 20);
	popup->show();
}

void KMasterDataCd::removeFile()
{
	int row = fileListBox->currentItem();
	updateIsoSize( row, false );
	fileListBox->removeItem( row );
	
}

void KMasterDataCd::fileDesChanged( const QString &file )
{
	fileListBox->changeItemPart( file.data(), fileListBox->currentItem(), 2);
}
void KMasterDataCd::changeFileDes()
{
	printf("Han solicitado cambiar un fichero\n");
	// This is a modal dialog box
	ChgFileDlg *dialog = new ChgFileDlg ( fileListBox );
	connect( dialog, SIGNAL(newDes( const QString&)), SLOT(fileDesChanged( const QString&)) );
	dialog->exec();

}

void KMasterDataCd::makeImage()
{
	bool create = true;
	KProcess *mkisofs = new KProcess;
	mkisofs->clearArguments();
	*mkisofs << "/usr/local/bin/mkisofs"; // Again....
	*mkisofs << "-a";
	if ( joliet->isChecked() ) *mkisofs << "-J";
	if ( rockRidge->isChecked() ) *mkisofs << "-R";
	if ( isoStoreFile->isChecked() )
	{
		*mkisofs << "-o";
		*mkisofs << outputFile->text();
	}
	else
	{
		printf("On the fly not supported yet\n");
		create = false;
	}
	for ( int i = 0; i <= fileListBox->numRows()-1; i++)
	{
		char *str = "";
		sprintf(str,"%s=%s", fileListBox->text(i,2).data(), fileListBox->text(i,0).data() );
		*mkisofs << str;
	}
	mkisofs->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}
		
	

ChgFileDlg::ChgFileDlg ( QWidget *parent, const char *name)
	: QDialog( parent, name, true )
{
	nameLbl = new QLabel ( "Enter destination:"  );
	nameLbl->setGeometry( 35, 15, 150, 30 );
	nameEdit = new QLineEdit ( this, "" ) ;
	nameEdit->setGeometry( 140, 20, 100, 20 );
	ok = new QPushButton( this, "&Ok"  );
	ok->setGeometry( 40, 80, 100,30 );
	connect( ok, SIGNAL(clicked()), SLOT(newFileDes()) );
	cancel = new QPushButton( this, "&Cancel" );
	cancel->setGeometry( 150,80, 100,30 );
        connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
	adjustSize();

};

void ChgFileDlg::newFileDes()
{
	emit newDes( nameEdit->text() );
	this->accept();
}

KMasterDataCd::~KMasterDataCd()
{
}

