/*
 * Implements the config-dialog.
 *
 * $Id: kprop.cpp,v 1.2 1998/08/05 16:36:02 core Exp $
 */

#include "kprop.h"
#include "kprop.moc"

#include <kfiledialog.h>

KcdrProp::KcdrProp()
  : QTabDialog( 0, "kcdroas_prop", TRUE )
{
  config = kapp->getConfig();     // okey - we have access to global config.....

  setCaption( "kcdroast Configuration");
  setCancelButton();
  setMinimumHeight( 350 );

  rtparanoia = new KRTparanoia( config );
  rtcdrecord = new KRTcdrecord( config );
    
  ///////////////////////////////////////////////////////////////////////////
  // setup the first tab "General"

  QWidget *page = new QWidget( this, "general" );
  QGridLayout *layout0 = new QGridLayout( page, 5, 2 , 5, 2);
    
  QButtonGroup *cdrLength = new QButtonGroup( klocale->translate("Default CDR-Length"), page);
  QBoxLayout *layout1 = new QVBoxLayout( cdrLength, 5, 1 );
  layout1->addSpacing(15);
  cdrLength74 = new QRadioButton( klocale->translate("74min (650MB)"), cdrLength);
  layout1->addWidget( cdrLength74 );
  cdrLength63 = new QRadioButton( klocale->translate("63min (553MB)"), cdrLength);
  layout1->addWidget( cdrLength63 );
  layout0->addMultiCellWidget( cdrLength, 0, 1, 0, 0 );
  
  QGroupBox *group = new QGroupBox( klocale->translate("Default"), page );
  layout1 = new QVBoxLayout( group, 5, 1 );
  layout1->addSpacing( 15 );
  dummyWrite = new QCheckBox( klocale->translate("Simulation write"), group, "dummy");
  layout1->addWidget( dummyWrite );
  ejectAfterWrite = new QCheckBox(klocale->translate("Eject after write"),group,"eject");
  layout1->addWidget( ejectAfterWrite );
  layout0->addMultiCellWidget( group, 0, 1, 1, 1 );
  
  readingDev = new QLineEdit( page );
  readingDev->setFixedHeight( 25 );
  QLabel *label = new QLabel( readingDev, klocale->translate( "Reading device [ audio ]" ), page );
  layout0->addWidget( label, 2, 0 );
  layout0->addWidget( readingDev, 2, 1 );


  bufferPath = new QLineEdit( page );
  bufferPath->setFixedHeight( 25 );
  label = new QLabel( bufferPath, klocale->translate("Disk buffer Directory:"), page );
  layout0->addWidget( label, 3, 0 );
  layout0->addWidget( bufferPath, 3, 1 );

  showStartupInfo = new QCheckBox( klocale->translate("Show information dialog on startup"), page, "startup_info");
  layout0->addMultiCellWidget( showStartupInfo, 4, 4, 0, 1 );
  
  addTab( page, klocale->translate("General"));
  
  // adjust widgets

  QString tmp;
  config->setGroup("general");
  tmp = config->readEntry("StartupInfoDlg", "1");
  if ( tmp == "0" ){
    showStartupInfo->setChecked( FALSE );
  } else {
    showStartupInfo->setChecked( TRUE );
  };
  tmp = config->readEntry("EjectAfterWrite", "1");
  if ( tmp == "0" ){
    ejectAfterWrite->setChecked( FALSE );
  } else {
    ejectAfterWrite->setChecked( TRUE );
  };
  tmp = config->readEntry("DummyWrite", "1");
  if ( tmp == "0" ){
    dummyWrite->setChecked( FALSE );
  } else {
    dummyWrite->setChecked( TRUE );
  }
  tmp = config->readEntry("CdrLength", "74");
  if ( tmp == "63" ) {
    cdrLength74->setChecked( FALSE );
    cdrLength63->setChecked( TRUE );
  } else {
    cdrLength74->setChecked( TRUE );
    cdrLength63->setChecked( FALSE );    
  };

  bufferPath->setText( config->readEntry( "BufferPath", "/tmp/" ) );
  readingDev->setText( config->readEntry( "ReadingDev", "/dev/cdrom" ) );
  
  //////////////////////////////////////////////////////////////////////////////
  // setup second Tab "Tools"

  page = new QWidget( this, "tools" );

  QVBoxLayout *layout10 = new QVBoxLayout( page );

  group = new QGroupBox( klocale->translate( "cdda - audio reading tool" ), page );
  QGridLayout *layout11 = new QGridLayout( group, 2, 3, 20, 2 );

    readingTool = new QComboBox( false, group );
    readingTool->insertItem( "cdParanoia" );     // 0 = cdparanoia
    // readingTool->insertItem( "readcdda" );       // 1 = readcdda
    // readintTool->insertItem( "cdda2wav" );
    readingTool->setFixedSize( readingTool->sizeHint() );
    layout11->addWidget( readingTool, 0, 0 );
    connect( readingTool, SIGNAL( activated( int ) ), this, SLOT( readingToolChanged( int ) ) );
    readingToolPath = new QLineEdit( group );
    readingToolPath->setFixedHeight( 25 );
    layout11->addWidget( readingToolPath, 0, 1 );
    QPushButton *pbt = new QPushButton( "...", group );
    pbt->setFixedSize( pbt->sizeHint() );
    layout11->addWidget( pbt, 0, 2 );
    connect( pbt, SIGNAL( clicked() ), this, SLOT( findReadingTool() ) );
    pbt = new QPushButton( klocale->translate( "setup / options" ), group );
    layout11->addMultiCellWidget( pbt, 1, 1, 1, 2 );
    connect( pbt, SIGNAL( clicked() ), this, SLOT( readingToolOptions() ) );
    readingToolPath->setText( config->readEntry( "ReadingToolPath", "" ) );
    readingTool->setCurrentItem( config->readNumEntry( "ReadingTool", 0 ) );
  
  layout10->addWidget( group );
  group = new QGroupBox( klocale->translate( "cdr writing tool" ), page );
  layout11 = new QGridLayout( group, 2, 3, 20, 2 );

    writingTool = new QComboBox( false, group );
    writingTool->insertItem( "cdrecord" );     // 0 = cdrecord
    writingTool->setFixedSize( writingTool->sizeHint() );
    layout11->addWidget( writingTool, 0, 0 );
    connect( writingTool, SIGNAL( activated( int ) ), this, SLOT( writingToolChanged( int ) ) );
    writingToolPath = new QLineEdit( group );
    writingToolPath->setFixedHeight( 25 );
    layout11->addWidget( writingToolPath, 0, 1 );
    pbt = new QPushButton( "...", group );
    pbt->setFixedSize( pbt->sizeHint() );
    layout11->addWidget( pbt, 0, 2 );
    connect( pbt, SIGNAL( clicked() ), this, SLOT( findWritingTool() ) );
    pbt = new QPushButton( klocale->translate( "setup / options" ), group );
    layout11->addMultiCellWidget( pbt, 1, 1, 1, 2 );
    connect( pbt, SIGNAL( clicked() ), this, SLOT( writingToolOptions() ) );
    writingToolPath->setText( config->readEntry( "WritingToolPath", "q" ) );
    writingTool->setCurrentItem( config->readNumEntry( "WritingTool", 0 ) );
    
  layout10->addWidget( group );
  group = new QGroupBox( klocale->translate( "iso9660 - mastering tool" ), page );
  layout11 = new QGridLayout( group, 2, 3, 20, 2 );

    // iso9660-mastering stuff here

  layout10->addWidget( group );
  
  // adjust widgets

 

  
  addTab( page, klocale->translate("Tools"));

  connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( save() ));
}

KcdrProp::~KcdrProp()
{
}

void KcdrProp::save()
{
  QString v;
  v = "0";
  if ( showStartupInfo->isChecked() ) v = "1";
  config->writeEntry("StartupInfoDlg", v);
  v = "0";
  if ( ejectAfterWrite->isChecked() ) v = "1";
  config->writeEntry("EjectAfterWrite", v);
  v = "0";
  if ( dummyWrite->isChecked() ) v = "1";
  config->writeEntry("DummyWrite", v);
  v = "74";
  if ( cdrLength63->isChecked() ) v = "63";
  config->writeEntry( "CdrLength", v );

  config->writeEntry( "ReadingDev", readingDev->text() );
    
  v = bufferPath->text();
  if ( v.right(1) != "/" ) {
    v.append( "/" );
  };
  config->writeEntry( "BufferPath", v );


  // ToDo: check sanity !
  config->writeEntry( "ReadingToolPath", readingToolPath->text() );
  config->writeEntry( "ReadingTool", readingTool->currentItem() );
  config->writeEntry( "WritingToolPath", writingToolPath->text() );
  config->writeEntry( "WritingTool", writingTool->currentItem() );
  
  // config->writeEntry("Configured", "1");
  

  config->sync();
}

void KcdrProp::findReadingTool()
{
  QString filename;
  filename = KFileDialog::getOpenFileName( config->readEntry( "ReadingToolPath", "" ) );
  config->setGroup( "General" );
  if ( !filename.isEmpty() ) {
    config->writeEntry( "ReadingToolPath", filename );
    readingToolPath->setText( filename );
  };
}

void KcdrProp::findWritingTool()
{
  QString filename = KFileDialog::getOpenFileName( config->readEntry( "WritingToolPath", "" ) );
  config->setGroup( "General" );
  if ( !filename.isEmpty() ) {
    config->writeEntry( "WritingToolPath", filename );
    writingToolPath->setText( filename );
  };
}

void KcdrProp::readingToolChanged( int item )
{
}

void KcdrProp::writingToolChanged( int item )
{
}

void KcdrProp::readingToolOptions()
{
  switch ( config->readNumEntry( "ReadingTool", 0 ) ) 
    {
    case 0:                  // cdparanoia
      if ( rtparanoia->exec() ) {
	config->writeEntry( "ReadingTool0Options", rtparanoia->options->text() );
      };
      break;
    case 1:                  // 
      break;
    };
}

void KcdrProp::writingToolOptions()
{
  switch ( config->readNumEntry( "WritingTool", 0 ) )
    {
    case 0:                 // cdrecord
      if ( rtcdrecord->exec() ) {
	config->writeEntry( "WritingTool0Options", rtcdrecord->options->text() );
      };
      break;
    };
}


/*
 *
 */

KRTparanoia::KRTparanoia( KConfig *config, QWidget *parent = 0 )
  : QDialog( parent, klocale->translate( "cdparanoia options" ), TRUE )
{
  setFixedSize( 450, 100 );
 
  QPushButton *pbt = new QPushButton( klocale->translate( "Ok" ), this );
  pbt->setGeometry( 50, 60, 150, 30);
  connect( pbt, SIGNAL( clicked() ), this, SLOT( accept() ) );
  pbt = new QPushButton( klocale->translate( "Cancel" ), this );
  pbt->setGeometry( 250, 60, 150, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( reject() ) );
  
  options = new QLineEdit( this );
  options->setText( config->readEntry( "ReadingTool0Options", "" ) );
  options->setGeometry( 50, 30 ,400, 20 );
}

KRTcdrecord::KRTcdrecord( KConfig *config, QWidget *parent = 0 )
  : QDialog( parent, klocale->translate( "cdrecord options" ), TRUE )
{
  setFixedSize( 450, 100 );
 
  if ( config->readEntry( "WritingTool0Options", "" ) == "" ) {
    config->writeEntry( "WritingTool0Options", "dev=0,0" );
  }
  
  QPushButton *pbt = new QPushButton( klocale->translate( "Ok" ), this );
  pbt->setGeometry( 50, 60, 150, 30);
  connect( pbt, SIGNAL( clicked() ), this, SLOT( accept() ) );
  pbt = new QPushButton( klocale->translate( "Cancel" ), this );
  pbt->setGeometry( 250, 60, 150, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( reject() ) );
  
  options = new QLineEdit( this );
  options->setText( config->readEntry( "WritingTool0Options", "" ) );
  options->setGeometry( 50, 30 ,400, 20 );
}
