/*  
	echklist.h V0.3.0 April 1998
	
	Requires the Qt widget libraries, available at no cost at 
    http://www.troll.no
       
    Copyright (C) 1998 Bernd Schumacher & Othmar Ehrhardt
                       Bernd_Schumacher@fh-konstanz.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Library General Public License as
	published by  
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/

#ifndef echklist_h
#define echklist_h

#include <qlistbox.h>
#include <qpixmap.h>
#include <qapp.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qkeycode.h>

class ECheckListItem : public QListBoxItem
{
    public:
        ECheckListItem( const char *s, const QPixmap p,
				bool doCheck=FALSE, bool doEnable=TRUE );
		virtual ~ECheckListItem();

    protected:
     	virtual void paint( QPainter * );
        virtual int height( const QListBox * ) const;
        virtual int width( const QListBox * ) const;
        virtual const QPixmap *pixmap() { return &pm; };
		virtual bool isChecked() { return checked; };
		virtual void setChecked( bool check ) { checked=check; };
		virtual bool isEnabled() { return enabled; }
		virtual void setEnabled( bool enable ) { enabled=enable; };
		virtual QRect boundingRect( QPainter *p );
		
    private:
		friend class ECheckList;
        QPixmap pm;
		bool checked;
		bool enabled;
};


class ECheckList : public QListBox
{
	Q_OBJECT

	public:
		ECheckList(	QWidget *parent=0, const char *name=0, WFlags f=0 );
		virtual ~ECheckList();
		virtual bool isChecked( int );
		virtual bool isChecked( const char * );
		virtual void setChecked( int, bool check );
		virtual bool isEnabled( int );
		virtual void setEnabled( int, bool enable );
		
//disable baseclass methods
	void insertStrList ( const QStrList *, int ){};
    void insertStrList ( const char **, int, int ){}; 
    void inSort ( const QListBoxItem * ){};
    void inSort ( const char *){};
	void setMultiSelection( bool ){};
	
	protected:
		virtual void mousePressEvent( QMouseEvent *e );
		virtual void paintCell( QPainter *p, int row, int col );
		virtual void keyPressEvent( QKeyEvent *e );
		
	signals:
		void toggled( int, bool );
		void toggled( const char*, bool );
};


#endif //echklist_included


