#include "kdetaillist.h"
#include <iostream.h>
#include <kapp.h>

#ifndef ICON_HEIGHT
#define ICON_HEIGHT	18
#endif

#include <qbitmap.h>
#define mask_width 16
#define mask_height 16
static unsigned char mask_bits[] = {
   0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
   0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
   0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55};

KDetailList::KDetailList(int format, QWidget *parent, const char *name, WFlags f)
	: KFileListBase(parent,name,f)
{
	setTableFlags(Tbl_hScrollBar | Tbl_vScrollBar | Tbl_smoothScrolling);
	setLineWidth(1);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setNumRows(0);
//	setNumCols(5);
	setCellHeight(ICON_HEIGHT);
	setCellWidth(0);
/*	ColWidth[0] = 150;
	ColWidth[1] = 100;
	ColWidth[2] = 150;
	ColWidth[3] = 200;
	ColWidth[4] = 150;*/
	Mask.resize(16,16);
	Mask.fill(backgroundColor());
	QBitmap	bm(mask_width,mask_height,mask_bits);
	Mask.setMask(bm);
	DateFormat = format;
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(sliderPressed()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(nextLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(prevLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(nextPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(prevPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(sliderPressed()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(nextLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(prevLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(nextPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(prevPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(sliderMoved(int)),(const QObject*)this,SIGNAL(hScroll(int)));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(valueChanged(int)),(const QObject*)this,SIGNAL(hScroll(int)));
}

void KDetailList::setColumnWidth(int col, int w)
{
	cancelEdit();
	ColWidth[col] = w;
	updateTableSize();
	update();
}

void KDetailList::paintCell(QPainter *p, int row, int col)
{
	int		index = row;
	FileInfo	*item = index < (int)(FileList->count()) ? FileList->at(index) : 0;
	if (item) {
		QString	tmp;
		switch (ColType[col]) {
		   case 0:
			if (Selected->findRef(item) != -1) {
				p->setBrush(darkBlue);
				p->drawRect(0,0,ColWidth[col],ICON_HEIGHT);
				p->setBrush(NoBrush);
				p->drawWinFocusRect(0,0,ColWidth[col],ICON_HEIGHT);
				p->setRasterOp(NotROP);
				p->drawText(ICON_HEIGHT,0,ColWidth[col]-ICON_HEIGHT,ICON_HEIGHT,AlignVCenter,item->fileName().data());
				p->setRasterOp(CopyROP);
			}
			else p->drawText(ICON_HEIGHT,0,ColWidth[col]-ICON_HEIGHT,ICON_HEIGHT,AlignVCenter,item->fileName().data());
			p->drawPixmap(1,1,*(item->miniIcon()));
			if (item->isSymLink() && LinkArrow) {
				p->drawPixmap(1,1,*LinkArrow);
			}
			if (item->isCutted()) p->drawPixmap(1,1,Mask);
			p->setPen(colorGroup().text());
			break;
		   case 1:
//			tmp.setNum(item->size());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,processSize(item->size()).data());
			break;
		   case 2:
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,item->description());
			break;
		   case 3: {
			QString		date;
			switch (DateFormat) {
			   case 0: date = item->lastModified().toString(); break;
			   case 1: date = item->lastModified().date().toString(); break;
			   case 2: date = item->lastModified().time().toString(); break;
			   case 3: {
#define	ItemDate	item->lastModified().date()
#define	ItemTime	item->lastModified().time()
				date.sprintf("%.2d/%.2d/%.4d %.2d:%.2d",ItemDate.day(),ItemDate.month(),ItemDate.year(),ItemTime.hour(),ItemTime.minute()); break;
#undef	ItemDate
#undef	ItemTime
			   }
			}
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,date.data());
			break;
		   }
		   case 4: {
			QFont	f(p->font());
			p->setFont(QFont("fixed",f.pointSize(),f.weight(),f.italic()));
			p->drawText(0,0,ColWidth[col]-5,ICON_HEIGHT,AlignVCenter | AlignRight,item->permissions().data());
			p->setFont(f);
			break;
		   }
		}
	}
}

void KDetailList::getTablePosition(int index, int& row, int& col)
{
	col = nameCol;
	row = index;
}

bool KDetailList::getItemCell(int row, int col, FileInfo **item, QPoint p)
{
	bool	selected = FALSE;
	*item = 0;
	int	index = row;
	QFontMetrics	fm(font());
	if (FileList == 0 || index >= (int)(FileList->count())) return selected;
	*item = FileList->at(index);
	int	xPos;
	if (col == nameCol && colXPos(col,&xPos))
		if (p.x() > xPos && p.x() < xPos+cellHeight()+fm.width((*item)->fileName().data()))
			selected = TRUE;
	return selected;
}

QRect KDetailList::getItemTextRect(FileInfo *item)
{
	int	row,col;
	getTablePosition(item->index(),row,col);
	int	xPos;
	colXPos(col,&xPos);
	return QRect(xPos+cellHeight(),row*cellHeight()+lineWidth()-yOffset(),
		     cellWidth(nameCol)-cellHeight(),cellHeight());
}

void KDetailList::updateListSize()
{
	if (FileList && FileList->count() > 0)
		setNumRows(FileList->count());
	else setNumRows(0);
}

int KDetailList::cellWidth(int col)
{
	return ColWidth[col];
}

void KDetailList::setColumns(QStrList& Type, QStrList& Width)
{
	nCol = Type.count();
	nameCol = 0;
	QString	num;
	for (int i=0;i<nCol;i++) {
		num = Width.at(i);
		ColWidth[i] = num.toInt();
		ColWidth[i] = QMAX(0,ColWidth[i]);
		num = Type.at(i);
		ColType[i] = num.toInt();
		if (ColType[i] == 0) nameCol = i;
		if (ColType[i] < 0 || ColType[i] > 4) ColType[i] = -1;
	}
	for (int i=nCol;i<5;i++) {
		ColWidth[i] = 0;
		ColType[i] = -1;
	}
	setNumCols(nCol);
}

void KDetailList::getColumns(QStrList& Type, QStrList& Width)
{
	Width.clear();
	QString	num;
	for (int i=0;i<nCol;i++) {
		num.setNum(cellWidth(i));
		Width.append(num.data());
	}
}

//----------------------------------------------------------------------------------------------

char *prefix[] = { "Gb","Mb","Kb","bytes"};

QString processSize(uint size)
{
	QString	retval;
	uint	div(1000000000), index(0);
	while (1 && index < 4) {
		if (size / div > 0) break;
		index++;
		div /= 1000;
	}
	if (size == 0 || index == 3) retval.sprintf("%d",size);
	else retval.sprintf("%.1f %s",((double)size)/div,prefix[index]);
	return retval;
}
