#ifndef _KDETAILLIST_H_
#define _KDETAILLIST_H_

#include "kflistbase.h"

class KDetailList : public KFileListBase
{
	Q_OBJECT

public:
	KDetailList(int format = 0, QWidget *parent = 0, const char *name = 0, WFlags f = 0);

	void setColumns(QStrList& Type, QStrList& Width);
	void getColumns(QStrList& Type, QStrList& Width);

public slots:
	void setColumnWidth(int col, int w);

signals:
	void hScroll(int value);

protected:
	virtual void paintCell(QPainter *p, int row, int col);
	virtual void getTablePosition(int index, int& row, int& col);
	virtual bool getItemCell(int row, int col, FileInfo **item, QPoint p);
	virtual QRect getItemTextRect(FileInfo *item);
	virtual void updateListSize();

	virtual int cellWidth(int col);

private:
	int	nCol;
	int	ColType[5];
	int	ColWidth[5];
	int	nameCol;
	int	DateFormat;
};

QString processSize(uint size);

#endif

