#ifndef _KFILEHEADER_H_
#define _KFILEHEADER_H_

#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qdir.h>

#ifndef ICON_HEIGHT
#define ICON_HEIGHT	18
#endif

class KFileHeader : public QWidget
{
	Q_OBJECT

public:
	KFileHeader(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~KFileHeader();

	void setColumns(QStrList& Type, QStrList& Width, QString *Name);

public slots:
	void setHScrollValue(int value);

signals:
	void changeColWidth(int col, int width);
	void columnPressed(int col);

protected:
	void paintEvent(QPaintEvent *);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	uint getTotalWidth();

private:
	QString		Names[5];
	int		ColWidth[5];
	bool		isPressed[5];
	uint		dx;
	bool		Resizing;
	int		ColResized;
	int		prev_x;
	int		nCol;
};

inline uint KFileHeader::getTotalWidth()
{
	uint	result = 0;
	for (int i=0; i<5; i++) result += ColWidth[i];
	return result;
}

#endif

