#include "kfixpanner.h"

KFixPanner::KFixPanner(QWidget *parent, Orientation type)
	: QWidget(parent), C0(0), C1(0), C0Width(0), Type(type), Activated(FALSE)
{
}

void KFixPanner::activate(QWidget *c0, QWidget *c1)
{
	C0 = c0;
	C1 = c1;
	Activated = TRUE;
	C0Width = (Type == Vertical ? C0->width() : C0->height());
	resizeEvent(0);
}

void KFixPanner::disactivate()
{
	Activated = FALSE;
}

void KFixPanner::resizeEvent(QResizeEvent *)
{
	if (Activated) {
		switch(Type) {
		   case Vertical:
			C0->setGeometry(0,0,C0Width,height());
			C1->setGeometry(C0Width,0,width()-C0Width,height());
			break;
		   case Horizontal:
			C0->setGeometry(0,0,width(),C0Width);
			C1->setGeometry(0,C0Width,width(),height()-C0Width);
			break;
		}
	}
}

