#include "opt_cd.h"

#define slotLog

opt_cd::opt_cd(QWidget*       parent,
	       const char*    name,
	       KSimpleConfig* globConf,			   
	       T_Options*     pSaveOpts,
	       T_Options*     pAktOpts,
	       bool*          changed)
  :QDialog( parent, name, TRUE, 110592 ) {
  
  defOpts    = pSaveOpts;
  aktOpts    = pAktOpts;  
  globalConf = globConf;
  optsApplied= changed;
  
  tabCtl = new KTabCtl(this, "tabPages");
  tabCtl->setGeometry(1, 1, 600, 310);
  tabP1 = new QWidget(tabCtl, "tabP1");
  tabCtl->addTab(tabP1, i18n("basics"));
  tabP3 = new QWidget(tabCtl, "tabP3");
  tabCtl->addTab(tabP3, i18n("filesystem"));
  tabP4 = new QWidget(tabCtl, "tabP4");
  tabCtl->addTab(tabP4, i18n("IDs"));

  /*************** basics *****************************************/
  QGroupBox_1= new QButtonGroup(tabP1,"NoName");
  QGroupBox_1->setGeometry(10,10,280,120);
  QGroupBox_1->setTitle(i18n("type of cd"));

  QRadioButton_1= new QRadioButton(QGroupBox_1,"NoName");
  QRadioButton_1->setGeometry(10,20,260,30);
  QRadioButton_1->setText(i18n("\"normal\" data cd"));

  QRadioButton_2= new QRadioButton(QGroupBox_1,"NoName");
  QRadioButton_2->setGeometry(10,50,260,30);
  QRadioButton_2->setText(i18n("multisession cd"));

  QRadioButton_3= new QRadioButton(QGroupBox_1,"NoName");
  QRadioButton_3->setGeometry(10,80,260,30);
  QRadioButton_3->setText(i18n("bootable cd"));

  QCheckBox_1= new QCheckBox(tabP1,"NoName");
  QCheckBox_1->setGeometry(300,90,280,30);
  QCheckBox_1->setText(i18n("simulation/dummy write"));

  QCheckBox_2= new QCheckBox(tabP1,"NoName");
  QCheckBox_2->setGeometry(300,115,280,30);
  QCheckBox_2->setText(i18n("pad data track"));

  QGroupBox_2= new QButtonGroup(tabP1,"NoName");
  QGroupBox_2->setGeometry(300,10,280,80);

  QRadioButton_4= new QRadioButton(QGroupBox_2,"NoName");
  QRadioButton_4->setGeometry(10,10,260,30);
  QRadioButton_4->setText(i18n("create image while writing (\"on-the-fly\")"));

  QRadioButton_5= new QRadioButton(QGroupBox_2,"NoName");
  QRadioButton_5->setGeometry(10,40,260,30);
  QRadioButton_5->setText(i18n("create image before writing"));

  /***************** multisession cd/bootable cd *******************/
  QGroupBox_1f= new QButtonGroup(tabP1,"NoName");
  QGroupBox_1f->setGeometry(10,150,360,120);
  QGroupBox_1f->setTitle(i18n("multisession cd"));

  QRadioButton_1f= new QRadioButton(QGroupBox_1f,"NoName");
  QRadioButton_1f->setGeometry(10,20,340,30);
  QRadioButton_1f->setText(i18n("first session"));

  QRadioButton_2f= new QRadioButton(QGroupBox_1f,"NoName");
  QRadioButton_2f->setGeometry(10,50,340,30);
  QRadioButton_2f->setText(i18n("one of the sessions in between"));

  QRadioButton_3f= new QRadioButton(QGroupBox_1f,"NoName");
  QRadioButton_3f->setGeometry(10,80,340,30);
  QRadioButton_3f->setText(i18n("last session"));

  QGroupBox_2f= new QGroupBox(tabP1,"NoName");
  QGroupBox_2f->setGeometry(10,150,360,100);
  QGroupBox_2f->setTitle(i18n("bootable cd"));

  QPushButton_1f= new QPushButton(tabP1,"NoName");
  QPushButton_1f->setGeometry(260,170,100,30);
  QPushButton_1f->setText(i18n("browse..."));

  QLabel_1f= new QLabel(tabP1,"NoName");
  QLabel_1f->setGeometry(20,210,340,30);
  QLabel_1f->setText(i18n("Label"));

  QLabel_2f= new QLabel(tabP1,"NoName");
  QLabel_2f->setGeometry(20,170,230,30);
  QLabel_2f->setText(i18n("path to bootable image:"));

  /************************ Filesystem *******************************************/
  cbSymlink = new QCheckBox( tabP3, "CheckBox_1" );
  cbSymlink->setGeometry( 20, 10, 300, 30 );
  cbSymlink->setText( i18n("follow symbolic links") );
    
  cbConvLD = new QCheckBox( tabP3, "CheckBox_2" );
  cbConvLD->setGeometry( 20, 40, 300, 30 );
  cbConvLD->setText( i18n("convert leading dots") );

  cbFN32 = new QCheckBox( tabP3, "CheckBox_5" );
  cbFN32->setGeometry( 20, 70, 300, 30 );
  cbFN32->setText( i18n("filenames 32 characters long") );

  cbJoliet = new QCheckBox( tabP3, "CheckBox_4" );
  cbJoliet->setGeometry( 20, 100, 300, 30 );
  cbJoliet->setText( i18n("joliet") );

  cbTRANS = new QCheckBox( tabP3, "CheckBox_3" );
  cbTRANS->setGeometry( 20, 130, 300, 30 );
  cbTRANS->setText( i18n("create TRANS.TBL") );

  cbRR1 = new QCheckBox( tabP3, "CheckBox_8" );
  cbRR1->setGeometry( 20, 160, 300, 30 );
  cbRR1->setText( i18n("RockRidge without manipulation of flags") );

  cbRR2 = new QCheckBox( tabP3, "CheckBox_7" );
  cbRR2->setGeometry( 20, 190, 300, 30 );
  cbRR2->setText( i18n("RockRidge") );

  btnUnix = new QPushButton( tabP3, "PushButton_fsopt1" );
  btnUnix->setGeometry( 350, 20, 100, 30 );
  btnUnix->setText( i18n("Unix") );

  btnDOS = new QPushButton( tabP3, "PushButton_fsopt2" );
  btnDOS->setGeometry( 350, 60, 100, 30 );
  btnDOS->setText( i18n("DOS") );

  btnWin = new QPushButton( tabP3, "PushButton_fsopt3" );
  btnWin->setGeometry( 350, 100, 100, 30 );
  btnWin->setText( i18n("Win") );

  btnUnixWin = new QPushButton( tabP3, "PushButton_fsopt4" );
  btnUnixWin->setGeometry( 350, 140, 100, 30 );
  btnUnixWin->setText( i18n("Unix+Win") );

  connect(cbSymlink, SIGNAL (toggled(bool)), SLOT (followSymlinkToggled(bool)) );
  connect( btnDOS, SIGNAL(clicked()), SLOT(fsOptDOS()));  
  connect( btnUnix, SIGNAL(clicked()), SLOT(fsOptUnix()));  
  connect( btnWin, SIGNAL(clicked()), SLOT(fsOptWin()));  
  connect( btnUnixWin, SIGNAL(clicked()), SLOT(fsOptUnixWin()));  

  /************************ IDs ********************************/
  qtarch_LineEdit_6 = new QLineEdit( tabP4, "LineEdit_6" );
  qtarch_LineEdit_6->setGeometry( 100, 20, 190, 30 );
  qtarch_LineEdit_6->setMaxLength( 128 );
  
  qtarch_LineEdit_7 = new QLineEdit( tabP4, "LineEdit_7" );
  qtarch_LineEdit_7->setGeometry( 100, 60, 190, 30 );
  qtarch_LineEdit_7->setMaxLength( 128 );
  
  qtarch_LineEdit_8 = new QLineEdit( tabP4, "LineEdit_8" );
  qtarch_LineEdit_8->setGeometry( 370, 20, 190, 30 );
  qtarch_LineEdit_8->setMaxLength( 128 );
  
  qtarch_LineEdit_9 = new QLineEdit( tabP4, "LineEdit_9" );
  qtarch_LineEdit_9->setGeometry( 370, 60, 190, 30 );
  qtarch_LineEdit_9->setMaxLength( 32 );
  
  qtarch_Label_1 = new QLabel( tabP4, "Label_1" );
  qtarch_Label_1->setGeometry( 20, 20, 80, 30 );
  qtarch_Label_1->setText( i18n("Disc-ID") );
  
  qtarch_Label_2 = new QLabel( tabP4, "Label_2" );
  qtarch_Label_2->setGeometry( 20, 60, 80, 30 );
  qtarch_Label_2->setText( i18n("Publisher-ID") );
  
  qtarch_Label_3 = new QLabel( tabP4, "Label_3" );
  qtarch_Label_3->setGeometry( 300, 20, 70, 30 );
  qtarch_Label_3->setText( i18n("Preparer-ID") );

  qtarch_Label_4 = new QLabel( tabP4, "Label_4" );
  qtarch_Label_4->setGeometry( 300, 60, 70, 30 );
  qtarch_Label_4->setText( i18n("Volume-ID") );

  qtarch_LineEdit_6->setText(aktOpts->IDdisc.c_str());
  qtarch_LineEdit_9->setText(aktOpts->IDvolume.c_str());
  qtarch_LineEdit_8->setText(aktOpts->IDpreparer.c_str());
  qtarch_LineEdit_7->setText(aktOpts->IDpublisher.c_str());
   
  /***************** Einstellungen fr "filesystem" **********************************/
  /* knnen erst hier gemacht werden, weil sie indirekt 
     (SLOT-connected) andere beeinflussen! */
  cbSymlink->setChecked(  aktOpts->switches[0]);
  cbConvLD ->setChecked(!(aktOpts->switches[1]));
  cbTRANS  ->setChecked(  aktOpts->switches[5]);
  cbJoliet ->setChecked(  aktOpts->switches[4]);
  cbFN32   ->setChecked(  aktOpts->switches[3]);
  cbRR2    ->setChecked(  aktOpts->switches[7]);
  cbRR1    ->setChecked(  aktOpts->switches[8]);

  connect(cbRR2, SIGNAL (toggled(bool)), SLOT (CBRR1toggled(bool)) );
  connect(cbRR1, SIGNAL (toggled(bool)), SLOT (CBRR2toggled(bool)) );  

  /****************** Einstellungen fr "basics" ************************/
  QCheckBox_1->setChecked(aktOpts->fDummyWrite);
  QCheckBox_2->setChecked(aktOpts->fPadTrack);
  if (aktOpts->fMulti) QRadioButton_2->setChecked(true);
  else 
    if (aktOpts->fbootCD) QRadioButton_3->setChecked(true);
    else QRadioButton_1->setChecked(true);
  if (aktOpts->fCreateImage) QRadioButton_5->setChecked(true);
  else QRadioButton_4->setChecked(true);

  connect(QGroupBox_1, SIGNAL(clicked(int)), SLOT(updateDepsI(int)));
  connect(QGroupBox_1f, SIGNAL(clicked(int)), SLOT(updateDepsI(int)));

  /******* Einstellungen fr "multisession cd/bootable cd" ***********/
  if (aktOpts->fMultiFirstSess) QRadioButton_1f->setChecked(true);
  else 
    if (aktOpts->fMultiLastSess) QRadioButton_3f->setChecked(true);
    else QRadioButton_2f->setChecked(true);
  QLabel_1f->setText(aktOpts->bootImagePath.c_str());

  connect(QPushButton_1f, SIGNAL(clicked()), SLOT(bootbrowseClicked()));

  /******************************** allgemein **************************************/
  buttonSaveDefaults = new QPushButton( this, "PushButton_3" );
  buttonSaveDefaults->setGeometry( 15, 320, 180, 30 );
  buttonSaveDefaults->setText( i18n("save as defaults") );
  connect(buttonSaveDefaults, SIGNAL(clicked()), SLOT(setOptionsAsDefault()) );

  buttonOK = new QPushButton( this, "PushButton_5" );
  buttonOK->setGeometry( 244, 320, 110, 30 );
  buttonOK->setText( i18n("OK") );
  buttonOK->setDefault(true);
  connect(buttonOK, SIGNAL(clicked()), SLOT(ok_clicked()));

  buttonApply = new QPushButton( this, "PushButton_4" );
  buttonApply->setGeometry( 364, 320, 110, 30 );
  buttonApply->setText( i18n("Apply") );
  connect(buttonApply, SIGNAL(clicked()), SLOT(applyOptions()) );

  buttonCancel = new QPushButton( this, "PushButton_1" );
  buttonCancel->setGeometry( 484, 320, 110, 30 );
  buttonCancel->setText( i18n("Cancel") );
  connect(buttonCancel, SIGNAL(clicked()), SLOT(accept()));
     
  resize( 604, 363 );
  setMinimumSize( 604, 363 );
  setMaximumSize( 604, 363 );

  readGlobalConf();
  updateDeps();
}

void opt_cd::ok_clicked()
{
  applyOptions();
  emit(accept());
}

void opt_cd::readGlobalConf()
{
  /* Die Einstellungen aufgrund der globalen Konfig-datei vornehmen */

  // filesystem
  if (globalConf->readEntry("oFS_followSymLnk", "noValue") != "noValue")
    cbSymlink->setEnabled(false);
  if (globalConf->readEntry("oFS_convLdngDots", "noValue") != "noValue")
    cbConvLD->setEnabled(false);
  if (globalConf->readEntry("oFS_32char", "noValue") != "noValue")
    cbFN32->setEnabled(false);
  if (globalConf->readEntry("oFS_joliet", "noValue") != "noValue")
    cbJoliet->setEnabled(false);
  if (globalConf->readEntry("oFS_trans", "noValue") != "noValue")
    cbTRANS->setEnabled(false);
  if (globalConf->readEntry("oFS_RRchangeFlags", "noValue") != "noValue")
    cbRR2->setEnabled(false);
  if (globalConf->readEntry("oFS_RR", "noValue") != "noValue")
    cbRR1->setEnabled(false);

  // basics
  if (globalConf->readEntry("oBasics_createImgFile", "noValue") != "noValue")
    {
      QRadioButton_4->setEnabled(false);
      QRadioButton_5->setEnabled(false);
    }
  if (globalConf->readEntry("oBasics_dummyWrite", "noValue") != "noValue")
    QCheckBox_1->setEnabled(false);
  if (globalConf->readEntry("oBasics_padTrack", "noValue") != "noValue")
    QCheckBox_2->setEnabled(false);
  if (globalConf->readEntry("oBasics_createBootCD", "noValue") != "noValue")
    QRadioButton_3->setEnabled(false);
  if (globalConf->readEntry("oBasics_createMultiCD", "noValue") != "noValue")
    QRadioButton_2->setEnabled(false);
  if (QRadioButton_2->isEnabled() == false && QRadioButton_3->isEnabled() == false)
    QRadioButton_1->setEnabled(false);
  // bootable
  if (globalConf->readEntry("oBootCD_imgPath", "noValue") != "noValue")
    {
      QPushButton_1f->setEnabled(false);
      QGroupBox_2f->setEnabled(false);
      QLabel_1f->setEnabled(false);
      QLabel_2f->setEnabled(false);    
    }
}

void opt_cd::updateDeps()
// Jetzt mssen Abhngigkeiten behandelt werden:
{ 
  bool tmp;
  // Bootable:
  tmp = QRadioButton_3->isChecked() && (globalConf->readEntry("oBootCD_imgPath", "noValue") == "noValue");  
  QPushButton_1f->setEnabled(tmp);
  QGroupBox_2f->setEnabled(tmp);
  QLabel_1f->setEnabled(tmp);
  QLabel_2f->setEnabled(tmp);
  if (tmp) 
    {
      QPushButton_1f->show();
      QGroupBox_2f->show();
      QLabel_1f->show();
      QLabel_2f->show();    
    }
  else
    {
      QPushButton_1f->hide();
      QGroupBox_2f->hide();
      QLabel_1f->hide();
      QLabel_2f->hide();    
    }
  // Multisession:  
  QRadioButton_1f->setEnabled(QRadioButton_2->isChecked());
  QRadioButton_2f->setEnabled(QRadioButton_2->isChecked());
  QRadioButton_3f->setEnabled(QRadioButton_2->isChecked());  
  QGroupBox_1f->setEnabled(QRadioButton_2->isChecked());
  if (QRadioButton_2->isChecked())
    {
      QRadioButton_1f->show();
      QRadioButton_2f->show();
      QRadioButton_3f->show();  
      QGroupBox_1f->show();      
    }
  else
    {
      QRadioButton_1f->hide();
      QRadioButton_2f->hide();
      QRadioButton_3f->hide();  
      QGroupBox_1f->hide();      
    }
  
  if (QRadioButton_2->isChecked() && !QRadioButton_1f->isChecked())
    {
      QRadioButton_4->setEnabled(false);
      QRadioButton_5->setEnabled(false);
      QRadioButton_5->setChecked(true);
    }
  else
    {
      QRadioButton_4->setEnabled(true);
      QRadioButton_5->setEnabled(true);
    }

  // FS-Einstellungen bei Multisession
  if (QRadioButton_2->isChecked())
    {
      cbRR2->setChecked(false);
      cbRR1->setChecked(true);
      cbRR1->setEnabled(false);
      cbRR2->setEnabled(false);
    }
  else
    {
      cbRR1   ->setEnabled(true);
      cbRR2   ->setEnabled(true);
    }

  // die aus der globalen Datei sollen strker sein:
  readGlobalConf();
}

void opt_cd::updateDepsI(int dummy)
{
  updateDeps();
}

void opt_cd::bootbrowseClicked()
{
#ifdef slotLog
  cerr << "Slot: bootbrowseClicked\n";
  cerr.flush();
#endif
  string altName;
  altName = QLabel_1f->text();
  QString name= KFileDialog::getSaveFileName(holStartVerz(altName).c_str(), "*");    
  if (!name.isEmpty()) 
    {
      altName = name;
      if (altName[altName.size()-1] != '/' && existDat(altName)) QLabel_1f->setText(name);  
      else fehlermeldung(i18n("You have to name an existing file!"));
    }    
}

opt_cd::~opt_cd()
{
  /**** Filesystem *****/
  delete cbSymlink;
  delete cbConvLD;
  delete cbTRANS;
  delete cbJoliet;
  delete cbFN32;
  delete cbRR2;
  delete cbRR1;
  delete btnUnix;
  delete btnDOS; 
  delete btnWin;
  delete btnUnixWin; 

  /******** IDs *************/
  delete        qtarch_LineEdit_6; 
  delete        qtarch_LineEdit_7;
  delete        qtarch_LineEdit_8;
  delete        qtarch_LineEdit_9;
  delete        qtarch_Label_1;
  delete        qtarch_Label_2;
  delete        qtarch_Label_3;
  delete        qtarch_Label_4;

  /***** allgemein ********/
  delete tabP1;
  delete tabP3;
  delete tabP4;
  delete tabCtl;
  delete buttonCancel;
  delete buttonOK;
  delete buttonApply;
  delete buttonSaveDefaults;
}


void opt_cd::CBRR1toggled(bool state)
{
  if (state) 
    if (cbRR1->isEnabled()) cbRR1->setChecked(false);
}

void opt_cd::CBRR2toggled(bool state)
{
  if (state) 
    if (cbRR2->isEnabled()) cbRR2->setChecked(false);
}

void opt_cd::fsOptDOS()
  // betreffende Schalter aus
{  
#ifdef slotLog
  cerr << "Slot: fsOptDOS\n";
  cerr.flush();
#endif

  if (cbFN32->isEnabled())   cbFN32  ->setChecked(false);
  if (cbJoliet->isEnabled()) cbJoliet->setChecked(false);
  if (cbRR1->isEnabled())    cbRR1   ->setChecked(false);
  if (cbRR2->isEnabled())    cbRR2   ->setChecked(false);
  if (cbConvLD->isEnabled()) cbConvLD->setChecked(true);  
  if (cbTRANS->isEnabled())  cbTRANS ->setChecked(false);

  if ((cbFN32  ->isChecked() != false ||
       cbJoliet->isChecked() != false ||
       cbRR2   ->isChecked() != false ||
       cbRR1   ->isChecked() != false ||
       cbConvLD->isChecked() != true  ||
       cbTRANS ->isChecked() != false) && (QRadioButton_2->isChecked() == false))
     fehlermeldung(i18n("Because of restrictions your sysadmin made\n"
		   "this mode can not be correctly set!"));
}

void opt_cd::fsOptWin()
  // joliet an, allow dot an, long an
{
#ifdef slotLog
  cerr << "Slot: fsOptWin\n";
  cerr.flush();
#endif

  if (cbFN32->isEnabled())     cbFN32  ->setChecked(true);
  if (cbJoliet->isEnabled())   cbJoliet->setChecked(true);
  if (cbRR1->isEnabled())      cbRR1   ->setChecked(false);
  if (cbRR2->isEnabled())      cbRR2   ->setChecked(false);
  if (cbConvLD->isEnabled())   cbConvLD->setChecked(false);
  if (cbTRANS->isEnabled())    cbTRANS ->setChecked(false);

  if ((cbFN32  ->isChecked() != true ||
       cbJoliet->isChecked() != true ||
       cbRR2   ->isChecked() != false ||
       cbRR1   ->isChecked() != false ||
       cbConvLD->isChecked() != false ||
       cbTRANS ->isChecked() != false) && (QRadioButton_2->isChecked() == false))
    fehlermeldung(i18n("Because of restrictions your sysadmin made\n"
		  "this mode can not be correctly set!"));
}

void opt_cd::fsOptUnix()
  // RR, allow dot an, long an
{
#ifdef slotLog
  cerr << "Slot: fsOptUnix\n";
  cerr.flush();
#endif

  if (cbFN32->isEnabled())     cbFN32  ->setChecked(true);
  if (cbJoliet->isEnabled())   cbJoliet->setChecked(false);
  if (cbRR2->isEnabled())      cbRR2   ->setChecked(true);
  if (cbRR1->isEnabled())      cbRR1   ->setChecked(false);
  if (cbConvLD->isEnabled())   cbConvLD->setChecked(false);
  if (cbTRANS->isEnabled())    cbTRANS ->setChecked(false);

  if ((cbFN32  ->isChecked() != true ||
       cbJoliet->isChecked() != false ||
       cbRR2   ->isChecked() != true ||
       cbRR1   ->isChecked() != false ||
       cbConvLD->isChecked() != false ||
       cbTRANS ->isChecked() != false) && (QRadioButton_2->isChecked() == false))
    fehlermeldung(i18n("Because of restrictions your sysadmin made\n"
		  "this mode can not be correctly set!"));
}

void opt_cd::fsOptUnixWin()
  // RR, allow dot an, long an, joliet
{
#ifdef slotLog
  cerr << "Slot: fsOptUnixWin\n";
  cerr.flush();
#endif
  if (cbFN32->isEnabled())     cbFN32  ->setChecked(true);
  if (cbJoliet->isEnabled())   cbJoliet->setChecked(true);
  if (cbRR2->isEnabled())      cbRR2   ->setChecked(true);
  if (cbRR1->isEnabled())      cbRR1   ->setChecked(false);
  if (cbConvLD->isEnabled())   cbConvLD->setChecked(false);
  if (cbTRANS->isEnabled())    cbTRANS ->setChecked(false);
  
  if ((cbFN32  ->isChecked() != true ||
       cbJoliet->isChecked() != true ||
       cbRR2   ->isChecked() != true ||
       cbRR1   ->isChecked() != false ||
       cbConvLD->isChecked() != false ||
       cbTRANS ->isChecked() != false) && (QRadioButton_2->isChecked() == false))
    fehlermeldung(i18n("Because of restrictions your sysadmin made\n"
		  "this mode can not be correctly set!"));
}

void opt_cd::followSymlinkToggled(bool state)
{
  if (state) 
    infomeldung(i18n("You told me to follow symbolic links. Please make sure that you\n"
		"do not include links which cause a recursion. KisoCD will currently\n"
		"not recognize this and hang. So, if it hangs, disable it and try\n"
		"again. Of course mail me if the reason is not a recursion!"));
}

void opt_cd::setOptionsAsDefault()
{
  defOpts->switches[0] = cbSymlink->isChecked();
  defOpts->switches[1] = !(cbConvLD->isChecked());      
  defOpts->switches[5] = cbTRANS->isChecked();
  defOpts->switches[4] = cbJoliet->isChecked();
  defOpts->switches[3] = cbFN32->isChecked();
  defOpts->switches[7] = cbRR2->isChecked();
  defOpts->switches[8] = cbRR1->isChecked();

  defOpts->IDdisc      = qtarch_LineEdit_6->text();
  defOpts->IDvolume    = qtarch_LineEdit_9->text();
  defOpts->IDpreparer  = qtarch_LineEdit_8->text();
  defOpts->IDpublisher = qtarch_LineEdit_7->text();

  defOpts->fCreateImage   = QRadioButton_5->isChecked();
  defOpts->fDummyWrite    = QCheckBox_1->isChecked();
  defOpts->fPadTrack      = QCheckBox_2->isChecked();
  defOpts->fMulti         = QRadioButton_2->isChecked();
  defOpts->fbootCD        = QRadioButton_3->isChecked();

  defOpts->bootImagePath   = QLabel_1f->text();
  defOpts->fMultiFirstSess = QRadioButton_1f->isChecked();
  defOpts->fMultiLastSess  = QRadioButton_3f->isChecked();
}

void opt_cd::applyOptions()
{
  if (aktOpts->switches[0] != cbSymlink->isChecked()) *optsApplied = true;
  aktOpts->switches[0] = cbSymlink->isChecked();
  if (aktOpts->switches[1] != !(cbConvLD->isChecked())) *optsApplied = true;
  aktOpts->switches[1] = !(cbConvLD->isChecked());      
  if (aktOpts->switches[5] != cbTRANS->isChecked()) *optsApplied = true;
  aktOpts->switches[5] = cbTRANS->isChecked();
  if (aktOpts->switches[4] != cbJoliet->isChecked()) *optsApplied = true;
  aktOpts->switches[4] = cbJoliet->isChecked();
  if (aktOpts->switches[3] != cbFN32->isChecked()) *optsApplied = true;
  aktOpts->switches[3] = cbFN32->isChecked();
  if (aktOpts->switches[7] != cbRR2->isChecked()) *optsApplied = true;
  aktOpts->switches[7] = cbRR2->isChecked();
  if (aktOpts->switches[8] != cbRR1->isChecked()) *optsApplied = true;
  aktOpts->switches[8] = cbRR1->isChecked();

  if (aktOpts->IDdisc      != qtarch_LineEdit_6->text()) *optsApplied = true;
  aktOpts->IDdisc      = qtarch_LineEdit_6->text();
  if (aktOpts->IDvolume    != qtarch_LineEdit_9->text()) *optsApplied = true;
  aktOpts->IDvolume    = qtarch_LineEdit_9->text();
  if (aktOpts->IDpreparer  != qtarch_LineEdit_8->text()) *optsApplied = true;
  aktOpts->IDpreparer  = qtarch_LineEdit_8->text();
  if (aktOpts->IDpublisher != qtarch_LineEdit_7->text()) *optsApplied = true;
  aktOpts->IDpublisher = qtarch_LineEdit_7->text();

  if (aktOpts->fCreateImage   != QRadioButton_5->isChecked()) *optsApplied = true;
  aktOpts->fCreateImage   = QRadioButton_5->isChecked();
  if (aktOpts->fDummyWrite    != QCheckBox_1->isChecked()) *optsApplied = true;
  aktOpts->fDummyWrite    = QCheckBox_1->isChecked();
  if (aktOpts->fPadTrack    != QCheckBox_2->isChecked()) *optsApplied = true;
  aktOpts->fPadTrack    = QCheckBox_2->isChecked();
  if (aktOpts->fMulti         != QRadioButton_2->isChecked()) *optsApplied = true;
  aktOpts->fMulti         = QRadioButton_2->isChecked();
  if (aktOpts->fbootCD        != QRadioButton_3->isChecked()) *optsApplied = true;
  aktOpts->fbootCD        = QRadioButton_3->isChecked();

  if (aktOpts->bootImagePath   != QLabel_1f->text()) *optsApplied = true;
  aktOpts->bootImagePath   = QLabel_1f->text();
  if (aktOpts->fMultiFirstSess != QRadioButton_1f->isChecked()) *optsApplied = true;
  aktOpts->fMultiFirstSess = QRadioButton_1f->isChecked();
  if (aktOpts->fMultiLastSess  != QRadioButton_3f->isChecked()) *optsApplied = true;
  aktOpts->fMultiLastSess  = QRadioButton_3f->isChecked();  
}

#include "opt_cd.moc"















