/***************************************************************************
                          subprocessoutput.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Aug 20 1999                                           
    copyright            : (C) 1999 by Jens Wilhelm Wulf                         
    email                : jens_w2@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "subprocessoutput.h"

subprocessoutput::subprocessoutput(string      labelInhalt, 
				   QWidget     *parent, 
				   const char  *name,
				   bool        fModal,
				   bool        fehler) : QDialog(parent,name,fModal)
{
  int ykoor = 350;
  
  this->resize(430,480);
  this->setMinimumSize(430,480);
  this->setMaximumSize(430,480);
  QListBox_1= new QListBox(this,"NoName");
  QListBox_1->setGeometry(10,10,410, ykoor);
  
  QLabel_1= new QLabel(this,"NoName");
  QLabel_1->setGeometry(10,ykoor+10,410,50);

  QLabel_1->setText(labelInhalt.c_str());
  
  if (fModal)
    {
      b_abort = new QPushButton(this,"NoName");
      b_abort->setGeometry(210,ykoor+90,100,30);
      b_abort->setText(i18n("Abort"));

      if (!fehler)
	{
	  b_continue = new QPushButton(this,"NoName");
	  b_continue->setGeometry(320,ykoor+90,100,30);
	  b_continue->setText(i18n("Continue"));      
	  
	  connect(b_continue, SIGNAL(clicked()), SLOT(accept()) );
	}
      
      connect(b_abort, SIGNAL(clicked()), SLOT(reject()) );
    }
  else
    {
      b_close = new QPushButton(this,"NoName");
      b_close->setGeometry(320,ykoor+90,100,30);
      b_close->setText(i18n("Close"));      
      connect(b_close, SIGNAL(clicked()), SLOT(hide()) );
    }

  proc = NULL;
}

bool subprocessoutput::containsString(string aStr)
{
  bool   fContains = false;
  string teststr;
  
  for (unsigned int cnt = 0; cnt < QListBox_1->count(); cnt++)
    {
      teststr = QListBox_1->text(cnt);	  
      if (teststr.find(aStr) != string::npos) fContains = true;
    }
  return(fContains);
}

bool subprocessoutput::isRunning()
{
  bool tmp = false;

  if (proc != NULL)
    if (proc->isRunning()) tmp = true;
  
  return(tmp);
}

void subprocessoutput::newProc(string anInfo, string aCmd)
{
  str = "";
  teilAus = false;
  QListBox_1->clear();
  QLabel_1->setText(anInfo.c_str());
  proc = new KShellProcess(NULL);
  (*proc) << aCmd.c_str();

  connect(proc, SIGNAL (receivedStdout(KProcess *, char *, int)), 
	  SLOT(input(KProcess *, char *, int)));
  connect(proc, SIGNAL (receivedStderr(KProcess *, char *, int)), 
	  SLOT(input(KProcess *, char *, int)));  
}

string subprocessoutput::getLatestLineWith(string aStr, int pos)
  // Liefert die letzte Zeile, in der aStr vorkommt. Wenn pos == -1, muss
  // es nur vorkommen, ansonsten muss es an der Position pos stehen.
{
  string Ausgabe;
  string rueck;
  
  for (unsigned int cnt = 0; cnt < QListBox_1->count(); cnt++)
    {
      Ausgabe = QListBox_1->text(cnt);
      if (pos != -1)
	{
	  if (Ausgabe.find(aStr) == (unsigned int)pos) rueck = Ausgabe;
	}
      else
	{
	  if (Ausgabe.find(aStr) != string::npos) rueck = Ausgabe;
	}
    }
  
  return(rueck);
}

void subprocessoutput::input(KProcess *dummy, char *buffer, int buflen)
{
  bool            nonCtrl;
  string          tmp;
  int             Cnt;
  bool            dot = true;
  
  tmp = str;

  nonCtrl = (tmp.length() > 0);      
  
  for (Cnt= 0; Cnt< buflen; Cnt++)
    if (buffer[Cnt] != '.') dot = false;
  
  if (dot)
    {
      for (Cnt= 0; Cnt< buflen; Cnt++) tmp += buffer[Cnt];

      if (teilAus) QListBox_1->removeItem(QListBox_1->count()-1);
      QListBox_1->insertItem(tmp.c_str());
      teilAus = true;
    }
  else
    {  
      for (Cnt= 0; Cnt< buflen; Cnt++)
	{
	  if (iscntrl(buffer[Cnt])) 
	    {
	      if (buffer[Cnt] == '\n') nonCtrl = true;
	      
	      if (nonCtrl)
		{
		  if (teilAus) QListBox_1->removeItem(QListBox_1->count()-1);
		  QListBox_1->insertItem(tmp.c_str());
		  teilAus = false;
		  tmp = "";	 
		  nonCtrl = false;
		}     
	    }
	  else 
	    {
	      tmp+= buffer[Cnt];
	      nonCtrl = true;
	    }
	}
    }
  QListBox_1->setBottomItem(QListBox_1->count()-1);
  str = tmp;
}

subprocessoutput::~subprocessoutput()
{
}

#include "subprocessoutput.moc"









