/***************************************************************************
                              koncd.cpp  -  description
                             ------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include "koncd.h"
#include "copycd.h"
#include "mastercd.h"
#include "tools.h"
#include "setup.h"
#include "createdirstruc.h"

#define KONCD_VERSION "Version " VERSION

KOnCD::KOnCD(){
	setCaption( "KOnCD - CD Burner" );
	initDialog();
	setupMenubar();
	setupStatusbar();
	setupConnections();
}

KOnCD::~KOnCD(){
}

// Setup Connections
void KOnCD::setupConnections(){
	connect( QPushButton_exitapp, SIGNAL(clicked()), SLOT(slotQuit()) );
	connect( QPushButton_copycd, SIGNAL(clicked()), SLOT(slotCopyCD()) );
	connect( QPushButton_mastercd, SIGNAL(clicked()), SLOT(slotMasterCD()) );
	connect( QPushButton_Tools, SIGNAL(clicked()), SLOT(slotTools()) );
	connect( QPushButton_setup, SIGNAL(clicked()), SLOT(slotSetup()) );
	accel->connectItem( KAccel::Quit, this, SLOT( slotQuit() ) );
}

void KOnCD::setupMenubar(){
	// Create an KAccel instance
	accel = new KAccel( this );

	// Each entry in a menubar is of the type QPopupMenu. So we need at least one of them.
	QPopupMenu *p = new QPopupMenu;

	// Create a file menu, 'Config'
	p->insertItem( i18n( "&Setup" ), this, SLOT( slotSetup() ) );

	// Add a Seperator
	p->insertSeparator();

	// Create a file menu, 'CopyCD'
	p->insertItem( i18n( "&Copy CD" ), this, SLOT( slotCopyCD() ) );

	// Create a file menu, 'MasterCD'
	p->insertItem( i18n( "&Master CD" ), this, SLOT( slotMasterCD() ) );

	// Add a Seperator
	p->insertSeparator();

	// Create a file menu, 'File-Manager'
	p->insertItem( i18n( "&File Manager" ), this, SLOT( slotFileManager() ) );

	// Create a file menu, 'Tools'
	p->insertItem( i18n( "&Tools" ), this, SLOT( slotTools() ) );

	// Add a Seperator
	p->insertSeparator();

	// Create a file menu 'Quit' and tell KAccel to show the key in the menu.
	int id = p->insertItem( i18n( "&Quit" ), this, SLOT( slotQuit() ), CTRL+Key_Q);
	accel->changeMenuAccel( p, id, KAccel::Quit );

	// The file menu p goes into the menubar.
	menuBar()->insertItem( i18n( "&KOnCD" ), p );

	// ...about koncd
	p = kapp->getHelpMenu( false,
															i18n( "KOnCD - Burn your own CD's\n"
                               						KONCD_VERSION"\n"
			       										"(c) 2000 by Kai Heitkamp\n"
			       										"eMail:  koncd@kai-heitkamp.de\n"
					                               	"Web:    http://www.koncd.de" ) );
	menuBar()->insertSeparator();
	menuBar()->insertItem( i18n( "&Help" ), p );
}

// Create the statusbar
void KOnCD::setupStatusbar(){
  statusBar()->insertItem( i18n( "ready" ), STATUSBAR_READY );
}

// 'Setup' clicked
void KOnCD::slotSetup(){
	Setup* sdlg = new Setup;
	statusBar()->message( i18n( "Set Config..." ) );
	sdlg->show();
	statusBar()->message( i18n( "ready" ) );
}

// 'CopyCD-Button' clicked
void KOnCD::slotCopyCD(){
	CopyCD* sdlg = new CopyCD;
	statusBar()->message( i18n( "Copy CD..." ) );
	sdlg->show();
	statusBar()->message( i18n( "ready" ) );
}

// 'MasterCD-Button' clicked
void KOnCD::slotMasterCD(){
	MasterCD* sdlg = new MasterCD;
	statusBar()->message( i18n( "Master CD..." ) );
	sdlg->show();
	statusBar()->message( i18n( "ready" ) );
}

// 'File-Manager Menu' clicked
void KOnCD::slotFileManager(){
	CreateDirStruc* sdlg = new CreateDirStruc;
	statusBar()->message( i18n( "File-Manager..." ) );
	sdlg->show();
	statusBar()->message( i18n( "ready" ) );
}

// 'Tools-Button' clicked
void KOnCD::slotTools(){
	Tools* sdlg = new Tools;
	statusBar()->message( i18n( "CD Tools..." ) );
	sdlg->show();
	statusBar()->message( i18n( "ready" ) );
}

// 'Exit-Button' clicked
void KOnCD::slotQuit(){
	kapp->quit();  // Exit
}
