/***************************************************************************
                          audiocd.cpp  -  description
                             -------------------
    begin                : Fri Mar 9 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <ctype.h>
#include <stdlib.h>

#include <qdragobject.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qmultilineedit.h>
#include <qprogressbar.h>
#include <qradiobutton.h>
#include <qlabel.h>

#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kurldrag.h>

#include "audiocd.h"

static const char* const sound_icon_data[] = {
"22 22 310 2",
"Qt c None",
"aB c #008692",
"bn c #015157",
"a9 c #01626c",
"aS c #017a85",
"aj c #017f8c",
"a8 c #024f56",
"aR c #02616a",
"az c #02646d",
"aA c #026d75",
"ah c #02868f",
"ai c #028995",
"aQ c #035257",
"#2 c #039fa9",
"ay c #0b5e64",
"aP c #0d4d51",
"ax c #113a3c",
"ag c #148790",
"bm c #213e40",
"af c #215659",
"bD c #274041",
"a7 c #2b4749",
"#1 c #32c5d1",
"#L c #395156",
"bE c #3b7376",
"#K c #3ec9d4",
"#b c #3f3e3e",
"#q c #3f3f3f",
"#F c #414140",
"bB c #434240",
"#W c #434241",
"aw c #434341",
"bk c #444241",
"#Y c #447e82",
"bT c #455958",
"#v c #456a73",
".j c #484848",
"#0 c #4bc7d0",
".T c #4e7070",
".U c #4f5554",
".i c #505050",
"bQ c #524e49",
"#c c #525252",
".t c #545454",
"#H c #54797a",
".E c #565656",
"aO c #566f71",
"aC c #596a6c",
".5 c #5a5a5a",
"#d c #5a6b6b",
".3 c #5a7476",
"c# c #5b5852",
".u c #5b5b5b",
"#f c #5b9ea2",
".P c #5c5c5c",
"#w c #5e5e5e",
"cW c #605b54",
"#i c #606060",
"ck c #615a50",
"cx c #615a51",
"cY c #615b51",
"b6 c #615c53",
"cX c #615d53",
"cR c #615d57",
"cS c #615e59",
"#a c #616060",
"cV c #625c52",
"cU c #625c55",
"cQ c #625e5a",
"cT c #635c55",
"cP c #635e59",
"cO c #635f5c",
"cN c #64605b",
"cM c #646360",
"bC c #646666",
".h c #666666",
"cZ c #696865",
".4 c #6a6a6a",
"#g c #6d6d6d",
"cy c #70706e",
"#y c #707070",
".g c #727272",
"bH c #736f6a",
"#s c #738888",
".l c #747474",
"bo c #748f96",
"#h c #757575",
"#Z c #75cad1",
"bW c #777675",
"## c #797877",
"bU c #798c88",
"bR c #7a7a7a",
"#p c #7b7773",
".1 c #7b8888",
"b7 c #7c7c7c",
"#. c #7d7d7c",
".f c #7d7d7d",
"#N c #7d7e7e",
".2 c #7eafb2",
".9 c #7f7f7f",
"aT c #809192",
"#M c #818181",
"c. c #827e77",
"#x c #848484",
".0 c #848686",
"ca c #857e74",
".e c #858585",
".d c #878787",
"#J c #88dbe1",
"#I c #89c0c4",
".c c #8a8a8a",
"#u c #8adde3",
".R c #8b8b8b",
".V c #8b8d8d",
"bs c #8c8c8a",
".G c #8c8c8c",
".w c #8d8d8d",
".b c #8e8e8e",
"b. c #8e9a9b",
".# c #8f8f8f",
".S c #90a7a7",
"#7 c #919494",
"#G c #91a0a0",
"aY c #92928d",
".C c #929292",
"#e c #92c4c7",
".m c #939393",
"aF c #939490",
"bc c #94908a",
"ao c #949593",
"#8 c #949696",
".O c #959595",
"#t c #95c4c7",
".a c #969696",
"#5 c #989898",
"bX c #999286",
"bt c #9a948b",
".D c #9a9a9a",
"al c #9b9b9b",
"bV c #9c9d9c",
"#O c #9c9d9d",
"#o c #9f9b95",
".N c #a2a2a2",
"ak c #a4b2b3",
"#E c #a59f96",
"#6 c #a7a7a7",
"#4 c #a8a8a8",
"an c #a8aaaa",
"bl c #aaacac",
"bI c #aba397",
"#z c #ababab",
"cb c #afa595",
"bb c #b2b2b2",
"a6 c #b2b4b4",
".6 c #b3b3b3",
"bF c #b3bcbc",
".k c #b4b4b4",
"ae c #b4b6b6",
"#X c #b5b8b8",
".Q c #b6b6b6",
".F c #b7b7b7",
"bS c #b8b7b6",
"bY c #b9af9f",
".s c #b9b9b9",
".v c #bababa",
".Z c #bbbbbb",
"#r c #bbbcbc",
"aN c #bcbdbd",
"cp c #bdb3a3",
"bp c #bebebe",
"aE c #bec1c1",
"#V c #bfb8ab",
"aX c #bfc2c2",
"#n c #c1bfba",
"b# c #c1c1c1",
"cL c #c2a375",
"aU c #c2c2c2",
"co c #c4baac",
"cD c #c5b9a6",
"bu c #c5bcae",
"bd c #c5bdb2",
"#3 c #c5d4d5",
"aZ c #c6c0b7",
"ad c #c7bdab",
"aG c #c7c3bc",
"am c #c7c7c7",
"bG c #c8c8c8",
"cq c #c9bba7",
"ap c #c9c7c3",
"cE c #cab9a2",
"cc c #cabca8",
"cC c #cabdaa",
"cw c #cbae83",
"av c #cbbfab",
"cj c #ccaf87",
"cK c #ccb088",
"b5 c #ccb38c",
"aM c #ccbda6",
"cJ c #cdb38d",
"bP c #cdb693",
"bA c #cdb898",
"#D c #cdc8be",
"#9 c #cdccca",
"cI c #ceb592",
"bj c #cebb9d",
"a5 c #cebca3",
"bJ c #cec2b1",
"cH c #cfb998",
"cF c #cfbca1",
"bq c #cfcfcf",
"cB c #d0c6b9",
"cz c #d0ccc4",
"cG c #d1bc9e",
"#j c #d3d3d3",
"b9 c #d4cec6",
"cA c #d7cfc3",
"ba c #d7d7d7",
"cn c #d9d1c5",
".r c #d9d9d9",
"b8 c #dad8d4",
".B c #dadada",
"cr c #dbcab2",
"bZ c #dbcdb7",
"#m c #dbdbd8",
"#P c #dbdbdb",
".n c #dddddd",
"#U c #ded9cf",
"br c #dedede",
"cl c #dfdcd7",
"#C c #e1dfdb",
"cv c #e2c6a0",
"ci c #e2c7a1",
"cu c #e2c8a1",
"ch c #e3cba6",
"cd c #e3d2b9",
"bv c #e3d7c4",
".I c #e3e7e7",
"b4 c #e4cba7",
"ct c #e5cead",
"bi c #e5d5b9",
"bK c #e5d6c0",
"be c #e5daca",
".x c #e5e5e5",
"cg c #e6cfad",
"b3 c #e6cfae",
"bO c #e6d0af",
"bz c #e6d3b5",
"cs c #e6d4b7",
"a0 c #e6ddd1",
"ac c #e6ded2",
"cf c #e7d2b3",
"bN c #e7d3b4",
"aH c #e7e1d7",
".J c #e7e8e8",
"b2 c #e8d3b4",
"ce c #e8d5b9",
"b0 c #e8d7bd",
"a4 c #e8dac3",
".M c #e8e8e8",
"b1 c #e9d7ba",
"bM c #e9d7bb",
"by c #e9d7bc",
"aL c #e9ddc9",
"au c #e9dfd0",
"aV c #e9e9e9",
"aq c #eae6dd",
".q c #eaeaea",
"bL c #ebdac0",
"bh c #ebdac1",
"bx c #ebdbc1",
"a3 c #ebddc7",
"aK c #ebdfcf",
"cm c #ebe4d8",
".Y c #ebebeb",
"#T c #ece7df",
".7 c #ececec",
"bw c #eddec7",
"at c #ede4d7",
"ab c #ede6dc",
"a. c #ede9e4",
".p c #ededed",
"bg c #eedec8",
"bf c #efe1cd",
".o c #efefef",
"a2 c #f0e3cf",
"aJ c #f0e6d6",
"#B c #f0efed",
".W c #f0f0f0",
"a1 c #f1e6d5",
"as c #f1e9dc",
"aa c #f1ebe1",
"aI c #f2e9dc",
"aD c #f2f2f2",
"#S c #f3efe9",
"#Q c #f3f2ef",
"#l c #f3f3f3",
"ar c #f4ede3",
"aW c #f4f4f4",
".K c #f4f5f5",
"a# c #f6f1e9",
"#R c #f6f3ee",
"#k c #f6f6f6",
".H c #f8f9f9",
"#A c #f9f9f8",
".X c #fafafa",
".8 c #fbfbfb",
".A c #fcfcfc",
".L c #fdfdfd",
".z c #fefefe",
".y c #ffffff",
"QtQtQtQtQt.#.a.b.c.d.e.f.g.h.i.j.kQtQtQtQt.l",
"QtQtQtQtQt.m.n.o.o.o.o.p.q.r.s.t.u.vQtQtQt.l",
"QtQtQtQtQt.w.x.y.y.y.y.z.z.A.B.C.D.E.FQtQt.l",
"QtQtQtQtQt.G.x.H.I.J.K.L.L.y.M.N.q.O.P.QQt.l",
"QtQtQtQtQt.R.x.S.T.U.V.W.X.z.Y.O.p.o.O.E.Z.l",
"QtQtQtQtQt.0.1.2.3.4.5.6.7.8.o.9#.###a#b#c.l",
"QtQtQtQtQt#d#e#f.5#g#h#i#j#k.L#l#m#n#o#p#q.l",
"QtQtQt#r#s#t#u#v#w.l#x#y#z.Y.X#A#B#C#D#E#F.l",
"QtQt#G#H#I#J#K#L#i#M.m#N#O#P#Q#R#S#T#U#V#W.l",
"Qt#X#Y#Z#0#1#2#3#4#5#6#7#8#9a.a#aaabacad#W.l",
"Qtaeafagahaiajakalamamanaoapaqarasatauavaw.l",
"QtaeaxayazaAaBaC.9aD.paEaFaGaHaIaJaKaLaM#W.l",
"QtaNaOaPaQaRaSaTaUaVaWaXaYaZa0a1a2a3a4a5#W.l",
"QtQtQta6a7a8a9b.b#ba.pbbbcbdbebfbgbhbibjbk.l",
"QtQtQtQtblbmbnbobpbqbrbsbtbubvbwbxbybzbAbB.l",
"QtQtQtQtQtbCbDbEbFbG.ZbHbIbJbKbLbMbNbObPbQ.l",
"QtQtQtQtQtbRbSbTbUbVbWbXbYbZb0b1b2b3b4b5b6.l",
"QtQtQtQtQtb7b8b9c.c#cacbcccdcecfcgchcicjck.l",
"QtQtQtQtQtbRclcmcncocpcqcrcscfctchcucvcwcx.l",
"QtQtQtQtQtcyczcAcBcCcDcEcFcGcHcIcJcKcwcLcx.l",
"QtQtQtQtQtcMcNcNcOcPcQcRcScTcUcVcWcXcYcYcZ.l",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.l"};

//Constructor
AudioCD::AudioCD(QWidget *parent, const char *name ) : AudioCD_GUI(parent,name) {
	//allow drag 'n drop
 	setAcceptDrops( true );

	//Connects for 'QRadioButton_DaO' toogle and 'QRadioButton_TaO' toggle
	connect( QRadioButton_DaO, SIGNAL(clicked()), SLOT(slot_toggleTaO()) );
	connect( QRadioButton_TaO, SIGNAL(clicked()), SLOT(slot_toggleDaO()) );

	//Check for RW-Device
	KConfig *config = kapp->config();
	config->setGroup( "CD-Writer" );
	if ( config->readEntry( "isRW" ) == "false" ){
		QComboBox_CDRWBlanking->clear();	
		QComboBox_CDRWBlanking->insertItem(i18n( "None RW !" ));
		QComboBox_CDRWBlanking->setEnabled( false );
	}
}

AudioCD::~AudioCD(){
}

//'QRadioButton_TaO' clicked , toggle 'QRadioButton_DaO'
void AudioCD::slot_toggleDaO(){
	if ( ! QRadioButton_DaO->isChecked() ){
		QRadioButton_TaO->setChecked( true );
	}
	else{
		QRadioButton_TaO->setChecked( true );
		QRadioButton_DaO->setChecked( false );
	}
}

//'QRadioButton_DaO' clicked , toggle 'QRadioButton_TaO'
void AudioCD::slot_toggleTaO(){
	if ( ! QRadioButton_TaO->isChecked() ){
		QRadioButton_DaO->setChecked( true );
	}
	else{
		QRadioButton_TaO->setChecked( false );
		QRadioButton_DaO->setChecked( true );
	}
}

//'Add'-Button' clicked
void AudioCD::slot_addTrack(){
	//Set sound icon
	QPixmap sound_icon( ( const char** ) sound_icon_data );

	QStringList getName = KFileDialog::getOpenFileNames(0, "*.wav *.WAV", this, 0);
	for (QStringList::Iterator it = getName.begin();it!=getName.end();++it) {
		QListBox_Tracklist->insertItem( sound_icon, (const char*) (*it), -1 );
	}
}

//'Delete'-Button' clicked
void AudioCD::slot_deleteTrack(){
	QListBox_Tracklist->removeItem( QListBox_Tracklist->currentItem() );
}

//'Delete all tracks'-Button' clicked
void AudioCD::slot_deleteAllTracks(){
	QListBox_Tracklist->clear();
}

//'Start-Button' clicked
void AudioCD::slot_start(){
	int rc;
	KConfig *config = kapp->config();

	//KProcess argument
	KProcess *process = new KProcess();
	process->clearArguments();
	(*process) << "cdrecord" << "-v" << "-audio";

	//Set the CD-Writer first
	config->setGroup("CD-Writer");
	(*process) << config->readEntry("Device");

	//Set Burn-Proof
	if( config->readNumEntry("BurnProof") == true ) (*process) << "driveropts=burnproof";

	//Set CD-Writer Options to KProcess
	if( QCheckBox_EjectCD->isChecked() ) (*process) << "-eject";
	if( QCheckBox_Force->isChecked() ) (*process) << "-force";
	if( QCheckBox_Simulate->isChecked() ) (*process) << "-dummy";
	if( QCheckBox_padding->isChecked() ) (*process) << "-pad";
	if( QCheckBox_nofix->isChecked() ) (*process) << "-nofix";
	if( QCheckBox_ignoresize->isChecked() ) (*process) << "-ignsize";
	if( QRadioButton_DaO->isChecked() ) (*process) << "-dao";

	//Set CD-RW Options to KProcess
	if( (rc = QComboBox_CDRWBlanking -> currentItem()) )
		{
	   	if( rc == 1 ) (*process) << "blank=all";
	   	if( rc == 2 ) (*process) << "blank=fast";
	   	if( rc == 3 ) (*process) << "blank=track";
	   	if( rc == 4 ) (*process) << "blank=unreserve";
	   	if( rc == 5 ) (*process) << "blank=trtrail";
	   	if( rc == 6 ) (*process) << "blank=unclose";
	   	if( rc == 7 ) (*process) << "blank=session";
	   	}

	//Set CD-Writer Speed to KProcess)
	if( (rc = QComboBox_WriterSpeed -> currentItem()) )
		{
	   	if( rc == 0 ) (*process) << "speed=1";
	   	if( rc == 1 ) (*process) << "speed=2";
	   	if( rc == 2 ) (*process) << "speed=4";
	   	if( rc == 3 ) (*process) << "speed=6";
	   	if( rc == 4 ) (*process) << "speed=8";
	   	if( rc == 4 ) (*process) << "speed=10";
	   	if( rc == 4 ) (*process) << "speed=12";
	   	if( rc == 4 ) (*process) << "speed=16";
	   	}

	//Add tracks to be written
	int trackcount = 0;
	int tc = QListBox_Tracklist->count();
	do {
		(*process) << QListBox_Tracklist->text( trackcount );
		trackcount++;
	}
	while ( trackcount < tc );

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( procoutdlg.QPushButton_OK, SIGNAL(clicked()), this, SLOT(abort_handler()));

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slotBurnProcessExited(KProcess *)));

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotBurnRecStderr (KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotBurnRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMessageBox::error( 0, i18n("Audio CD:\nCould not start cdrecord !") );
		return;
		}

	procoutdlg.QPushButton_OK->setEnabled( false );
	if ( ! procoutdlg.isVisible() ) procoutdlg.show();

}

//KProcess outout analysis
void AudioCD::slotBurnRecStderr(KProcess *, char *buffer, int buflen) {
	char *c, buf[1024];
	int wrote, total, load;

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	//Add cdrecord Messages to the Output-Window
	procoutdlg.Output->insertLine( buf );
	//Go to the End of the Output-Text
	procoutdlg.Output->setCursorPosition(procoutdlg.Output->numLines(),0,false);
	
	//Blanking a CD-RW
	if( strstr( buf, "Blanking" )) {
		procoutdlg.StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	//Burn without Fixating
	if( strstr( buf, "Writing  time:" )) {
		procoutdlg.StatusLabel -> setText( i18n("Burn-Process complete.") );
	}

	//Fixating the CD-R
	if( strstr( buf, "Fixating..." )) {
		procoutdlg.StatusLabel -> setText( i18n("Writing TOC...") );
	}

	//	//Burn with Fixating
	if( strstr( buf, "Fixating time:" )) {
		procoutdlg.StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}
	
	if( strstr( buf, "MB written" )) {
		c = index( buf, ':' );
		if( c && *c ) {
			c = strtok( c, ":\r\t " );
			if( c ) {
				wrote = atoi( c );
				c = strtok( NULL, "\r\t " );
				c = strtok( NULL, "\r\t " );
				if( c ) {
					total = atoi( c );
					c = strtok( NULL, "\r" );
					c = strstr( c, "fifo " );
					if( c ) {
						c = strtok( c + 5, "%\r\t " );
						if( c ) {
							load = atoi( c );
							procoutdlg.WriteProgress -> setProgress( total ? wrote * 100 / total : 0 );
							procoutdlg.BufferProgress -> setProgress( load );

							if( ( total == wrote ) ) {
								procoutdlg.StatusLabel -> setText( i18n("Writing TOC...") );
							}
							
							if( wrote ) {
								if( QCheckBox_Simulate->isChecked() ) {
									procoutdlg.StatusLabel -> setText( i18n("Writing to CD in dummy mode...") );
								}
								else {
									procoutdlg.StatusLabel -> setText( i18n("Writing to CD...") );
								}
							}

						}
					}
				}
			}
		}		
	}	

}

//KProcess finished
void AudioCD::slotBurnProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				switch ( rcproc->exitStatus() )
				{
					case 13:		procoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
										break;

					case 19:		procoutdlg.StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
										break;

					case 254:	procoutdlg.StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
										break;

					case 255:	procoutdlg.StatusLabel -> setText( i18n( "Error: No CD in the Writer-Device" ) );
										break;
				}
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
				KMessageBox::error( 0, i18n("Audio CD:\nAn error is occurred !\n" + statusout) );
				procoutdlg.QPushButton_OK->setText( i18n( "&OK" ) );
				procoutdlg.QPushButton_OK->setEnabled( true );
				return;
			}
		//If 'Leave Image' CheckBox false, delete the Imagefile
		procoutdlg.QPushButton_OK->setText( i18n( "&OK" ) );
		procoutdlg.QPushButton_OK->setEnabled( true );
	}
}

//Abort-Handler
void AudioCD::abort_handler(){
	//Close dialog
	if ( procoutdlg.isVisible() ) procoutdlg.close();
	procoutdlg.StatusLabel->setText( i18n( "Prepare for write..." ) );
}

void AudioCD::dragEnterEvent(QDragEnterEvent* event){
  KURL::List urls;
  QString mimetype;

	//Check mimetype
  if ( KURLDrag::decode( event,urls ) && urls.count() > 0 ){
    KURL::List::ConstIterator it( urls.begin() );
    for( ;it != urls.end();  ++it ){
      if ( ( *it ).isLocalFile() ){
				KMimeType::Ptr typ = KMimeType::findByURL( ( *it ).path( 0 ),true );
				mimetype = typ->name();
      }
		}
	}

	//Isn't mimetype 'audio/x-wav', don't accept it !
	if ( mimetype == "audio/x-wav" ) event->accept( QUrlDrag::canDecode( event ) );
}

void AudioCD::dropEvent(QDropEvent *event){
	QStringList files;
	QPixmap sound_icon( ( const char** ) sound_icon_data );

	if ( QUrlDrag::decodeLocalFiles( event, files ) ) {
	  for (QStringList::Iterator i=files.begin(); i!=files.end(); ++i){
			QListBox_Tracklist->insertItem( sound_icon, (const char*) (*i), -1 );
		}
	}
}

//'Quit-Button' clicked
void AudioCD::slot_exit(){
	close( true );
}
