/***************************************************************************
                          mastercd.cpp  -  description
                             -------------------
    begin                : Tue Mar 6 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <ctype.h>
#include <stdlib.h>

#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qprogressbar.h>
#include <qmultilineedit.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "mastercd.h"
#include "imagetype.h"

MasterCD::MasterCD(QWidget *parent, const char *name ) : MasterCD_GUI(parent,name) {
	//Read Image-Type from config file and display it
	KConfig *config = kapp->config();
	config->setGroup("Image-Type");
	QLabel_ImageType->setText( config->readEntry( "Name" ) );

	//Check for RW-Device
	config->setGroup( "CD-Writer" );
	if ( config->readEntry( "isRW" ) == "false" )
	{
	QComboBox_CDRWBlanking->clear();	
	QComboBox_CDRWBlanking->insertItem(i18n( "None RW !" ));
	QComboBox_CDRWBlanking->setEnabled( false );
	}
}

MasterCD::~MasterCD(){
}

//'SourceDir-Button' clicked
void MasterCD::slot_setSourceDir(){
	QLineEdit_SourceDir->setText( KFileDialog::getExistingDirectory() );
}

//'File-Manager-Button' clicked
void MasterCD::slot_fileManager(){
}

//'ImageFile-Button' clicked
void MasterCD::slot_setImageFile(){
	QLineEdit_ImageFile->setText( KFileDialog::getSaveFileName() );
}

//'BootImage-Button' clicked
void MasterCD::slot_setBootImage(){
	QLineEdit_BootImage->setText( KFileDialog::getOpenFileName() );
}

//'Image-Type Button' clicked
void MasterCD::slot_imageType(){
	ImageType *sdlg = new ImageType;
	sdlg->show();

	//Read Image-Type from config file and display it
	KConfig *config = kapp->config();
	config->setGroup("Image-Type");
	QLabel_ImageType->setText( config->readEntry( "Name" ) );
}

//'QCheckBox_BootableCD' clicked , toggle BootableCD-QLineEdit and -Button
void MasterCD::slot_toggleBootableCD(){
	QLineEdit_BootImage->setEnabled( QCheckBox_BootableCD->isChecked() ? true:false );
	QPushButton_BootImage->setEnabled( QCheckBox_BootableCD->isChecked() ? true:false );
}

//'QCheckBox_WriteCD' clicked
void MasterCD::slot_toggleWriteCD(){
	QCheckBox_EjectCD->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_nofix->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_Simulate->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_Force->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_ignoresize->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_LeaveImage->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
}

//'QCheckBox_CreateImage' clicked
void MasterCD::slot_toggleCreateImage(){
	QCheckBox_BootableCD->setEnabled( QCheckBox_CreateImage->isChecked() ? true:false );
	QLineEdit_SourceDir->setEnabled( QCheckBox_CreateImage->isChecked() ? true:false );
	QPushButton_SourceDir->setEnabled( QCheckBox_CreateImage->isChecked() ? true:false );
}

//'QCheckBox_Multisession' clicked
void MasterCD::slot_multisession(){
	QCheckBox_nofix->setEnabled( QCheckBox_Multisession->isChecked() ? false:true );
	if ( QCheckBox_nofix->isChecked() ) QCheckBox_nofix->setChecked( false );
}

//'Start-Button' clicked
void MasterCD::slot_start(){
	//--CheckBox_CreateImage is true--
	if ( QCheckBox_CreateImage->isChecked() ) {
		//If not valid Source-Dir specified
		if( ! strlen( QLineEdit_SourceDir->text() ) ) {
			KMessageBox::error( 0, i18n("Master CD:\nNot valid Source-Dir !") );
			return;
		}
		//If not valid Image-File specified
		if( ! strlen( QLineEdit_ImageFile->text() ) ) {
			KMessageBox::error( 0, i18n("Master CD:\nNot valid Image-File !") );
			return;
		}
		//If QCheckBox_BootableCD enabled and not valid Boot-Image specified
		if( QCheckBox_BootableCD->isChecked() && ! strlen( QLineEdit_BootImage->text() ) ) {
			KMessageBox::error( 0, i18n("Master CD:\nNot valid Boot-Image !") );
			return;
		}
		//Check for ImageType
		if( ! strlen( QLabel_ImageType->text() ) ) {
			KMessageBox::error( 0, i18n("Master CD:\nNot valid Image-Type !") );
			return;
		}
		//If multisession
		if ( QCheckBox_Multisession->isChecked() ) slot_MSInfo();

		//Create the CD-Image
		else slot_makeImage();
	}

	//--CheckBox_WriteCD is true--
	if ( QCheckBox_WriteCD->isChecked() && ! QCheckBox_CreateImage->isChecked() ) {
		//If the Imagefile exists, than write the CD
		if ( ! QFile::exists( QLineEdit_ImageFile->text() ) ) {
			KMessageBox::error( 0, i18n("Master CD:\nThe Imagefile does not exists !") );
			return;
		}
		//Write the CD
		slot_writeCD();
		}
}

//---Create CD-Image with mkisofs---
void MasterCD::slot_makeImage(){
	KConfig *config = kapp->config();

	//KProcess arguments
	KProcess *process = new KProcess();
	process->clearArguments();
 	(*process) << "mkisofs" << "-f";

	//Image-Type
	config->setGroup("Image-Type");
	if ( config->readEntry( "Allowlongfilenames" ) == "true" ) (*process) << "-l";
	if ( config->readEntry( "Rockridgeextensions" ) == "true" ) (*process) << "-R";
	if ( config->readEntry( "Rockridgewithanonymity" ) == "true" ) (*process) << "-r";
	if ( config->readEntry( "Jolietextensions" ) == "true" ) (*process) << "-J";
	if ( config->readEntry( "Omittrailingperiods" ) == "true" ) (*process) << "-d";
	if ( config->readEntry( "Dontusedeepdirrelocations" ) == "true" ) (*process) << "-D";
	if ( config->readEntry( "Allowfilesbeginningwithadot" ) == "true" ) (*process) << "-L";
	if ( config->readEntry( "Omitisoversionnumbers" ) == "true" ) (*process) << "-N";

	//Arguments for multisession
	if ( QCheckBox_Multisession->isChecked() && existsSession == true ) {
		char tmp[50], dev[10], outdev[10];
		char *tmpdev;
		sprintf( tmp, "%d,%d", MS_Start, MS_End );
	 	(*process) << "-C" << tmp;
		config->setGroup("CD-Writer");
		strcpy(dev, config->readEntry("Device"));
		printf("%s\n", strtok(dev, "="));
		while ( (tmpdev=strtok(NULL, "=")) != NULL)
		strcpy(outdev, tmpdev);
		(*process) << "-M" << outdev;
	}

	//Bootable CD
	if( QCheckBox_BootableCD->isChecked() ) (*process) << "-b" << QLineEdit_BootImage->text() << "-c" << "boot_catalog";

	//CD-Identification
	if( QLineEdit_AppID->text() ) (*process) << "-A" << QLineEdit_AppID->text();
	if( QLineEdit_Publisher->text() ) (*process) << "-P" << QLineEdit_Publisher->text();
	if( QLineEdit_Preparer->text() ) (*process) << "-p" << QLineEdit_Preparer->text();
	if( QLineEdit_VolumeID->text() ) (*process) << "-V" << QLineEdit_VolumeID->text();

	//Image-File and Source-Dir
	(*process) << "-o" << QLineEdit_ImageFile->text() << QLineEdit_SourceDir->text();

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( imgprocoutdlg.Button, SIGNAL(clicked()), this, SLOT(abort_handler()));

	//Connect the 'processExited' Signal to the 'slotBurnProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slot_makeImageProcessExited(KProcess *)));

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slot_makeImageStdout(KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slot_makeImageStdout(KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) KMessageBox::error( 0, i18n("Create Image:\nCould not start mkisofs !") );

	imgprocoutdlg.StatusLabel -> setText( i18n("Creating CD-Image...") );
	imgprocoutdlg.Button->setEnabled( false );
	if ( ! imgprocoutdlg.isVisible() ) imgprocoutdlg.show();
}

//---Write CD with cdrecord---
void MasterCD::slot_writeCD(){
	int rc;
	KConfig *config = kapp->config();

	//KProcess argument
	KProcess *process = new KProcess();
	process->clearArguments();
	(*process) << "cdrecord" << "-v";

	//Set the CD-Writer first
	config->setGroup("CD-Writer");
	(*process) << config->readEntry("Device");

	//Set Burn-Proof
	if( config->readNumEntry("BurnProof") == true ) (*process) << "driveropts=burnproof";

	//Set CD-Writer Options to KProcess
	if( QCheckBox_EjectCD->isChecked() ) (*process) << "-eject";
	if( QCheckBox_Force->isChecked() ) (*process) << "-force";
	if( QCheckBox_Multisession->isChecked() ) (*process) << "-multi";
	if( QCheckBox_Simulate->isChecked() ) (*process) << "-dummy";
	if( QCheckBox_nofix->isChecked() ) (*process) << "-nofix";
	if( QCheckBox_ignoresize->isChecked() ) (*process) << "-ignsize";

	//Set CD-RW Options to KProcess
	if( (rc = QComboBox_CDRWBlanking -> currentItem()) )
		{
	   	if( rc == 1 ) (*process) << "blank=all";
	   	if( rc == 2 ) (*process) << "blank=fast";
	   	if( rc == 3 ) (*process) << "blank=track";
	   	if( rc == 4 ) (*process) << "blank=unreserve";
	   	if( rc == 5 ) (*process) << "blank=trtrail";
	   	if( rc == 6 ) (*process) << "blank=unclose";
	   	if( rc == 7 ) (*process) << "blank=session";
	   	}

	//Set CD-Writer Speed to KProcess)
	if( (rc = QComboBox_WriterSpeed -> currentItem()) )
		{
	   	if( rc == 0 ) (*process) << "speed=1";
	   	if( rc == 1 ) (*process) << "speed=2";
	   	if( rc == 2 ) (*process) << "speed=4";
	   	if( rc == 3 ) (*process) << "speed=6";
	   	if( rc == 4 ) (*process) << "speed=8";
	   	if( rc == 4 ) (*process) << "speed=10";
	   	if( rc == 4 ) (*process) << "speed=12";
	   	if( rc == 4 ) (*process) << "speed=16";
	   	}

	//Set the Image
	(*process) << QLineEdit_ImageFile->text();

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( procoutdlg.QPushButton_OK, SIGNAL(clicked()), this, SLOT(abort_handler()));

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slot_burnProcessExited(KProcess *)));

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slot_burnRecStderr (KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slot_burnRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMessageBox::error( 0, i18n("Write CD:\nCould not start cdrecord !") );
		return;
		}

	procoutdlg.QPushButton_OK->setEnabled( false );
	if ( ! procoutdlg.isVisible() ) procoutdlg.show();
}

//'Calculate-Button' clicked
void MasterCD::slot_calculateSize() {
	//If not valid Source-Dir specified
	if( ! strlen( QLineEdit_SourceDir->text() ) ) {
		KMessageBox::error( 0, i18n("Calculate size:\nNot valid Source-Dir !") );
		return;
	}

	QPushButton_Start->setEnabled( false );
	QPushButton_Quit->setEnabled( false );
	QPushButton_Calculate->setText( "working..." );
	setCaption( i18n( "KOnCD - Master CD: Calculating CD-Image size" ) );

	//Start KProcess for calculating ISO-Image size with mkisofs
	KProcess *process = new KProcess();
	process->clearArguments();
 	(*process) << "mkisofs" << "-print-size" << "-f";

	//Source-Dir
	QString sdir = QLineEdit_SourceDir->text();
	if( sdir == "User defined ISO-Tree !" ) (*process) << "/tmp/isoimage/";
	else (*process) << QLineEdit_SourceDir->text();

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slot_calculateProcessExited(KProcess *)));

	//Connect with all Signals from KProcess to Slot 'slotRecStderr'
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slot_calculateRecStderr (KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slot_calculateRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) KMessageBox::error( 0, i18n("Calculate size:\nCould not start mkisofs !") );

}

//KProcess finished
void MasterCD::slot_calculateProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
				KMessageBox::error( 0, i18n("Calculate:\nAn error is occurred !") );
				QPushButton_Start->setEnabled( true );
				QPushButton_Quit->setEnabled( true );
				QPushButton_Calculate->setText(i18n("&Calculate"));
				setCaption( i18n( "KOnCD - Master CD" ) );
				return;
			}
		QPushButton_Start->setEnabled( true );
		QPushButton_Quit->setEnabled( true );
		QPushButton_Calculate->setText(i18n("&Calculate"));
		setCaption( i18n( "KOnCD - Master CD" ) );
	}
}

//KProcess outout analysis
void MasterCD::slot_calculateRecStderr( KProcess *, char *buffer, int buflen) {
	char *c, buf[1024];

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	if( strstr( buf, "written =" ) ) {
		if( (c = rindex( buf, ' ' ) ) ) {		
			int s = atoi( c ) * 2 / 1024;
			char tmp[50];
			sprintf( tmp, "%d MB", s );
			QLabel_DataSize->setText( tmp );

			if( s > 650 && s < 730 ) {
				KMessageBox::sorry( 0, i18n("Calculate size:\nThe CD-Image becomes over 650 MB !\n"
																  "The 'Ignore medium size' options must be enabled\n"
																  "and use a CD-R 700 or higher !" ) );
				QCheckBox_ignoresize->setChecked( true );
				return;
			}
			if( s > 730 ) {
				KMessageBox::sorry( 0, i18n("Calculate size:\nThe CD-Image becomes over 730 MB !\n"
   																   "You can't write that on a CD-R !" ) );
				return;
			}

		}
	}
}

//KProcess outout analysis
void MasterCD::slot_burnRecStderr(KProcess *, char *buffer, int buflen) {
	char *c, buf[1024];
	int wrote, total, load;

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	//Add cdrecord Messages to the Output-Window
	procoutdlg.Output->insertLine( buf );
	//Go to the End of the Output-Text
	procoutdlg.Output->setCursorPosition(procoutdlg.Output->numLines(),0,false);

	printf( buf );

	//Blanking a CD-RW
	if( strstr( buf, "Blanking" )) {
		procoutdlg.StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	//Burn without Fixating
	if( strstr( buf, "Writing  time:" )) {
		procoutdlg.StatusLabel -> setText( i18n("Burn-Process complete.") );
	}

	//Fixating the CD-R
	if( strstr( buf, "Fixating..." )) {
		procoutdlg.StatusLabel -> setText( i18n("Writing TOC...") );
	}

	//	//Burn with Fixating
	if( strstr( buf, "Fixating time:" )) {
		procoutdlg.StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}
	
	if( strstr( buf, "MB written" )) {
		c = index( buf, ':' );
		if( c && *c ) {
			c = strtok( c, ":\r\t " );
			if( c ) {
				wrote = atoi( c );
				c = strtok( NULL, "\r\t " );
				c = strtok( NULL, "\r\t " );
				if( c ) {
					total = atoi( c );
					c = strtok( NULL, "\r" );
					c = strstr( c, "fifo " );
					if( c ) {
						c = strtok( c + 5, "%\r\t " );
						if( c ) {
							load = atoi( c );
							procoutdlg.WriteProgress->setProgress( total ? wrote * 100 / total : 0 );
							procoutdlg.BufferProgress->setProgress( load );

							if( ( total == wrote ) ) {
								procoutdlg.StatusLabel->setText( i18n("Writing TOC...") );
							}
							
							if( wrote ) {
								if( QCheckBox_Simulate->isChecked() ) {
									procoutdlg.StatusLabel -> setText( i18n("Writing to CD in dummy mode...") );
								}
								else {
									procoutdlg.StatusLabel -> setText( i18n("Writing to CD...") );
								}
							}

						}
					}
				}
			}
		}		
	}	

}

//KProcess finished
void MasterCD::slot_burnProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				switch ( rcproc->exitStatus() )
				{
					case 13:		procoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
										break;

					case 19:		procoutdlg.StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
										break;

					case 254:	procoutdlg.StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
										break;

					case 255:	procoutdlg.StatusLabel -> setText( i18n( "Error: No CD in the Writer-Device !" ) );
										break;
				}
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
				KMessageBox::error( 0, i18n("Write CD:\nAn error is occurred !\n" + statusout) );
				procoutdlg.QPushButton_OK->setText( "&OK" );
				procoutdlg.QPushButton_OK->setEnabled( true );
				return;
			}
		//If 'Leave Image' CheckBox false, delete the Imagefile
		if ( rcproc->exitStatus() == 0 && ! QCheckBox_LeaveImage->isChecked() ) QFile::remove( QLineEdit_ImageFile->text() );
		procoutdlg.QPushButton_OK->setText( "&OK" );
		procoutdlg.QPushButton_OK->setEnabled( true );
	}
}

//KProcess outout analysis
void MasterCD::slot_makeImageStdout(KProcess *, char *buffer, int buflen) {
	char *c, buf[1024];

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );

	//Add cdrecord Messages to the Output-Window
	imgprocoutdlg.Output->insertLine( buf );
	//Go to the End of the Output-Text
	imgprocoutdlg.Output->setCursorPosition(imgprocoutdlg.Output->numLines(),0,false);

	if( strstr( buf, "extents written" ) ) {
		imgprocoutdlg.ImgProgress->setProgress( 100 );
		return;
	}

	if( strstr( buf, "% done" ) ) {
		if( (c = strtok( buf, "%" ) ) ) {
			imgprocoutdlg.ImgProgress->setProgress( atoi( c ) );
		}
	}
}

//KProcess finished
void MasterCD::slot_makeImageProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				if( rcproc->exitStatus() == 13 ) imgprocoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
				KMessageBox::error( 0, i18n("Create cd image:\nAn error is occurred !\n" + statusout) );
				imgprocoutdlg.Button->setText( "&OK" );
				imgprocoutdlg.Button->setEnabled( true );
				return;
			}
			//If CheckBox 'Write CD' checked, close the dialog and write the CD
			else if ( QCheckBox_WriteCD->isChecked() ){
				imgprocoutdlg.StatusLabel -> setText( i18n("Image creating completed.") );
				//Close ProcessDialog
				imgprocoutdlg.close();
				slot_writeCD();
			}
			else {
				imgprocoutdlg.StatusLabel -> setText( i18n("Image creating completed.") );
				imgprocoutdlg.Button->setText( "&OK" );
				imgprocoutdlg.Button->setEnabled( true );
			}
	}
}

//KProcess for multisession info
void MasterCD::slot_MSInfo() {
	KConfig *config = kapp->config();

	//KProcess arguments
	KProcess *process = new KProcess();
	process->clearArguments();
 	(*process) << "cdrecord";
	config->setGroup("CD-Writer");
	(*process) << config->readEntry("Device") << "-msinfo";

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( imgprocoutdlg.Button, SIGNAL(clicked()), this, SLOT(abort_handler()));

	//Connect the 'processExited' Signal
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT( slot_MSInfoExited( KProcess * ) ));

	//Connect with slotRecStderr to update KProgress
	connect( process, SIGNAL(receivedStdout(KProcess *, char *, int) ), this, SLOT( slot_MSOutput(KProcess *, char *, int ) ));
	connect( process, SIGNAL(receivedStderr(KProcess *, char *, int) ), this, SLOT( slot_MSOutput(KProcess *, char *, int ) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) KMessageBox::error( 0, i18n("MSInfo:\nCould not start cdrecord !") );

	imgprocoutdlg.StatusLabel -> setText( i18n("Retrieve multisession info...") );
	imgprocoutdlg.show();
}

//KProcess Analyse for msinfo output
void MasterCD::slot_MSOutput( KProcess *, char *s, int n ){
	char *c, *b, buf[1024];

	if( !n ) return;
	
	bzero( buf, sizeof( buf ) );
	strncpy( buf, s, n > (int) sizeof( buf ) ? sizeof(buf) - 1 : n );

	//Check for exists session
	if( strstr( buf, "status: 0x2 (CHECK CONDITION)" )) {
		imgprocoutdlg.StatusLabel -> setText( i18n( "None session available, creating image..." ) );
		existsSession = false;
  }
	else {
		existsSession = true;
	}

	c = strtok( buf, "\n" );
	while( c ) {
  	if( (b = strchr( c, ',' )) && isdigit( *c ) ) {
  		b = strtok( c, ",\n" );
  		if( b ) MS_Start = atoi( b );
  		b = strtok( NULL, ",\n" );
  		if( b ) MS_End = atoi( b );
  	}
		c = strtok( NULL, "\n" );	
	}
}

//KProcess 'msinfo' finished
void MasterCD::slot_MSInfoExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				switch ( rcproc->exitStatus() )
				{
					case 13:		imgprocoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
										break;

					case 19:		imgprocoutdlg.StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
										break;

					case 254:	imgprocoutdlg.StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
										break;

					case 255:	imgprocoutdlg.StatusLabel -> setText( i18n( "Error: No CD in the Writer-Device !" ) );
										break;
				}
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
				KMessageBox::error( 0, i18n("MSInfo:\nAn error is occurred !\n" + statusout) );
				imgprocoutdlg.Button->setText( "&OK" );
				return;
			}
		//Create the Image
		slot_makeImage();
	}
}

//Abort-Handler
void MasterCD::abort_handler(){
	//Close dialogs
	if ( imgprocoutdlg.isVisible() ) imgprocoutdlg.close();
	if ( procoutdlg.isVisible() ) procoutdlg.close();
}

//'Quit-Button' clicked
void MasterCD::slot_quit(){
	close(true);
}
