/***************************************************************************
                          imagetype.cpp  -  description
                             -------------------
    begin                : Sun Mar 4 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <qcombobox.h>
#include <qcheckbox.h>

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include "imagetype.h"

ImageType::ImageType(QWidget *parent, const char *name, bool modal) : ImageType_GUI(parent,name,modal) {
	connect( QComboBox_ImageType, SIGNAL(activated(int)), SLOT(slot_imageTypeChange(int)) );
	readImageType();
}

ImageType::~ImageType(){
}

//Read the Imagetype and settings from config file
void ImageType::readImageType(){
	KConfig *config = kapp->config();

	config->setGroup( "Image-Type" );

	//Read name from configfile and set ComboBox
	if ( config->readEntry( "Name" ) == "Unix Rock-Ridge" ) QComboBox_ImageType->setCurrentItem( 0 );
	if ( config->readEntry( "Name" ) == "Rock-Ridge + Win9x/NT" ) QComboBox_ImageType->setCurrentItem( 1 );
	if ( config->readEntry( "Name" ) == "Win9x/NT (long filenames)" || config->readEntry( "Name" ) == "Win9x/NT (lange Dateinamen)") QComboBox_ImageType->setCurrentItem( 2 );
	if ( config->readEntry( "Name" ) == "MS-Dos" ) QComboBox_ImageType->setCurrentItem( 3 );
	if ( config->readEntry( "Name" ) == "Custom" || config->readEntry( "Name" ) == "Benutzerdefiniert") QComboBox_ImageType->setCurrentItem( 4 );

	//Read settings from configfile and set the CheckBoxes
	QCheckBox_Allowlongfilenames->setChecked( config->readBoolEntry( "Allowlongfilenames" ) );
	QCheckBox_Rockridgeextensions->setChecked( config->readBoolEntry( "Rockridgeextensions" ) );
	QCheckBox_Rockridgewithanonymity->setChecked( config->readBoolEntry( "Rockridgewithanonymity" ) );
	QCheckBox_Jolietextensions->setChecked( config->readBoolEntry( "Jolietextensions" ) );
	QCheckBox_Omittrailingperiods->setChecked( config->readBoolEntry( "Omittrailingperiods" ) );
	QCheckBox_Dontusedeepdirrelocations->setChecked( config->readBoolEntry( "Dontusedeepdirrelocations" ) );
	QCheckBox_Allowfilesbeginningwithadot->setChecked( config->readBoolEntry( "Allowfilesbeginningwithadot" ) );
	QCheckBox_Omitisoversionnumbers->setChecked( config->readBoolEntry( "Omitisoversionnumbers" ) );
	QCheckBox_Dontincludebackupfiles->setChecked( config->readBoolEntry( "Dontincludebackupfiles" ) );
	QCheckBox_DontuseRR->setChecked( config->readBoolEntry( "DontuseRR" ) );
	QCheckBox_CreateTRANS_TBLfiles->setChecked( config->readBoolEntry( "CreateTRANS_TBLfiles" ) );
	QCheckBox_HideRR_MOVEDdir->setChecked( config->readBoolEntry( "HideRR_MOVEDdir" ) );
	QCheckBox_FollowSymbolicLinks->setChecked( config->readBoolEntry( "FollowSymbolicLinks" ) );
	QCheckBox_HideTRANS_TBLfiles->setChecked( config->readBoolEntry( "HideTRANS_TBLfiles" ) );
	QCheckBox_Untranslatedfiles->setChecked( config->readBoolEntry( "Untranslatedfiles" ) );
}

//QComboBox_ImageType change
void ImageType::slot_imageTypeChange( int index ){
	switch ( index )
	{
		//Unix Rock-Ridge
		case 0:	QCheckBox_Allowlongfilenames->setChecked( true );
						QCheckBox_Rockridgeextensions->setChecked( false );
						QCheckBox_Rockridgewithanonymity->setChecked( true );
						QCheckBox_Jolietextensions->setChecked( false );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( false );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( true );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						QCheckBox_Dontincludebackupfiles->setChecked( false );
						QCheckBox_DontuseRR->setChecked( false );
						QCheckBox_CreateTRANS_TBLfiles->setChecked( false );
						QCheckBox_HideRR_MOVEDdir->setChecked( false );
						QCheckBox_FollowSymbolicLinks->setChecked( false );
						QCheckBox_HideTRANS_TBLfiles->setChecked( false );
						QCheckBox_Untranslatedfiles->setChecked( false );
						break;

		//Rock-Ridge + Win9x/NT
		case 1:	QCheckBox_Allowlongfilenames->setChecked( true );
						QCheckBox_Rockridgeextensions->setChecked( true );
						QCheckBox_Rockridgewithanonymity->setChecked( false );
						QCheckBox_Jolietextensions->setChecked( true );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( true );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( true );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						QCheckBox_Dontincludebackupfiles->setChecked( false );
						QCheckBox_DontuseRR->setChecked( false );
						QCheckBox_CreateTRANS_TBLfiles->setChecked( false );
						QCheckBox_HideRR_MOVEDdir->setChecked( false );
						QCheckBox_FollowSymbolicLinks->setChecked( false );
						QCheckBox_HideTRANS_TBLfiles->setChecked( false );
						QCheckBox_Untranslatedfiles->setChecked( false );
						break;

		//Win9x/NT (long filenames)
		case 2:	QCheckBox_Allowlongfilenames->setChecked( true );
						QCheckBox_Rockridgeextensions->setChecked( true );
						QCheckBox_Rockridgewithanonymity->setChecked( true );
						QCheckBox_Jolietextensions->setChecked( true );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( true );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( true );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						QCheckBox_Dontincludebackupfiles->setChecked( false );
						QCheckBox_DontuseRR->setChecked( false );
						QCheckBox_CreateTRANS_TBLfiles->setChecked( false );
						QCheckBox_HideRR_MOVEDdir->setChecked( false );
						QCheckBox_FollowSymbolicLinks->setChecked( false );
						QCheckBox_HideTRANS_TBLfiles->setChecked( false );
						QCheckBox_Untranslatedfiles->setChecked( false );
						break;

		//MS-DOS
		case 3:	QCheckBox_Allowlongfilenames->setChecked( false );
						QCheckBox_Rockridgeextensions->setChecked( false );
						QCheckBox_Rockridgewithanonymity->setChecked( false );
						QCheckBox_Jolietextensions->setChecked( false );
						QCheckBox_Omittrailingperiods->setChecked( false );
						QCheckBox_Dontusedeepdirrelocations->setChecked( false );
						QCheckBox_Allowfilesbeginningwithadot->setChecked( false );
						QCheckBox_Omitisoversionnumbers->setChecked( false );
						QCheckBox_Dontincludebackupfiles->setChecked( false );
						QCheckBox_DontuseRR->setChecked( false );
						QCheckBox_CreateTRANS_TBLfiles->setChecked( false );
						QCheckBox_HideRR_MOVEDdir->setChecked( false );
						QCheckBox_FollowSymbolicLinks->setChecked( false );
						QCheckBox_HideTRANS_TBLfiles->setChecked( false );
						QCheckBox_Untranslatedfiles->setChecked( false );
						break;
	}

}

//One oth the CheckButtons are clicked
void ImageType::slot_changeCustomType(){
	QComboBox_ImageType->setCurrentItem( 4 );
}

//'OK and Save Button' clicked
void ImageType::slot_save(){
	KConfig *config = kapp->config();

	//Save Image-Type config
	config->setGroup( "Image-Type" );
	config->writeEntry( "Name", QComboBox_ImageType->currentText() );
	config->writeEntry( "Allowlongfilenames", QCheckBox_Allowlongfilenames->isChecked() );
	config->writeEntry( "Rockridgeextensions", QCheckBox_Rockridgeextensions->isChecked() );
	config->writeEntry( "Rockridgewithanonymity", QCheckBox_Rockridgewithanonymity->isChecked() );
	config->writeEntry( "Jolietextensions", QCheckBox_Jolietextensions->isChecked() );
	config->writeEntry( "Omittrailingperiods", QCheckBox_Omittrailingperiods->isChecked() );
	config->writeEntry( "Dontusedeepdirrelocations", QCheckBox_Dontusedeepdirrelocations->isChecked() );
	config->writeEntry( "Allowfilesbeginningwithadot", QCheckBox_Allowfilesbeginningwithadot->isChecked() );
	config->writeEntry( "Omitisoversionnumbers", QCheckBox_Omitisoversionnumbers->isChecked() );
	config->writeEntry( "Dontincludebackupfiles", QCheckBox_Dontincludebackupfiles->isChecked() );
	config->writeEntry( "DontuseRR", QCheckBox_DontuseRR->isChecked() );
	config->writeEntry( "CreateTRANS_TBLfiles", QCheckBox_CreateTRANS_TBLfiles->isChecked() );
	config->writeEntry( "HideRR_MOVEDdir", QCheckBox_HideRR_MOVEDdir->isChecked() );
	config->writeEntry( "FollowSymbolicLinks", QCheckBox_FollowSymbolicLinks->isChecked() );
	config->writeEntry( "HideTRANS_TBLfiles", QCheckBox_HideTRANS_TBLfiles->isChecked() );
	config->writeEntry( "Untranslatedfiles", QCheckBox_Untranslatedfiles->isChecked() );

	close( true );
}

//'Quit-Button' clicked
void ImageType::slot_quit(){
	close( true );
}
