// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include <qobject.h>
#include <qpixmap.h>

#include <ktreelist.h>
#include <kfileinfocontents.h>
#include <kfileinfo.h>

class FileTree;
class FileTreeItem;
class ISOFile;

class FileTreeItem : public QObject, public KTreeListItem
 {
  Q_OBJECT

  public:
    FileTreeItem(KFileInfo *fileinfo,FileTree *parent);
    FileTreeItem(ISOFile   *isofile,FileTree *parent);
    FileTreeItem(FileTree *parent);
    ~FileTreeItem(void);

    void expandTree(void);
    void collapseTree(void);
    void expandSubTree(void);
    void collapseSubTree(void);

    bool deleteObject(void);
    bool fileName(QString *filename);
    bool addISOObject(ISOFile *isofile,bool addit=true);

  protected:
    void addItemSorted(FileTreeItem *item,bool immed=true);

  private slots:
    void newFiles(const KFileInfoList *infos);
    void addChildItems(void);

  private:
    void getFilename(class QString *fname,class KFileInfo *finfo);
    void setupDirObject(void);

    KFileInfo            *fileObject;
    KDir                 *dirObject;
    QList<FileTreeItem>  *fileList;
    ISOFile              *isoFile;
    FileTree             *parentTree;
    bool                  isDirExpanded;
    bool                  isDir;
    bool                  inList;
    FileTreeItem         *dummyItem;
    FileTreeItem         *parentItem;
 };

class FileTree : public KTreeList
 {
  Q_OBJECT

  public:
    FileTree(QWidget *parent=0,const char *name=0,WFlags flags=0);
    ~FileTree(void);
    void addDir(KFileInfo *finfo);
    void addDir(ISOFile   *isofile);

    bool addRealObject(QString *fname);
    bool createISODir(const char *dirname);
    bool deleteObject(void);

    bool getSelected(QString *fname);

  protected slots:
    void collapsedTree(int index);
    void expandedTree(int index);

  private slots:
    void changeSelect(int index);

  private:
    FileTreeItem *itemAt(int index);

    FileTreeItem *currentItem;
 };

typedef QList<FileTreeItem> FileTreeItems;
