// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include <qwidget.h>
#include <qlistview.h>

#define MAX_TRACKS_PER_PROJECT               120
#define TRACK_COLUMNS                          4

class MainWindow : public QWidget
 {
  Q_OBJECT;
  public:
         MainWindow( QWidget *parent=0, const char *name=0 );
         ~MainWindow(void);

  protected:
         void resizeEvent(QResizeEvent *qresize);
         void saveProjectToConfig(class KConfig *kc);
         void loadProjectFromConfig(class KConfig *kc);
         void checkWidgetEnable(void);

  protected slots:
         void menuMoved(void); 
         void saveSession(void);
         void addTrack(void);
         void editTrack(void);
         void deleteTrack(void);
         void moveUp(void);  
         void moveDown(void);
         void updateTrack(void);
         void writeCD(void);

         void newProject(void);
         void openProject(void);
         void saveProject(void);
         void saveProjectAs(void);
         void setupCopy(void);


         void changeCurrent(QListViewItem *item);
         void helpContents(void);
         void helpAboutMe(void);
         void configSCSI(void);
         void configPath(void);

         void notifyCloseSCSIWin(void);
         void notifyCloseTWin(void);
         void notifyClosePathWin(void);
         void updateTrackItem(void);
         void updateTrackSum(void);

         void normalizeMax(void);
         void normalizeAllSame(void);
  private:
         void readColWidth(void);
         void writeColWidth(void);

         int FirstInvoke;
         int Colwidth[TRACK_COLUMNS];
         
         class KMenuBar      *MWMenu;
         
         class QWidget       *MainWidget;
         class QListView     *MWTracklist;
         class QPushButton   *MWAddTrack;
         class QPushButton   *MWEditTrack;
         class QPushButton   *MWDeleteTrack;
         class QPushButton   *MWTrackUp;
         class QPushButton   *MWTrackUpdate;
         class QPushButton   *MWTrackDown;
         class QPushButton   *MWWriteCD;

         class QLabel        *SumLabel; 

         class TrackWindow   *TrackEdit;
         int                  CurrentTrack;

         class QListViewItem *TrackItems[MAX_TRACKS_PER_PROJECT];
         class CDTrack       *ProjectTracks[MAX_TRACKS_PER_PROJECT];
         class ConfSCSI      *SCSIWindow;
         class ConfPath      *PathWindow;
         char                 ProjectPath[1024];


 };

