// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>

class FileTree;
class ISOImage;
class ISOFile;
class QPushButton;


class ISOWindow : public QWidget
 {
  Q_OBJECT;
  public:
         ISOWindow( QWidget *parent, const char *name,class ISOImage *isoimage);
         ~ISOWindow(void);
         void hide(void);
  signals:
         void needUpdate(void);
         void imageChanged(void);
         void closed(void);

  protected slots:
         void addFile(void);
         void createDir(void);
         void deleteObject(void);
         void cancelPressed(void);
         
  private:
         FileTree    *sourceTree;
         FileTree    *isoTree;
         QPushButton *addButton;
         QPushButton *createDirButton;
         QPushButton *deleteButton;


         ISOImage *isoImage;
         ISOFile  *backupTree;
 };

