// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioBuildImage.h"
#include "AudioFile.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>
#include <klocale.h>

extern KLocale *locale;

AudioBuildImage::AudioBuildImage(AudioFile *afil):AudioFileConvert(afil,buildImageHFork,0)
 {

 }


int AudioBuildImage::buildImageHFork(AudioFileOp *afi,const char *fn)
 {
  int rv;
  rv=((AudioBuildImage *) (afi))->buildImageFork(fn,0);
  if (rv)
   {
    fprintf(stdout,"#OK#\n");
   }
   else
   {
    fprintf(stdout,"#ERROR#\n");
   }
  return(0);
 }

int AudioBuildImage::buildImage(const char *fn)
 {
  char xtext[128];
  int retval;

  setForkArgument(fn);
  prepareProcess();

  sprintf(xtext,locale->translate("Converting audio track to CD-R format\n"));
  setWorkText(xtext);
  ImagizeFlag=0;

  retval=startProcess(false);
  if (retval==-1)
   {
    retval=0;
    remove(fn);
   }
 closeProcess();
  return(retval);
 }


int AudioBuildImage::processExited(void)
 {
  return(ImagizeFlag);
 }

bool AudioBuildImage::processStdoutLine(char *linebuffer)
 {
   if (strncmp("#OK#",linebuffer,4)==0)
    {
     ImagizeFlag=1;
     return(true);
    }
   if (strncmp("#ERROR#",linebuffer,7)==0)
     {
     ImagizeFlag=0;
     return(true);
    }

 if (strncmp("#PROGRESS#",linebuffer,10)==0)
    {
     char *xptr,*yptr;
     unsigned long int cur,max;
     xptr=linebuffer+10;
     while (*xptr==' ') ++xptr;
     if (*xptr==0) return(true);
     cur=strtoul(xptr,&yptr,10);
     xptr=yptr;
     while (*xptr==' ') ++xptr;
     if (*xptr==0) return(true);
     max=strtoul(xptr,&yptr,10);
     setProgress(cur,max,true);
    }

  return(true);
 }

