// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioRipper.h"
#include "uidcontrol.h"

#include <klocale.h>
#include <kprocess.h>

#include <qmessagebox.h>

#include <stdio.h>
#include <string.h>

extern KLocale *locale;

bool AudioRipper::ripAudio(int track,const char *filename)
 {
  char progressline[64];
  int retval;

  prepareProcess();
  trackSize=999999;

  if (!doRip(track,filename))
   {
    closeProcess();
    return(false);
   }

  sprintf(progressline,locale->translate("Extracting audio track %d from CD..."),track);
  setWorkText(progressline);

  ripflag=0;

  retval=startProcess();
#ifndef STRICT_PERMISSIONS
  getRootRights();
  chown(filename,getuid(),getgid());
  dropRootRights();
#endif
  if (retval!=1) remove(filename);
  if (retval==-2)
   {
#if QT_VERSION >= 200
    QMessageBox::critical(0,QString::null,locale->translate("Unable to read audio track!"));
#else
    QMessageBox::critical(0,0,locale->translate("Unable to read audio track!"));
#endif
   }

  closeProcess();
  if (retval!=1) return(false);

  return(true);
 }


void AudioRipper::startTrack(long int size)
 {
  trackSize=size;
  setProgress(0,trackSize);
 }

void AudioRipper::setPosition(long int pos)
 {
  setProgress(pos,trackSize,true);
 }

bool AudioRipper::doRip(int ,const char *)
 {
  return(false);
 }

int AudioRipper::processExited(void)
 {
  return(ripflag?1:-2);
 }
